/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.SequencedMessage;
import com.google.cloud.pubsublite.proto.SeekRequest;
import com.google.common.collect.Ordering;
import java.util.Comparator;

public final class Predicates {
    public static boolean isOrdered(Iterable<SequencedMessage> messages) {
        return Ordering.from(Comparator.comparingLong(m -> m.offset().value())).isStrictlyOrdered(messages);
    }

    public static boolean isValidSeekRequest(SeekRequest request) {
        switch (request.getTargetCase()) {
            case CURSOR: {
                return request.getCursor().getOffset() >= 0L;
            }
            case NAMED_TARGET: {
                switch (request.getNamedTarget()) {
                    case HEAD: 
                    case COMMITTED_CURSOR: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private Predicates() {
    }
}

