/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.RoutingPolicy;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class DefaultRoutingPolicy
implements RoutingPolicy {
    private final long numPartitions;
    private final CloseableMonitor monitor = new CloseableMonitor();
    @GuardedBy(value="monitor.monitor")
    private long nextWithoutKeyPartition;

    public DefaultRoutingPolicy(long numPartitions) throws ApiException {
        UncheckedApiPreconditions.checkArgument(numPartitions > 0L, "Must have a positive number of partitions.");
        this.numPartitions = numPartitions;
        this.nextWithoutKeyPartition = ThreadLocalRandom.current().nextLong(numPartitions);
        this.nextWithoutKeyPartition = new Random().longs(1L, 0L, numPartitions).findFirst().getAsLong();
    }

    @Override
    public Partition routeWithoutKey() throws ApiException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            Partition toReturn = Partition.of(this.nextWithoutKeyPartition);
            long next = this.nextWithoutKeyPartition + 1L;
            this.nextWithoutKeyPartition = next %= this.numPartitions;
            Partition partition = toReturn;
            return partition;
        }
    }

    @Override
    public Partition route(ByteString messageKey) throws ApiException {
        HashCode code = Hashing.sha256().hashBytes(messageKey.asReadOnlyByteBuffer());
        UncheckedApiPreconditions.checkArgument(code.bits() == 256);
        BigInteger bigEndianValue = new BigInteger(1, code.asBytes());
        return Partition.of(bigEndianValue.mod(BigInteger.valueOf(this.numPartitions)).longValueExact());
    }
}

