package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SinglePartitionPublisherBuilder extends SinglePartitionPublisherBuilder {

  private final TopicPath topic;

  private final Partition partition;

  private final Optional<PublisherServiceClient> serviceClient;

  private final Optional<BatchingSettings> batchingSettings;

  private final PubsubContext context;

  private final PublisherBuilder.Builder underlyingBuilder;

  private AutoValue_SinglePartitionPublisherBuilder(
      TopicPath topic,
      Partition partition,
      Optional<PublisherServiceClient> serviceClient,
      Optional<BatchingSettings> batchingSettings,
      PubsubContext context,
      PublisherBuilder.Builder underlyingBuilder) {
    this.topic = topic;
    this.partition = partition;
    this.serviceClient = serviceClient;
    this.batchingSettings = batchingSettings;
    this.context = context;
    this.underlyingBuilder = underlyingBuilder;
  }

  @Override
  TopicPath topic() {
    return topic;
  }

  @Override
  Partition partition() {
    return partition;
  }

  @Override
  Optional<PublisherServiceClient> serviceClient() {
    return serviceClient;
  }

  @Override
  Optional<BatchingSettings> batchingSettings() {
    return batchingSettings;
  }

  @Override
  PubsubContext context() {
    return context;
  }

  @Override
  PublisherBuilder.Builder underlyingBuilder() {
    return underlyingBuilder;
  }

  @Override
  public String toString() {
    return "SinglePartitionPublisherBuilder{"
        + "topic=" + topic + ", "
        + "partition=" + partition + ", "
        + "serviceClient=" + serviceClient + ", "
        + "batchingSettings=" + batchingSettings + ", "
        + "context=" + context + ", "
        + "underlyingBuilder=" + underlyingBuilder
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SinglePartitionPublisherBuilder) {
      SinglePartitionPublisherBuilder that = (SinglePartitionPublisherBuilder) o;
      return this.topic.equals(that.topic())
          && this.partition.equals(that.partition())
          && this.serviceClient.equals(that.serviceClient())
          && this.batchingSettings.equals(that.batchingSettings())
          && this.context.equals(that.context())
          && this.underlyingBuilder.equals(that.underlyingBuilder());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topic.hashCode();
    h$ *= 1000003;
    h$ ^= partition.hashCode();
    h$ *= 1000003;
    h$ ^= serviceClient.hashCode();
    h$ *= 1000003;
    h$ ^= batchingSettings.hashCode();
    h$ *= 1000003;
    h$ ^= context.hashCode();
    h$ *= 1000003;
    h$ ^= underlyingBuilder.hashCode();
    return h$;
  }

  static final class Builder extends SinglePartitionPublisherBuilder.Builder {
    private TopicPath topic;
    private Partition partition;
    private Optional<PublisherServiceClient> serviceClient = Optional.empty();
    private Optional<BatchingSettings> batchingSettings = Optional.empty();
    private PubsubContext context;
    private PublisherBuilder.Builder underlyingBuilder;
    Builder() {
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setTopic(TopicPath topic) {
      if (topic == null) {
        throw new NullPointerException("Null topic");
      }
      this.topic = topic;
      return this;
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setPartition(Partition partition) {
      if (partition == null) {
        throw new NullPointerException("Null partition");
      }
      this.partition = partition;
      return this;
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setServiceClient(PublisherServiceClient serviceClient) {
      this.serviceClient = Optional.of(serviceClient);
      return this;
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setBatchingSettings(BatchingSettings batchingSettings) {
      this.batchingSettings = Optional.of(batchingSettings);
      return this;
    }
    @Override
    public SinglePartitionPublisherBuilder.Builder setContext(PubsubContext context) {
      if (context == null) {
        throw new NullPointerException("Null context");
      }
      this.context = context;
      return this;
    }
    @Override
    SinglePartitionPublisherBuilder.Builder setUnderlyingBuilder(PublisherBuilder.Builder underlyingBuilder) {
      if (underlyingBuilder == null) {
        throw new NullPointerException("Null underlyingBuilder");
      }
      this.underlyingBuilder = underlyingBuilder;
      return this;
    }
    @Override
    SinglePartitionPublisherBuilder autoBuild() {
      String missing = "";
      if (this.topic == null) {
        missing += " topic";
      }
      if (this.partition == null) {
        missing += " partition";
      }
      if (this.context == null) {
        missing += " context";
      }
      if (this.underlyingBuilder == null) {
        missing += " underlyingBuilder";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SinglePartitionPublisherBuilder(
          this.topic,
          this.partition,
          this.serviceClient,
          this.batchingSettings,
          this.context,
          this.underlyingBuilder);
    }
  }

}
