package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.batching.BatchingSettings;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.v1.PublisherServiceClient;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PublisherBuilder extends PublisherBuilder {

  private final TopicPath topic;

  private final Partition partition;

  private final BatchingSettings batching;

  private final Optional<PublisherServiceClient> serviceClient;

  private final PubsubContext context;

  private AutoValue_PublisherBuilder(
      TopicPath topic,
      Partition partition,
      BatchingSettings batching,
      Optional<PublisherServiceClient> serviceClient,
      PubsubContext context) {
    this.topic = topic;
    this.partition = partition;
    this.batching = batching;
    this.serviceClient = serviceClient;
    this.context = context;
  }

  @Override
  TopicPath topic() {
    return topic;
  }

  @Override
  Partition partition() {
    return partition;
  }

  @Override
  BatchingSettings batching() {
    return batching;
  }

  @Override
  Optional<PublisherServiceClient> serviceClient() {
    return serviceClient;
  }

  @Override
  PubsubContext context() {
    return context;
  }

  @Override
  public String toString() {
    return "PublisherBuilder{"
        + "topic=" + topic + ", "
        + "partition=" + partition + ", "
        + "batching=" + batching + ", "
        + "serviceClient=" + serviceClient + ", "
        + "context=" + context
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PublisherBuilder) {
      PublisherBuilder that = (PublisherBuilder) o;
      return this.topic.equals(that.topic())
          && this.partition.equals(that.partition())
          && this.batching.equals(that.batching())
          && this.serviceClient.equals(that.serviceClient())
          && this.context.equals(that.context());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topic.hashCode();
    h$ *= 1000003;
    h$ ^= partition.hashCode();
    h$ *= 1000003;
    h$ ^= batching.hashCode();
    h$ *= 1000003;
    h$ ^= serviceClient.hashCode();
    h$ *= 1000003;
    h$ ^= context.hashCode();
    return h$;
  }

  static final class Builder extends PublisherBuilder.Builder {
    private TopicPath topic;
    private Partition partition;
    private BatchingSettings batching;
    private Optional<PublisherServiceClient> serviceClient = Optional.empty();
    private PubsubContext context;
    Builder() {
    }
    @Override
    public PublisherBuilder.Builder setTopic(TopicPath topic) {
      if (topic == null) {
        throw new NullPointerException("Null topic");
      }
      this.topic = topic;
      return this;
    }
    @Override
    public PublisherBuilder.Builder setPartition(Partition partition) {
      if (partition == null) {
        throw new NullPointerException("Null partition");
      }
      this.partition = partition;
      return this;
    }
    @Override
    public PublisherBuilder.Builder setBatching(BatchingSettings batching) {
      if (batching == null) {
        throw new NullPointerException("Null batching");
      }
      this.batching = batching;
      return this;
    }
    @Override
    public PublisherBuilder.Builder setServiceClient(PublisherServiceClient serviceClient) {
      this.serviceClient = Optional.of(serviceClient);
      return this;
    }
    @Override
    public PublisherBuilder.Builder setContext(PubsubContext context) {
      if (context == null) {
        throw new NullPointerException("Null context");
      }
      this.context = context;
      return this;
    }
    @Override
    PublisherBuilder autoBuild() {
      String missing = "";
      if (this.topic == null) {
        missing += " topic";
      }
      if (this.partition == null) {
        missing += " partition";
      }
      if (this.batching == null) {
        missing += " batching";
      }
      if (this.context == null) {
        missing += " context";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PublisherBuilder(
          this.topic,
          this.partition,
          this.batching,
          this.serviceClient,
          this.context);
    }
  }

}
