/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;

class CommitState {
    private final Queue<FutureWithOffset> pastConnectionFutures = new ArrayDeque<FutureWithOffset>();
    private final Queue<FutureWithOffset> currentConnectionFutures = new ArrayDeque<FutureWithOffset>();

    CommitState() {
    }

    Optional<Offset> reinitializeAndReturnToSend() {
        if (this.currentConnectionFutures.isEmpty()) {
            return Optional.empty();
        }
        while (this.currentConnectionFutures.size() > 1) {
            this.pastConnectionFutures.add(this.currentConnectionFutures.remove());
        }
        return Optional.of(this.currentConnectionFutures.peek().offset);
    }

    ApiFuture<Void> addCommit(Offset offset) {
        FutureWithOffset futureWithOffset = new FutureWithOffset();
        futureWithOffset.offset = offset;
        this.currentConnectionFutures.add(futureWithOffset);
        return futureWithOffset.future;
    }

    void complete(long numComplete) throws CheckedApiException {
        if (numComplete > (long)this.currentConnectionFutures.size()) {
            CheckedApiException error = new CheckedApiException(String.format("Received %s completions, which is more than the commits outstanding for this stream.", numComplete), StatusCode.Code.FAILED_PRECONDITION);
            this.abort(error);
            throw error;
        }
        while (!this.pastConnectionFutures.isEmpty()) {
            this.pastConnectionFutures.remove().future.set(null);
        }
        int i = 0;
        while ((long)i < numComplete) {
            this.currentConnectionFutures.remove().future.set(null);
            ++i;
        }
    }

    void abort(CheckedApiException error) {
        while (!this.pastConnectionFutures.isEmpty()) {
            this.pastConnectionFutures.remove().future.setException((Throwable)error);
        }
        while (!this.currentConnectionFutures.isEmpty()) {
            this.currentConnectionFutures.remove().future.setException((Throwable)error);
        }
    }

    boolean isEmpty() {
        return this.pastConnectionFutures.isEmpty() && this.currentConnectionFutures.isEmpty();
    }

    private static class FutureWithOffset {
        SettableApiFuture<Void> future = SettableApiFuture.create();
        Offset offset;

        private FutureWithOffset() {
        }
    }
}

