/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.internal.wire.CommitterSettings;
import com.google.cloud.pubsublite.v1.CursorServiceClient;

final class AutoValue_CommitterSettings
extends CommitterSettings {
    private final SubscriptionPath subscriptionPath;
    private final Partition partition;
    private final CursorServiceClient serviceClient;

    private AutoValue_CommitterSettings(SubscriptionPath subscriptionPath, Partition partition, CursorServiceClient serviceClient) {
        this.subscriptionPath = subscriptionPath;
        this.partition = partition;
        this.serviceClient = serviceClient;
    }

    @Override
    SubscriptionPath subscriptionPath() {
        return this.subscriptionPath;
    }

    @Override
    Partition partition() {
        return this.partition;
    }

    @Override
    CursorServiceClient serviceClient() {
        return this.serviceClient;
    }

    public String toString() {
        return "CommitterSettings{subscriptionPath=" + this.subscriptionPath + ", partition=" + this.partition + ", serviceClient=" + this.serviceClient + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CommitterSettings) {
            CommitterSettings that = (CommitterSettings)o;
            return this.subscriptionPath.equals(that.subscriptionPath()) && this.partition.equals(that.partition()) && this.serviceClient.equals(that.serviceClient());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subscriptionPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.partition.hashCode();
        h$ *= 1000003;
        return h$ ^= this.serviceClient.hashCode();
    }

    static final class Builder
    extends CommitterSettings.Builder {
        private SubscriptionPath subscriptionPath;
        private Partition partition;
        private CursorServiceClient serviceClient;

        Builder() {
        }

        @Override
        public CommitterSettings.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
            if (subscriptionPath == null) {
                throw new NullPointerException("Null subscriptionPath");
            }
            this.subscriptionPath = subscriptionPath;
            return this;
        }

        @Override
        public CommitterSettings.Builder setPartition(Partition partition) {
            if (partition == null) {
                throw new NullPointerException("Null partition");
            }
            this.partition = partition;
            return this;
        }

        @Override
        public CommitterSettings.Builder setServiceClient(CursorServiceClient serviceClient) {
            if (serviceClient == null) {
                throw new NullPointerException("Null serviceClient");
            }
            this.serviceClient = serviceClient;
            return this;
        }

        @Override
        public CommitterSettings build() {
            String missing = "";
            if (this.subscriptionPath == null) {
                missing = missing + " subscriptionPath";
            }
            if (this.partition == null) {
                missing = missing + " partition";
            }
            if (this.serviceClient == null) {
                missing = missing + " serviceClient";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CommitterSettings(this.subscriptionPath, this.partition, this.serviceClient);
        }
    }
}

