/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.cloud.pubsublite.CloudZone;
import com.google.cloud.pubsublite.ProjectIdOrNumber;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;

final class AutoValue_SubscriptionPath
extends SubscriptionPath {
    private final ProjectIdOrNumber project;
    private final CloudZone location;
    private final SubscriptionName name;

    private AutoValue_SubscriptionPath(ProjectIdOrNumber project, CloudZone location, SubscriptionName name) {
        this.project = project;
        this.location = location;
        this.name = name;
    }

    @Override
    public ProjectIdOrNumber project() {
        return this.project;
    }

    @Override
    public CloudZone location() {
        return this.location;
    }

    @Override
    public SubscriptionName name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriptionPath) {
            SubscriptionPath that = (SubscriptionPath)o;
            return this.project.equals(that.project()) && this.location.equals(that.location()) && this.name.equals(that.name());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.project.hashCode();
        h$ *= 1000003;
        h$ ^= this.location.hashCode();
        h$ *= 1000003;
        return h$ ^= this.name.hashCode();
    }

    @Override
    public SubscriptionPath.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SubscriptionPath.Builder {
        private ProjectIdOrNumber project;
        private CloudZone location;
        private SubscriptionName name;

        Builder() {
        }

        private Builder(SubscriptionPath source) {
            this.project = source.project();
            this.location = source.location();
            this.name = source.name();
        }

        @Override
        public SubscriptionPath.Builder setProject(ProjectIdOrNumber project) {
            if (project == null) {
                throw new NullPointerException("Null project");
            }
            this.project = project;
            return this;
        }

        @Override
        public SubscriptionPath.Builder setLocation(CloudZone location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public SubscriptionPath.Builder setName(SubscriptionName name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public SubscriptionPath build() {
            String missing = "";
            if (this.project == null) {
                missing = missing + " project";
            }
            if (this.location == null) {
                missing = missing + " location";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SubscriptionPath(this.project, this.location, this.name);
        }
    }
}

