/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.gax.core.GaxProperties;

final class Versions {
    static final int MAJOR_VERSION = Versions.GetMajorVersion();
    static final int MINOR_VERSION = Versions.GetMinorVersion();

    private Versions() {
    }

    private static String[] GetVersionSplits() {
        try {
            String versionString = GaxProperties.getLibraryVersion(Versions.class);
            return versionString.split("\\.");
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    private static int GetMajorVersion() {
        String[] splits = Versions.GetVersionSplits();
        if (splits.length != 3) {
            return 0;
        }
        try {
            return Integer.parseInt(splits[0]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static int GetMinorVersion() {
        String[] splits = Versions.GetVersionSplits();
        if (splits.length != 3) {
            return 0;
        }
        try {
            return Integer.parseInt(splits[1]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

