/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiService;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Status;
import io.grpc.StatusException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ProxyService
extends AbstractApiService {
    private final List<ApiService> services = new ArrayList<ApiService>();
    private final AtomicBoolean stoppedOrFailed = new AtomicBoolean(false);

    protected ProxyService() {
    }

    protected final <T extends ApiService> void addServices(Collection<T> services) throws StatusException {
        Preconditions.checkState(this.state() == ApiService.State.NEW);
        for (ApiService service : services) {
            Preconditions.checkArgument(service.state() == ApiService.State.NEW, "All services must not be started.");
            this.services.add(service);
        }
    }

    protected final void addServices(ApiService ... services) throws StatusException {
        this.addServices((Collection)ImmutableList.copyOf((Object[])services));
    }

    protected abstract void start() throws StatusException;

    protected abstract void stop() throws StatusException;

    protected abstract void handlePermanentError(StatusException var1);

    protected final void onPermanentError(StatusException error) {
        if (this.stoppedOrFailed.getAndSet(true)) {
            return;
        }
        for (ApiService service : this.services) {
            service.stopAsync();
        }
        this.handlePermanentError(error);
        this.notifyFailed(error);
    }

    protected final void doStart() {
        ApiService.Listener listener = new ApiService.Listener(){
            private final AtomicInteger leftToStart;
            {
                this.leftToStart = new AtomicInteger(ProxyService.this.services.size());
            }

            public void running() {
                if (this.leftToStart.decrementAndGet() == 0) {
                    try {
                        ProxyService.this.start();
                    }
                    catch (StatusException e) {
                        ProxyService.this.onPermanentError(e);
                        return;
                    }
                    ProxyService.this.notifyStarted();
                }
            }

            public void failed(ApiService.State state, Throwable throwable) {
                Optional<Status> statusOr = ExtractStatus.extract(throwable);
                ProxyService.this.onPermanentError(statusOr.orElse(Status.INTERNAL.withCause(throwable)).asException());
            }
        };
        for (ApiService service : this.services) {
            service.addListener(listener, MoreExecutors.directExecutor());
            service.startAsync();
        }
    }

    protected final void doStop() {
        ApiService.Listener listener = new ApiService.Listener(){
            private final AtomicInteger leftToStart;
            {
                this.leftToStart = new AtomicInteger(ProxyService.this.services.size());
            }

            public void terminated(ApiService.State state) {
                if (this.leftToStart.decrementAndGet() == 0 && !ProxyService.this.stoppedOrFailed.getAndSet(true)) {
                    ProxyService.this.notifyStopped();
                }
            }
        };
        try {
            this.stop();
        }
        catch (StatusException e) {
            this.onPermanentError(e);
            return;
        }
        for (ApiService service : this.services) {
            service.addListener(listener, MoreExecutors.directExecutor());
            service.stopAsync();
        }
    }
}

