/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.Preconditions;
import com.google.cloud.pubsublite.internal.RoutingPolicy;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.protobuf.ByteString;
import io.grpc.StatusException;
import java.math.BigInteger;
import java.util.Random;

public class DefaultRoutingPolicy
implements RoutingPolicy {
    private final int numPartitions;
    private final CloseableMonitor monitor = new CloseableMonitor();
    @GuardedBy(value="monitor.monitor")
    private int nextWithoutKeyPartition;

    public DefaultRoutingPolicy(int numPartitions) throws StatusException {
        Preconditions.checkArgument(numPartitions > 0, "Must have a positive number of partitions.");
        this.numPartitions = numPartitions;
        this.nextWithoutKeyPartition = new Random().nextInt(this.numPartitions);
    }

    @Override
    public Partition routeWithoutKey() throws StatusException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            Partition toReturn = Partition.of(this.nextWithoutKeyPartition);
            int next = this.nextWithoutKeyPartition + 1;
            this.nextWithoutKeyPartition = next %= this.numPartitions;
            Partition partition = toReturn;
            return partition;
        }
    }

    @Override
    public Partition route(ByteString messageKey) throws StatusException {
        HashCode code = Hashing.sha256().hashBytes(messageKey.asReadOnlyByteBuffer());
        Preconditions.checkArgument(code.bits() == 256);
        BigInteger bigEndianValue = new BigInteger(1, code.asBytes());
        return Partition.of(bigEndianValue.mod(BigInteger.valueOf(this.numPartitions)).longValueExact());
    }
}

