/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite;

import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.AutoValue_CloudZone;
import com.google.cloud.pubsublite.CloudRegion;
import io.grpc.Status;
import io.grpc.StatusException;
import java.io.Serializable;

@AutoValue
public abstract class CloudZone
implements Serializable {
    private static final long serialVersionUID = 867184651465L;

    public static CloudZone of(CloudRegion region, char zoneId) {
        return new AutoValue_CloudZone(region, zoneId);
    }

    public static CloudZone parse(String zone) throws StatusException {
        String[] splits = zone.split("-", -1);
        if (splits.length != 3) {
            throw Status.INVALID_ARGUMENT.withDescription("Invalid zone name: " + zone).asException();
        }
        if (splits[2].length() != 1) {
            throw Status.INVALID_ARGUMENT.withDescription("Invalid zone name: " + zone).asException();
        }
        CloudRegion region = CloudRegion.of(splits[0] + "-" + splits[1]);
        return CloudZone.of(region, splits[2].charAt(0));
    }

    public abstract CloudRegion region();

    public abstract char zoneId();

    public final String toString() {
        return String.format("%s-%c", this.region().value(), Character.valueOf(this.zoneId()));
    }
}

