/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.cloud.pubsub.v1.SubscriberStats;

final class AutoValue_SubscriberStats
extends SubscriberStats {
    private final long receivedMessages;
    private final long ackedMessages;
    private final long totalReceivedMessages;
    private final long totalAckedMessages;
    private final SubscriberStats.Stats endToEndLatency;
    private final SubscriberStats.Stats ackLatency;
    private final long numberOfAutoExtendedAckDeadlines;

    private AutoValue_SubscriberStats(long receivedMessages, long ackedMessages, long totalReceivedMessages, long totalAckedMessages, SubscriberStats.Stats endToEndLatency, SubscriberStats.Stats ackLatency, long numberOfAutoExtendedAckDeadlines) {
        this.receivedMessages = receivedMessages;
        this.ackedMessages = ackedMessages;
        this.totalReceivedMessages = totalReceivedMessages;
        this.totalAckedMessages = totalAckedMessages;
        this.endToEndLatency = endToEndLatency;
        this.ackLatency = ackLatency;
        this.numberOfAutoExtendedAckDeadlines = numberOfAutoExtendedAckDeadlines;
    }

    @Override
    public long getReceivedMessages() {
        return this.receivedMessages;
    }

    @Override
    public long getAckedMessages() {
        return this.ackedMessages;
    }

    @Override
    public long getTotalReceivedMessages() {
        return this.totalReceivedMessages;
    }

    @Override
    public long getTotalAckedMessages() {
        return this.totalAckedMessages;
    }

    @Override
    public SubscriberStats.Stats getEndToEndLatency() {
        return this.endToEndLatency;
    }

    @Override
    public SubscriberStats.Stats getAckLatency() {
        return this.ackLatency;
    }

    @Override
    public long getNumberOfAutoExtendedAckDeadlines() {
        return this.numberOfAutoExtendedAckDeadlines;
    }

    public String toString() {
        return "SubscriberStats{receivedMessages=" + this.receivedMessages + ", ackedMessages=" + this.ackedMessages + ", totalReceivedMessages=" + this.totalReceivedMessages + ", totalAckedMessages=" + this.totalAckedMessages + ", endToEndLatency=" + this.endToEndLatency + ", ackLatency=" + this.ackLatency + ", numberOfAutoExtendedAckDeadlines=" + this.numberOfAutoExtendedAckDeadlines + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriberStats) {
            SubscriberStats that = (SubscriberStats)o;
            return this.receivedMessages == that.getReceivedMessages() && this.ackedMessages == that.getAckedMessages() && this.totalReceivedMessages == that.getTotalReceivedMessages() && this.totalAckedMessages == that.getTotalAckedMessages() && this.endToEndLatency.equals(that.getEndToEndLatency()) && this.ackLatency.equals(that.getAckLatency()) && this.numberOfAutoExtendedAckDeadlines == that.getNumberOfAutoExtendedAckDeadlines();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h = (int)((long)h ^ (this.receivedMessages >>> 32 ^ this.receivedMessages));
        h *= 1000003;
        h = (int)((long)h ^ (this.ackedMessages >>> 32 ^ this.ackedMessages));
        h *= 1000003;
        h = (int)((long)h ^ (this.totalReceivedMessages >>> 32 ^ this.totalReceivedMessages));
        h *= 1000003;
        h = (int)((long)h ^ (this.totalAckedMessages >>> 32 ^ this.totalAckedMessages));
        h *= 1000003;
        h ^= this.endToEndLatency.hashCode();
        h *= 1000003;
        h ^= this.ackLatency.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.numberOfAutoExtendedAckDeadlines >>> 32 ^ this.numberOfAutoExtendedAckDeadlines));
        return h;
    }

    static final class Builder
    extends SubscriberStats.Builder {
        private Long receivedMessages;
        private Long ackedMessages;
        private Long totalReceivedMessages;
        private Long totalAckedMessages;
        private SubscriberStats.Stats endToEndLatency;
        private SubscriberStats.Stats ackLatency;
        private Long numberOfAutoExtendedAckDeadlines;

        Builder() {
        }

        @Override
        public SubscriberStats.Builder setReceivedMessages(long receivedMessages) {
            this.receivedMessages = receivedMessages;
            return this;
        }

        @Override
        public SubscriberStats.Builder setAckedMessages(long ackedMessages) {
            this.ackedMessages = ackedMessages;
            return this;
        }

        @Override
        public SubscriberStats.Builder setTotalReceivedMessages(long totalReceivedMessages) {
            this.totalReceivedMessages = totalReceivedMessages;
            return this;
        }

        @Override
        public SubscriberStats.Builder setTotalAckedMessages(long totalAckedMessages) {
            this.totalAckedMessages = totalAckedMessages;
            return this;
        }

        @Override
        public SubscriberStats.Builder setEndToEndLatency(SubscriberStats.Stats endToEndLatency) {
            if (endToEndLatency == null) {
                throw new NullPointerException("Null endToEndLatency");
            }
            this.endToEndLatency = endToEndLatency;
            return this;
        }

        @Override
        public SubscriberStats.Builder setAckLatency(SubscriberStats.Stats ackLatency) {
            if (ackLatency == null) {
                throw new NullPointerException("Null ackLatency");
            }
            this.ackLatency = ackLatency;
            return this;
        }

        @Override
        public SubscriberStats.Builder setNumberOfAutoExtendedAckDeadlines(long numberOfAutoExtendedAckDeadlines) {
            this.numberOfAutoExtendedAckDeadlines = numberOfAutoExtendedAckDeadlines;
            return this;
        }

        @Override
        public SubscriberStats build() {
            String missing = "";
            if (this.receivedMessages == null) {
                missing = missing + " receivedMessages";
            }
            if (this.ackedMessages == null) {
                missing = missing + " ackedMessages";
            }
            if (this.totalReceivedMessages == null) {
                missing = missing + " totalReceivedMessages";
            }
            if (this.totalAckedMessages == null) {
                missing = missing + " totalAckedMessages";
            }
            if (this.endToEndLatency == null) {
                missing = missing + " endToEndLatency";
            }
            if (this.ackLatency == null) {
                missing = missing + " ackLatency";
            }
            if (this.numberOfAutoExtendedAckDeadlines == null) {
                missing = missing + " numberOfAutoExtendedAckDeadlines";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SubscriberStats(this.receivedMessages, this.ackedMessages, this.totalReceivedMessages, this.totalAckedMessages, this.endToEndLatency, this.ackLatency, this.numberOfAutoExtendedAckDeadlines);
        }
    }
}

