/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberStub;
import com.google.cloud.pubsub.v1.stub.HttpJsonSubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.CreateSnapshotRequest;
import com.google.pubsub.v1.DeleteSnapshotRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSnapshotRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSnapshotsRequest;
import com.google.pubsub.v1.ListSnapshotsResponse;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.SeekRequest;
import com.google.pubsub.v1.SeekResponse;
import com.google.pubsub.v1.Snapshot;
import com.google.pubsub.v1.StreamingPullRequest;
import com.google.pubsub.v1.StreamingPullResponse;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.UpdateSnapshotRequest;
import com.google.pubsub.v1.UpdateSubscriptionRequest;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SubscriberStubSettings
extends StubSettings<SubscriberStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/pubsub").build();
    private final UnaryCallSettings<Subscription, Subscription> createSubscriptionSettings;
    private final UnaryCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
    private final UnaryCallSettings<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings;
    private final PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
    private final UnaryCallSettings<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings;
    private final UnaryCallSettings<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings;
    private final UnaryCallSettings<AcknowledgeRequest, Empty> acknowledgeSettings;
    private final UnaryCallSettings<PullRequest, PullResponse> pullSettings;
    private final StreamingCallSettings<StreamingPullRequest, StreamingPullResponse> streamingPullSettings;
    private final UnaryCallSettings<ModifyPushConfigRequest, Empty> modifyPushConfigSettings;
    private final UnaryCallSettings<GetSnapshotRequest, Snapshot> getSnapshotSettings;
    private final PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
    private final UnaryCallSettings<CreateSnapshotRequest, Snapshot> createSnapshotSettings;
    private final UnaryCallSettings<UpdateSnapshotRequest, Snapshot> updateSnapshotSettings;
    private final UnaryCallSettings<DeleteSnapshotRequest, Empty> deleteSnapshotSettings;
    private final UnaryCallSettings<SeekRequest, SeekResponse> seekSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> LIST_SUBSCRIPTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>(){

        public String emptyToken() {
            return "";
        }

        public ListSubscriptionsRequest injectToken(ListSubscriptionsRequest payload, String token) {
            return ListSubscriptionsRequest.newBuilder((ListSubscriptionsRequest)payload).setPageToken(token).build();
        }

        public ListSubscriptionsRequest injectPageSize(ListSubscriptionsRequest payload, int pageSize) {
            return ListSubscriptionsRequest.newBuilder((ListSubscriptionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSubscriptionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSubscriptionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Subscription> extractResources(ListSubscriptionsResponse payload) {
            return payload.getSubscriptionsList();
        }
    };
    private static final PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot> LIST_SNAPSHOTS_PAGE_STR_DESC = new PagedListDescriptor<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot>(){

        public String emptyToken() {
            return "";
        }

        public ListSnapshotsRequest injectToken(ListSnapshotsRequest payload, String token) {
            return ListSnapshotsRequest.newBuilder((ListSnapshotsRequest)payload).setPageToken(token).build();
        }

        public ListSnapshotsRequest injectPageSize(ListSnapshotsRequest payload, int pageSize) {
            return ListSnapshotsRequest.newBuilder((ListSnapshotsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSnapshotsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSnapshotsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Snapshot> extractResources(ListSnapshotsResponse payload) {
            return payload.getSnapshotsList();
        }
    };
    private static final PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse> LIST_SUBSCRIPTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse>(){

        public ApiFuture<SubscriptionAdminClient.ListSubscriptionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> callable, ListSubscriptionsRequest request, ApiCallContext context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SUBSCRIPTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SubscriptionAdminClient.ListSubscriptionsPagedResponse.createAsync((PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse> LIST_SNAPSHOTS_PAGE_STR_FACT = new PagedListResponseFactory<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse>(){

        public ApiFuture<SubscriptionAdminClient.ListSnapshotsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> callable, ListSnapshotsRequest request, ApiCallContext context, ApiFuture<ListSnapshotsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SNAPSHOTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SubscriptionAdminClient.ListSnapshotsPagedResponse.createAsync((PageContext<ListSnapshotsRequest, ListSnapshotsResponse, Snapshot>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<Subscription, Subscription> createSubscriptionSettings() {
        return this.createSubscriptionSettings;
    }

    public UnaryCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
        return this.getSubscriptionSettings;
    }

    public UnaryCallSettings<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings() {
        return this.updateSubscriptionSettings;
    }

    public PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
        return this.listSubscriptionsSettings;
    }

    public UnaryCallSettings<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings() {
        return this.deleteSubscriptionSettings;
    }

    public UnaryCallSettings<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings() {
        return this.modifyAckDeadlineSettings;
    }

    public UnaryCallSettings<AcknowledgeRequest, Empty> acknowledgeSettings() {
        return this.acknowledgeSettings;
    }

    public UnaryCallSettings<PullRequest, PullResponse> pullSettings() {
        return this.pullSettings;
    }

    public StreamingCallSettings<StreamingPullRequest, StreamingPullResponse> streamingPullSettings() {
        return this.streamingPullSettings;
    }

    public UnaryCallSettings<ModifyPushConfigRequest, Empty> modifyPushConfigSettings() {
        return this.modifyPushConfigSettings;
    }

    public UnaryCallSettings<GetSnapshotRequest, Snapshot> getSnapshotSettings() {
        return this.getSnapshotSettings;
    }

    public PagedCallSettings<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
        return this.listSnapshotsSettings;
    }

    public UnaryCallSettings<CreateSnapshotRequest, Snapshot> createSnapshotSettings() {
        return this.createSnapshotSettings;
    }

    public UnaryCallSettings<UpdateSnapshotRequest, Snapshot> updateSnapshotSettings() {
        return this.updateSnapshotSettings;
    }

    public UnaryCallSettings<DeleteSnapshotRequest, Empty> deleteSnapshotSettings() {
        return this.deleteSnapshotSettings;
    }

    public UnaryCallSettings<SeekRequest, SeekResponse> seekSettings() {
        return this.seekSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public SubscriberStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSubscriberStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSubscriberStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "pubsub";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "pubsub.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "pubsub.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(0x1400000));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SubscriberStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SubscriberStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SubscriberStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SubscriberStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SubscriberStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSubscriptionSettings = settingsBuilder.createSubscriptionSettings().build();
        this.getSubscriptionSettings = settingsBuilder.getSubscriptionSettings().build();
        this.updateSubscriptionSettings = settingsBuilder.updateSubscriptionSettings().build();
        this.listSubscriptionsSettings = settingsBuilder.listSubscriptionsSettings().build();
        this.deleteSubscriptionSettings = settingsBuilder.deleteSubscriptionSettings().build();
        this.modifyAckDeadlineSettings = settingsBuilder.modifyAckDeadlineSettings().build();
        this.acknowledgeSettings = settingsBuilder.acknowledgeSettings().build();
        this.pullSettings = settingsBuilder.pullSettings().build();
        this.streamingPullSettings = settingsBuilder.streamingPullSettings().build();
        this.modifyPushConfigSettings = settingsBuilder.modifyPushConfigSettings().build();
        this.getSnapshotSettings = settingsBuilder.getSnapshotSettings().build();
        this.listSnapshotsSettings = settingsBuilder.listSnapshotsSettings().build();
        this.createSnapshotSettings = settingsBuilder.createSnapshotSettings().build();
        this.updateSnapshotSettings = settingsBuilder.updateSnapshotSettings().build();
        this.deleteSnapshotSettings = settingsBuilder.deleteSnapshotSettings().build();
        this.seekSettings = settingsBuilder.seekSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SubscriberStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<Subscription, Subscription> createSubscriptionSettings;
        private final UnaryCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
        private final UnaryCallSettings.Builder<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings;
        private final PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
        private final UnaryCallSettings.Builder<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings;
        private final UnaryCallSettings.Builder<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings;
        private final UnaryCallSettings.Builder<AcknowledgeRequest, Empty> acknowledgeSettings;
        private final UnaryCallSettings.Builder<PullRequest, PullResponse> pullSettings;
        private final StreamingCallSettings.Builder<StreamingPullRequest, StreamingPullResponse> streamingPullSettings;
        private final UnaryCallSettings.Builder<ModifyPushConfigRequest, Empty> modifyPushConfigSettings;
        private final UnaryCallSettings.Builder<GetSnapshotRequest, Snapshot> getSnapshotSettings;
        private final PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings;
        private final UnaryCallSettings.Builder<CreateSnapshotRequest, Snapshot> createSnapshotSettings;
        private final UnaryCallSettings.Builder<UpdateSnapshotRequest, Snapshot> updateSnapshotSettings;
        private final UnaryCallSettings.Builder<DeleteSnapshotRequest, Empty> deleteSnapshotSettings;
        private final UnaryCallSettings.Builder<SeekRequest, SeekResponse> seekSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSubscriptionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SUBSCRIPTIONS_PAGE_STR_FACT);
            this.deleteSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.modifyAckDeadlineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.acknowledgeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.pullSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.streamingPullSettings = StreamingCallSettings.newBuilder();
            this.modifyPushConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSnapshotsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SNAPSHOTS_PAGE_STR_FACT);
            this.createSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.seekSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSubscriptionSettings, this.getSubscriptionSettings, this.updateSubscriptionSettings, this.listSubscriptionsSettings, this.deleteSubscriptionSettings, this.modifyAckDeadlineSettings, this.acknowledgeSettings, this.pullSettings, this.modifyPushConfigSettings, this.getSnapshotSettings, this.listSnapshotsSettings, this.createSnapshotSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateSnapshotSettings, this.deleteSnapshotSettings, this.seekSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(SubscriberStubSettings settings) {
            super((StubSettings)settings);
            this.createSubscriptionSettings = settings.createSubscriptionSettings.toBuilder();
            this.getSubscriptionSettings = settings.getSubscriptionSettings.toBuilder();
            this.updateSubscriptionSettings = settings.updateSubscriptionSettings.toBuilder();
            this.listSubscriptionsSettings = settings.listSubscriptionsSettings.toBuilder();
            this.deleteSubscriptionSettings = settings.deleteSubscriptionSettings.toBuilder();
            this.modifyAckDeadlineSettings = settings.modifyAckDeadlineSettings.toBuilder();
            this.acknowledgeSettings = settings.acknowledgeSettings.toBuilder();
            this.pullSettings = settings.pullSettings.toBuilder();
            this.streamingPullSettings = settings.streamingPullSettings.toBuilder();
            this.modifyPushConfigSettings = settings.modifyPushConfigSettings.toBuilder();
            this.getSnapshotSettings = settings.getSnapshotSettings.toBuilder();
            this.listSnapshotsSettings = settings.listSnapshotsSettings.toBuilder();
            this.createSnapshotSettings = settings.createSnapshotSettings.toBuilder();
            this.updateSnapshotSettings = settings.updateSnapshotSettings.toBuilder();
            this.deleteSnapshotSettings = settings.deleteSnapshotSettings.toBuilder();
            this.seekSettings = settings.seekSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSubscriptionSettings, this.getSubscriptionSettings, this.updateSubscriptionSettings, this.listSubscriptionsSettings, this.deleteSubscriptionSettings, this.modifyAckDeadlineSettings, this.acknowledgeSettings, this.pullSettings, this.modifyPushConfigSettings, this.getSnapshotSettings, this.listSnapshotsSettings, this.createSnapshotSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateSnapshotSettings, this.deleteSnapshotSettings, this.seekSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SubscriberStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SubscriberStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SubscriberStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SubscriberStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SubscriberStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SubscriberStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SubscriberStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SubscriberStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_5_params"));
            builder.getSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_5_params"));
            builder.updateSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.listSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_5_params"));
            builder.deleteSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.modifyAckDeadlineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.acknowledgeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.pullSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params"));
            builder.modifyPushConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.getSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_5_params"));
            builder.listSnapshotsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_5_params"));
            builder.createSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.updateSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.deleteSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.seekSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_5_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_5_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<Subscription, Subscription> createSubscriptionSettings() {
            return this.createSubscriptionSettings;
        }

        public UnaryCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
            return this.getSubscriptionSettings;
        }

        public UnaryCallSettings.Builder<UpdateSubscriptionRequest, Subscription> updateSubscriptionSettings() {
            return this.updateSubscriptionSettings;
        }

        public PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
            return this.listSubscriptionsSettings;
        }

        public UnaryCallSettings.Builder<DeleteSubscriptionRequest, Empty> deleteSubscriptionSettings() {
            return this.deleteSubscriptionSettings;
        }

        public UnaryCallSettings.Builder<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineSettings() {
            return this.modifyAckDeadlineSettings;
        }

        public UnaryCallSettings.Builder<AcknowledgeRequest, Empty> acknowledgeSettings() {
            return this.acknowledgeSettings;
        }

        public UnaryCallSettings.Builder<PullRequest, PullResponse> pullSettings() {
            return this.pullSettings;
        }

        public StreamingCallSettings.Builder<StreamingPullRequest, StreamingPullResponse> streamingPullSettings() {
            return this.streamingPullSettings;
        }

        public UnaryCallSettings.Builder<ModifyPushConfigRequest, Empty> modifyPushConfigSettings() {
            return this.modifyPushConfigSettings;
        }

        public UnaryCallSettings.Builder<GetSnapshotRequest, Snapshot> getSnapshotSettings() {
            return this.getSnapshotSettings;
        }

        public PagedCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsSettings() {
            return this.listSnapshotsSettings;
        }

        public UnaryCallSettings.Builder<CreateSnapshotRequest, Snapshot> createSnapshotSettings() {
            return this.createSnapshotSettings;
        }

        public UnaryCallSettings.Builder<UpdateSnapshotRequest, Snapshot> updateSnapshotSettings() {
            return this.updateSnapshotSettings;
        }

        public UnaryCallSettings.Builder<DeleteSnapshotRequest, Empty> deleteSnapshotSettings() {
            return this.deleteSnapshotSettings;
        }

        public UnaryCallSettings.Builder<SeekRequest, SeekResponse> seekSettings() {
            return this.seekSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public SubscriberStubSettings build() throws IOException {
            return new SubscriberStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_5_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNKNOWN, StatusCode.Code.ABORTED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_6_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_4_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNKNOWN, StatusCode.Code.ABORTED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.INTERNAL})));
            definitions.put((Object)"retry_policy_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.ABORTED, StatusCode.Code.INTERNAL, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_5_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_6_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_4_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(4.0).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(900000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(900000L)).setTotalTimeoutDuration(Duration.ofMillis(900000L)).build();
            definitions.put((Object)"retry_policy_3_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

