/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.SchemaServiceClient;
import com.google.cloud.pubsub.v1.stub.GrpcSchemaServiceCallableFactory;
import com.google.cloud.pubsub.v1.stub.SchemaServiceStub;
import com.google.cloud.pubsub.v1.stub.SchemaServiceStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.pubsub.v1.CommitSchemaRequest;
import com.google.pubsub.v1.CreateSchemaRequest;
import com.google.pubsub.v1.DeleteSchemaRequest;
import com.google.pubsub.v1.DeleteSchemaRevisionRequest;
import com.google.pubsub.v1.GetSchemaRequest;
import com.google.pubsub.v1.ListSchemaRevisionsRequest;
import com.google.pubsub.v1.ListSchemaRevisionsResponse;
import com.google.pubsub.v1.ListSchemasRequest;
import com.google.pubsub.v1.ListSchemasResponse;
import com.google.pubsub.v1.RollbackSchemaRequest;
import com.google.pubsub.v1.Schema;
import com.google.pubsub.v1.ValidateMessageRequest;
import com.google.pubsub.v1.ValidateMessageResponse;
import com.google.pubsub.v1.ValidateSchemaRequest;
import com.google.pubsub.v1.ValidateSchemaResponse;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSchemaServiceStub
extends SchemaServiceStub {
    private static final MethodDescriptor<CreateSchemaRequest, Schema> createSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.SchemaService/CreateSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Schema.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSchemaRequest, Schema> getSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.SchemaService/GetSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Schema.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSchemasRequest, ListSchemasResponse> listSchemasMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.SchemaService/ListSchemas").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSchemasRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSchemasResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse> listSchemaRevisionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.SchemaService/ListSchemaRevisions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSchemaRevisionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSchemaRevisionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CommitSchemaRequest, Schema> commitSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.SchemaService/CommitSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)CommitSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Schema.getDefaultInstance())).build();
    private static final MethodDescriptor<RollbackSchemaRequest, Schema> rollbackSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.SchemaService/RollbackSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)RollbackSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Schema.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSchemaRevisionRequest, Schema> deleteSchemaRevisionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.SchemaService/DeleteSchemaRevision").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSchemaRevisionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Schema.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSchemaRequest, Empty> deleteSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.SchemaService/DeleteSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ValidateSchemaRequest, ValidateSchemaResponse> validateSchemaMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.SchemaService/ValidateSchema").setRequestMarshaller(ProtoUtils.marshaller((Message)ValidateSchemaRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ValidateSchemaResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ValidateMessageRequest, ValidateMessageResponse> validateMessageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.SchemaService/ValidateMessage").setRequestMarshaller(ProtoUtils.marshaller((Message)ValidateMessageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ValidateMessageResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateSchemaRequest, Schema> createSchemaCallable;
    private final UnaryCallable<GetSchemaRequest, Schema> getSchemaCallable;
    private final UnaryCallable<ListSchemasRequest, ListSchemasResponse> listSchemasCallable;
    private final UnaryCallable<ListSchemasRequest, SchemaServiceClient.ListSchemasPagedResponse> listSchemasPagedCallable;
    private final UnaryCallable<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse> listSchemaRevisionsCallable;
    private final UnaryCallable<ListSchemaRevisionsRequest, SchemaServiceClient.ListSchemaRevisionsPagedResponse> listSchemaRevisionsPagedCallable;
    private final UnaryCallable<CommitSchemaRequest, Schema> commitSchemaCallable;
    private final UnaryCallable<RollbackSchemaRequest, Schema> rollbackSchemaCallable;
    private final UnaryCallable<DeleteSchemaRevisionRequest, Schema> deleteSchemaRevisionCallable;
    private final UnaryCallable<DeleteSchemaRequest, Empty> deleteSchemaCallable;
    private final UnaryCallable<ValidateSchemaRequest, ValidateSchemaResponse> validateSchemaCallable;
    private final UnaryCallable<ValidateMessageRequest, ValidateMessageResponse> validateMessageCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSchemaServiceStub create(SchemaServiceStubSettings settings) throws IOException {
        return new GrpcSchemaServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSchemaServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSchemaServiceStub(SchemaServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSchemaServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSchemaServiceStub(SchemaServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSchemaServiceStub(SchemaServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSchemaServiceCallableFactory());
    }

    protected GrpcSchemaServiceStub(SchemaServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSchemasTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSchemasMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listSchemaRevisionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSchemaRevisionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings commitSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(commitSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings rollbackSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rollbackSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSchemaRevisionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSchemaRevisionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings validateSchemaTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(validateSchemaMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings validateMessageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(validateMessageMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createSchemaCallable = callableFactory.createUnaryCallable(createSchemaTransportSettings, settings.createSchemaSettings(), clientContext);
        this.getSchemaCallable = callableFactory.createUnaryCallable(getSchemaTransportSettings, settings.getSchemaSettings(), clientContext);
        this.listSchemasCallable = callableFactory.createUnaryCallable(listSchemasTransportSettings, settings.listSchemasSettings(), clientContext);
        this.listSchemasPagedCallable = callableFactory.createPagedCallable(listSchemasTransportSettings, settings.listSchemasSettings(), clientContext);
        this.listSchemaRevisionsCallable = callableFactory.createUnaryCallable(listSchemaRevisionsTransportSettings, settings.listSchemaRevisionsSettings(), clientContext);
        this.listSchemaRevisionsPagedCallable = callableFactory.createPagedCallable(listSchemaRevisionsTransportSettings, settings.listSchemaRevisionsSettings(), clientContext);
        this.commitSchemaCallable = callableFactory.createUnaryCallable(commitSchemaTransportSettings, settings.commitSchemaSettings(), clientContext);
        this.rollbackSchemaCallable = callableFactory.createUnaryCallable(rollbackSchemaTransportSettings, settings.rollbackSchemaSettings(), clientContext);
        this.deleteSchemaRevisionCallable = callableFactory.createUnaryCallable(deleteSchemaRevisionTransportSettings, settings.deleteSchemaRevisionSettings(), clientContext);
        this.deleteSchemaCallable = callableFactory.createUnaryCallable(deleteSchemaTransportSettings, settings.deleteSchemaSettings(), clientContext);
        this.validateSchemaCallable = callableFactory.createUnaryCallable(validateSchemaTransportSettings, settings.validateSchemaSettings(), clientContext);
        this.validateMessageCallable = callableFactory.createUnaryCallable(validateMessageTransportSettings, settings.validateMessageSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSchemaRequest, Schema> createSchemaCallable() {
        return this.createSchemaCallable;
    }

    @Override
    public UnaryCallable<GetSchemaRequest, Schema> getSchemaCallable() {
        return this.getSchemaCallable;
    }

    @Override
    public UnaryCallable<ListSchemasRequest, ListSchemasResponse> listSchemasCallable() {
        return this.listSchemasCallable;
    }

    @Override
    public UnaryCallable<ListSchemasRequest, SchemaServiceClient.ListSchemasPagedResponse> listSchemasPagedCallable() {
        return this.listSchemasPagedCallable;
    }

    @Override
    public UnaryCallable<ListSchemaRevisionsRequest, ListSchemaRevisionsResponse> listSchemaRevisionsCallable() {
        return this.listSchemaRevisionsCallable;
    }

    @Override
    public UnaryCallable<ListSchemaRevisionsRequest, SchemaServiceClient.ListSchemaRevisionsPagedResponse> listSchemaRevisionsPagedCallable() {
        return this.listSchemaRevisionsPagedCallable;
    }

    @Override
    public UnaryCallable<CommitSchemaRequest, Schema> commitSchemaCallable() {
        return this.commitSchemaCallable;
    }

    @Override
    public UnaryCallable<RollbackSchemaRequest, Schema> rollbackSchemaCallable() {
        return this.rollbackSchemaCallable;
    }

    @Override
    public UnaryCallable<DeleteSchemaRevisionRequest, Schema> deleteSchemaRevisionCallable() {
        return this.deleteSchemaRevisionCallable;
    }

    @Override
    public UnaryCallable<DeleteSchemaRequest, Empty> deleteSchemaCallable() {
        return this.deleteSchemaCallable;
    }

    @Override
    public UnaryCallable<ValidateSchemaRequest, ValidateSchemaResponse> validateSchemaCallable() {
        return this.validateSchemaCallable;
    }

    @Override
    public UnaryCallable<ValidateMessageRequest, ValidateMessageResponse> validateMessageCallable() {
        return this.validateMessageCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

