/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.stub.GrpcPublisherCallableFactory;
import com.google.cloud.pubsub.v1.stub.PublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.DetachSubscriptionRequest;
import com.google.pubsub.v1.DetachSubscriptionResponse;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSnapshotsRequest;
import com.google.pubsub.v1.ListTopicSnapshotsResponse;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.UpdateTopicRequest;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcPublisherStub
extends PublisherStub {
    private static final MethodDescriptor<Topic, Topic> createTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/CreateTopic").setRequestMarshaller(ProtoUtils.marshaller((Message)Topic.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Topic.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateTopicRequest, Topic> updateTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/UpdateTopic").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTopicRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Topic.getDefaultInstance())).build();
    private static final MethodDescriptor<PublishRequest, PublishResponse> publishMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/Publish").setRequestMarshaller(ProtoUtils.marshaller((Message)PublishRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PublishResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTopicRequest, Topic> getTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/GetTopic").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTopicRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Topic.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTopicsRequest, ListTopicsResponse> listTopicsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/ListTopics").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTopicsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTopicsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/ListTopicSubscriptions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTopicSubscriptionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTopicSubscriptionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> listTopicSnapshotsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/ListTopicSnapshots").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTopicSnapshotsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTopicSnapshotsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteTopicRequest, Empty> deleteTopicMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/DeleteTopic").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTopicRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Publisher/DetachSubscription").setRequestMarshaller(ProtoUtils.marshaller((Message)DetachSubscriptionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DetachSubscriptionResponse.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<Topic, Topic> createTopicCallable;
    private final UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable;
    private final UnaryCallable<PublishRequest, PublishResponse> publishCallable;
    private final UnaryCallable<GetTopicRequest, Topic> getTopicCallable;
    private final UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable;
    private final UnaryCallable<ListTopicsRequest, TopicAdminClient.ListTopicsPagedResponse> listTopicsPagedCallable;
    private final UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable;
    private final UnaryCallable<ListTopicSubscriptionsRequest, TopicAdminClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable;
    private final UnaryCallable<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> listTopicSnapshotsCallable;
    private final UnaryCallable<ListTopicSnapshotsRequest, TopicAdminClient.ListTopicSnapshotsPagedResponse> listTopicSnapshotsPagedCallable;
    private final UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final UnaryCallable<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPublisherStub create(PublisherStubSettings settings) throws IOException {
        return new GrpcPublisherStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPublisherStub create(ClientContext clientContext) throws IOException {
        return new GrpcPublisherStub(PublisherStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPublisherStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPublisherStub(PublisherStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPublisherStub(PublisherStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPublisherCallableFactory());
    }

    protected GrpcPublisherStub(PublisherStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings createTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTopicMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<Topic>(){

            public Map<String, String> extract(Topic request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTopicMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateTopicRequest>(){

            public Map<String, String> extract(UpdateTopicRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"topic.name", (Object)String.valueOf(request.getTopic().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings publishTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(publishMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<PublishRequest>(){

            public Map<String, String> extract(PublishRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"topic", (Object)String.valueOf(request.getTopic()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTopicMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetTopicRequest>(){

            public Map<String, String> extract(GetTopicRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"topic", (Object)String.valueOf(request.getTopic()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listTopicsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTopicsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListTopicsRequest>(){

            public Map<String, String> extract(ListTopicsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"project", (Object)String.valueOf(request.getProject()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listTopicSubscriptionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTopicSubscriptionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListTopicSubscriptionsRequest>(){

            public Map<String, String> extract(ListTopicSubscriptionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"topic", (Object)String.valueOf(request.getTopic()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listTopicSnapshotsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTopicSnapshotsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListTopicSnapshotsRequest>(){

            public Map<String, String> extract(ListTopicSnapshotsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"topic", (Object)String.valueOf(request.getTopic()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteTopicTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTopicMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteTopicRequest>(){

            public Map<String, String> extract(DeleteTopicRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"topic", (Object)String.valueOf(request.getTopic()));
                return params.build();
            }
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SetIamPolicyRequest>(){

            public Map<String, String> extract(SetIamPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetIamPolicyRequest>(){

            public Map<String, String> extract(GetIamPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<TestIamPermissionsRequest>(){

            public Map<String, String> extract(TestIamPermissionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings detachSubscriptionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(detachSubscriptionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DetachSubscriptionRequest>(){

            public Map<String, String> extract(DetachSubscriptionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"subscription", (Object)String.valueOf(request.getSubscription()));
                return params.build();
            }
        }).build();
        this.createTopicCallable = callableFactory.createUnaryCallable(createTopicTransportSettings, settings.createTopicSettings(), clientContext);
        this.updateTopicCallable = callableFactory.createUnaryCallable(updateTopicTransportSettings, settings.updateTopicSettings(), clientContext);
        this.publishCallable = callableFactory.createBatchingCallable(publishTransportSettings, settings.publishSettings(), clientContext);
        this.getTopicCallable = callableFactory.createUnaryCallable(getTopicTransportSettings, settings.getTopicSettings(), clientContext);
        this.listTopicsCallable = callableFactory.createUnaryCallable(listTopicsTransportSettings, settings.listTopicsSettings(), clientContext);
        this.listTopicsPagedCallable = callableFactory.createPagedCallable(listTopicsTransportSettings, settings.listTopicsSettings(), clientContext);
        this.listTopicSubscriptionsCallable = callableFactory.createUnaryCallable(listTopicSubscriptionsTransportSettings, settings.listTopicSubscriptionsSettings(), clientContext);
        this.listTopicSubscriptionsPagedCallable = callableFactory.createPagedCallable(listTopicSubscriptionsTransportSettings, settings.listTopicSubscriptionsSettings(), clientContext);
        this.listTopicSnapshotsCallable = callableFactory.createUnaryCallable(listTopicSnapshotsTransportSettings, settings.listTopicSnapshotsSettings(), clientContext);
        this.listTopicSnapshotsPagedCallable = callableFactory.createPagedCallable(listTopicSnapshotsTransportSettings, settings.listTopicSnapshotsSettings(), clientContext);
        this.deleteTopicCallable = callableFactory.createUnaryCallable(deleteTopicTransportSettings, settings.deleteTopicSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.detachSubscriptionCallable = callableFactory.createUnaryCallable(detachSubscriptionTransportSettings, settings.detachSubscriptionSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<Topic, Topic> createTopicCallable() {
        return this.createTopicCallable;
    }

    @Override
    public UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable() {
        return this.updateTopicCallable;
    }

    @Override
    public UnaryCallable<PublishRequest, PublishResponse> publishCallable() {
        return this.publishCallable;
    }

    @Override
    public UnaryCallable<GetTopicRequest, Topic> getTopicCallable() {
        return this.getTopicCallable;
    }

    @Override
    public UnaryCallable<ListTopicsRequest, TopicAdminClient.ListTopicsPagedResponse> listTopicsPagedCallable() {
        return this.listTopicsPagedCallable;
    }

    @Override
    public UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable() {
        return this.listTopicsCallable;
    }

    @Override
    public UnaryCallable<ListTopicSubscriptionsRequest, TopicAdminClient.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable() {
        return this.listTopicSubscriptionsPagedCallable;
    }

    @Override
    public UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable() {
        return this.listTopicSubscriptionsCallable;
    }

    @Override
    public UnaryCallable<ListTopicSnapshotsRequest, TopicAdminClient.ListTopicSnapshotsPagedResponse> listTopicSnapshotsPagedCallable() {
        return this.listTopicSnapshotsPagedCallable;
    }

    @Override
    public UnaryCallable<ListTopicSnapshotsRequest, ListTopicSnapshotsResponse> listTopicSnapshotsCallable() {
        return this.listTopicSnapshotsCallable;
    }

    @Override
    public UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable() {
        return this.deleteTopicCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public UnaryCallable<DetachSubscriptionRequest, DetachSubscriptionResponse> detachSubscriptionCallable() {
        return this.detachSubscriptionCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

