/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.InternalApi;

class Waiter {
    private int pendingCount = 0;

    Waiter() {
    }

    public synchronized void incrementPendingCount(int delta) {
        this.pendingCount += delta;
        if (this.pendingCount == 0) {
            this.notifyAll();
        }
    }

    public synchronized void waitComplete() {
        boolean interrupted = false;
        try {
            while (this.pendingCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @InternalApi
    public int pendingCount() {
        return this.pendingCount;
    }
}

