/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.deprecated;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class PushConfig
implements Serializable {
    private static final long serialVersionUID = 4408885787064092231L;
    private final String endpoint;
    private final ImmutableMap<String, String> attributes;

    private PushConfig(Builder builder) {
        this.endpoint = builder.endpoint;
        this.attributes = ImmutableMap.copyOf((Map)builder.attributes);
    }

    @Deprecated
    public String endpoint() {
        return this.getEndpoint();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Deprecated
    public Map<String, String> attributes() {
        return this.getAttributes();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PushConfig)) {
            return false;
        }
        PushConfig other = (PushConfig)obj;
        return Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.attributes, other.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.attributes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attributes", this.attributes).add("endpoint", (Object)this.endpoint).toString();
    }

    public Builder toBuilder() {
        return PushConfig.newBuilder(this.endpoint, this.attributes);
    }

    public static PushConfig of(String endpoint) {
        return PushConfig.newBuilder(endpoint).build();
    }

    public static PushConfig of(String endpoint, Map<String, String> attributes) {
        return PushConfig.newBuilder(endpoint, attributes).build();
    }

    @Deprecated
    public static Builder builder(String endpoint) {
        return PushConfig.newBuilder(endpoint);
    }

    public static Builder newBuilder(String endpoint) {
        return new Builder().setEndpoint(endpoint);
    }

    @Deprecated
    public static Builder builder(String endpoint, Map<String, String> attributes) {
        return PushConfig.newBuilder(endpoint, attributes);
    }

    public static Builder newBuilder(String endpoint, Map<String, String> attributes) {
        return PushConfig.newBuilder(endpoint).setAttributes(attributes);
    }

    com.google.pubsub.v1.PushConfig toPb() {
        return com.google.pubsub.v1.PushConfig.newBuilder().setPushEndpoint(this.endpoint).putAllAttributes(this.attributes).build();
    }

    static PushConfig fromPb(com.google.pubsub.v1.PushConfig pushConfigPb) {
        return PushConfig.newBuilder(pushConfigPb.getPushEndpoint(), pushConfigPb.getAttributesMap()).build();
    }

    public static final class Builder {
        private String endpoint;
        private Map<String, String> attributes = new HashMap<String, String>();

        private Builder() {
        }

        @Deprecated
        public Builder endpoint(String endpoint) {
            return this.setEndpoint(endpoint);
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint);
            return this;
        }

        public Builder addAttribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        @Deprecated
        public Builder attributes(Map<String, String> attributes) {
            return this.setAttributes(attributes);
        }

        public Builder setAttributes(Map<String, String> attributes) {
            this.attributes = new HashMap<String, String>(attributes);
            return this;
        }

        public Builder removeAttribute(String name) {
            this.attributes.remove(name);
            return this;
        }

        public Builder clearAttributes() {
            this.attributes.clear();
            return this;
        }

        public PushConfig build() {
            return new PushConfig(this);
        }
    }
}

