/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import java.io.Serializable;
import java.util.Objects;

public class TopicInfo
implements Serializable {
    private static final long serialVersionUID = -5907624842808725353L;
    private final String name;

    TopicInfo(BuilderImpl builder) {
        this.name = builder.name;
    }

    @Deprecated
    public String name() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    final boolean baseEquals(TopicInfo topicInfo) {
        return Objects.equals(this.name, topicInfo.name);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(TopicInfo.class) && this.baseEquals((TopicInfo)obj);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    Topic toPb(String projectId) {
        return Topic.newBuilder().setNameWithTopicName(TopicName.create((String)projectId, (String)this.name)).build();
    }

    static TopicInfo fromPb(Topic topicPb) {
        return TopicInfo.newBuilder(topicPb.getNameAsTopicName().getTopic()).build();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static TopicInfo of(String name) {
        return TopicInfo.newBuilder(name).build();
    }

    @Deprecated
    public static Builder builder(String name) {
        return TopicInfo.newBuilder(name);
    }

    public static Builder newBuilder(String name) {
        return new BuilderImpl(name);
    }

    static final class BuilderImpl
    extends Builder {
        private String name;

        BuilderImpl(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        BuilderImpl(TopicInfo topicInfo) {
            this.name = topicInfo.name;
        }

        @Override
        @Deprecated
        public Builder name(String name) {
            return this.setName(name);
        }

        @Override
        public Builder setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        @Override
        public TopicInfo build() {
            return new TopicInfo(this);
        }
    }

    public static abstract class Builder {
        @Deprecated
        public abstract Builder name(String var1);

        public abstract Builder setName(String var1);

        public abstract TopicInfo build();
    }
}

