/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.pubsub.PushConfig;
import com.google.cloud.pubsub.TopicId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.SubscriptionName;
import java.io.Serializable;
import java.util.Objects;

public class SubscriptionInfo
implements Serializable {
    private static final long serialVersionUID = 1860057426574127128L;
    private final String name;
    private final TopicId topic;
    private final PushConfig pushConfig;
    private final int ackDeadlineSeconds;

    SubscriptionInfo(BuilderImpl builder) {
        this.topic = builder.topic;
        this.name = builder.name;
        this.pushConfig = builder.pushConfig;
        this.ackDeadlineSeconds = builder.ackDeadlineSeconds;
    }

    @Deprecated
    public TopicId topic() {
        return this.getTopic();
    }

    public TopicId getTopic() {
        return this.topic;
    }

    @Deprecated
    public String name() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public PushConfig pushConfig() {
        return this.getPushConfig();
    }

    public PushConfig getPushConfig() {
        return this.pushConfig;
    }

    @Deprecated
    public long ackDeadlineSeconds() {
        return this.getAckDeadlineSeconds();
    }

    public long getAckDeadlineSeconds() {
        return this.ackDeadlineSeconds;
    }

    final boolean baseEquals(SubscriptionInfo subscriptionInfo) {
        return Objects.equals(this.topic, subscriptionInfo.topic) && Objects.equals(this.name, subscriptionInfo.name) && Objects.equals(this.pushConfig, subscriptionInfo.pushConfig) && this.ackDeadlineSeconds == subscriptionInfo.ackDeadlineSeconds;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(SubscriptionInfo.class) && this.baseEquals((SubscriptionInfo)obj);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.name, this.pushConfig, this.ackDeadlineSeconds);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("name", (Object)this.name).add("pushConfig", (Object)this.pushConfig).add("ackDeadlineSeconds", this.ackDeadlineSeconds).toString();
    }

    Subscription toPb(String projectId) {
        Subscription.Builder builder = Subscription.newBuilder();
        builder.setTopic(this.topic.toPb(projectId));
        builder.setNameWithSubscriptionName(SubscriptionName.create((String)projectId, (String)this.name));
        builder.setAckDeadlineSeconds(this.ackDeadlineSeconds);
        if (this.pushConfig != null) {
            builder.setPushConfig(this.pushConfig.toPb());
        }
        return builder.build();
    }

    static SubscriptionInfo fromPb(Subscription subscription) {
        Builder builder = SubscriptionInfo.newBuilder(TopicId.fromPb(subscription.getTopic()), subscription.getNameAsSubscriptionName().getSubscription());
        builder.setAckDeadLineSeconds(subscription.getAckDeadlineSeconds());
        if (subscription.hasPushConfig() && !subscription.getPushConfig().getPushEndpoint().equals("")) {
            builder.setPushConfig(PushConfig.fromPb(subscription.getPushConfig()));
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static SubscriptionInfo of(String topic, String name) {
        return SubscriptionInfo.newBuilder(topic, name).build();
    }

    public static SubscriptionInfo of(TopicId topic, String name) {
        return SubscriptionInfo.newBuilder(topic, name).build();
    }

    public static SubscriptionInfo of(String topic, String name, String endpoint) {
        return SubscriptionInfo.newBuilder(topic, name).setPushConfig(PushConfig.of(endpoint)).build();
    }

    public static SubscriptionInfo of(TopicId topic, String name, String endpoint) {
        return SubscriptionInfo.newBuilder(topic, name).setPushConfig(PushConfig.of(endpoint)).build();
    }

    @Deprecated
    public static Builder builder(String topic, String name) {
        return SubscriptionInfo.newBuilder(topic, name);
    }

    public static Builder newBuilder(String topic, String name) {
        return SubscriptionInfo.newBuilder(TopicId.of(topic), name);
    }

    @Deprecated
    public static Builder builder(TopicId topic, String name) {
        return SubscriptionInfo.newBuilder(topic, name);
    }

    public static Builder newBuilder(TopicId topic, String name) {
        return new BuilderImpl(topic, name);
    }

    static final class BuilderImpl
    extends Builder {
        private String name;
        private TopicId topic;
        private PushConfig pushConfig;
        private int ackDeadlineSeconds;

        private BuilderImpl(TopicId topic, String name) {
            this.topic = (TopicId)Preconditions.checkNotNull((Object)topic);
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        BuilderImpl(SubscriptionInfo subscription) {
            this.name = subscription.name;
            this.topic = subscription.topic;
            this.pushConfig = subscription.pushConfig;
            this.ackDeadlineSeconds = subscription.ackDeadlineSeconds;
        }

        @Override
        @Deprecated
        public Builder name(String name) {
            return this.setName(name);
        }

        @Override
        public Builder setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        @Override
        @Deprecated
        public Builder topic(String project, String topic) {
            return this.setTopic(project, topic);
        }

        @Override
        public Builder setTopic(String project, String topic) {
            return this.setTopic(TopicId.of((String)Preconditions.checkNotNull((Object)project), topic));
        }

        @Override
        @Deprecated
        public Builder topic(String topic) {
            return this.setTopic(topic);
        }

        @Override
        public Builder setTopic(String topic) {
            return this.setTopic(TopicId.of(topic));
        }

        @Override
        @Deprecated
        public Builder topic(TopicId topic) {
            return this.setTopic(topic);
        }

        @Override
        public Builder setTopic(TopicId topic) {
            this.topic = (TopicId)Preconditions.checkNotNull((Object)topic);
            return this;
        }

        @Override
        @Deprecated
        public Builder pushConfig(PushConfig pushConfig) {
            return this.setPushConfig(pushConfig);
        }

        @Override
        public Builder setPushConfig(PushConfig pushConfig) {
            this.pushConfig = pushConfig;
            return this;
        }

        @Override
        @Deprecated
        public Builder ackDeadLineSeconds(int ackDeadlineSeconds) {
            return this.setAckDeadLineSeconds(ackDeadlineSeconds);
        }

        @Override
        public Builder setAckDeadLineSeconds(int ackDeadlineSeconds) {
            this.ackDeadlineSeconds = ackDeadlineSeconds;
            return this;
        }

        @Override
        public SubscriptionInfo build() {
            return new SubscriptionInfo(this);
        }
    }

    public static abstract class Builder {
        @Deprecated
        public abstract Builder name(String var1);

        public abstract Builder setName(String var1);

        @Deprecated
        public abstract Builder topic(String var1);

        public abstract Builder setTopic(String var1);

        @Deprecated
        public abstract Builder topic(String var1, String var2);

        public abstract Builder setTopic(String var1, String var2);

        @Deprecated
        public abstract Builder topic(TopicId var1);

        public abstract Builder setTopic(TopicId var1);

        @Deprecated
        public abstract Builder pushConfig(PushConfig var1);

        public abstract Builder setPushConfig(PushConfig var1);

        @Deprecated
        public abstract Builder ackDeadLineSeconds(int var1);

        public abstract Builder setAckDeadLineSeconds(int var1);

        public abstract SubscriptionInfo build();
    }
}

