/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.ByteArray;
import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ReceivedMessage
extends Message {
    private static final long serialVersionUID = -4178477763916251733L;
    private final String subscription;
    private final String ackId;
    private transient PubSub pubsub;
    private final PubSubOptions options;

    ReceivedMessage(Builder builder) {
        super(builder.delegate);
        this.subscription = (String)Preconditions.checkNotNull((Object)builder.subscription);
        this.ackId = (String)Preconditions.checkNotNull((Object)builder.ackId);
        this.pubsub = (PubSub)Preconditions.checkNotNull((Object)builder.pubsub);
        this.options = (PubSubOptions)this.pubsub.getOptions();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.subscription, this.ackId, this.pubsub, new Message.BuilderImpl(this));
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.options, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(ReceivedMessage.class)) {
            return false;
        }
        ReceivedMessage other = (ReceivedMessage)obj;
        return this.baseEquals(other) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Deprecated
    public PubSub pubsub() {
        return this.getPubsub();
    }

    public PubSub getPubsub() {
        return this.pubsub;
    }

    @Deprecated
    public String subscription() {
        return this.getSubscription();
    }

    public String getSubscription() {
        return this.subscription;
    }

    @Deprecated
    public String ackId() {
        return this.getAckId();
    }

    public String getAckId() {
        return this.ackId;
    }

    public void ack() {
        this.pubsub.ack(this.subscription, this.ackId, new String[0]);
    }

    public Future<Void> ackAsync() {
        return this.pubsub.ackAsync(this.subscription, this.ackId, new String[0]);
    }

    public void nack() {
        this.pubsub.nack(this.subscription, this.ackId, new String[0]);
    }

    public Future<Void> nackAsync() {
        return this.pubsub.nackAsync(this.subscription, this.ackId, new String[0]);
    }

    public void modifyAckDeadline(int deadline, TimeUnit unit) {
        this.pubsub.modifyAckDeadline(this.subscription, deadline, unit, this.ackId, new String[0]);
    }

    public Future<Void> modifyAckDeadlineAsync(int deadline, TimeUnit unit) {
        return this.pubsub.modifyAckDeadlineAsync(this.subscription, deadline, unit, this.ackId, new String[0]);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.pubsub = (PubSub)this.options.getService();
    }

    static ReceivedMessage fromPb(PubSub pubsub, String subscription, com.google.pubsub.v1.ReceivedMessage msgPb) {
        Message message = ReceivedMessage.fromPb(msgPb.getMessage());
        String ackId = msgPb.getAckId();
        return new Builder(subscription, ackId, pubsub, new Message.BuilderImpl(message)).build();
    }

    public static final class Builder
    extends Message.Builder {
        private final String subscription;
        private final String ackId;
        private final PubSub pubsub;
        private final Message.BuilderImpl delegate;

        private Builder(String subscription, String ackId, PubSub pubsub, Message.BuilderImpl delegate) {
            this.subscription = subscription;
            this.ackId = ackId;
            this.pubsub = pubsub;
            this.delegate = delegate;
        }

        @Override
        Builder setId(String id) {
            this.delegate.setId(id);
            return this;
        }

        @Override
        @Deprecated
        public Builder payload(String payload) {
            return this.setPayload(payload);
        }

        @Override
        public Builder setPayload(String payload) {
            this.delegate.setPayload(payload);
            return this;
        }

        @Override
        @Deprecated
        public Builder payload(ByteArray payload) {
            return this.setPayload(payload);
        }

        @Override
        public Builder setPayload(ByteArray payload) {
            this.delegate.setPayload(payload);
            return this;
        }

        @Override
        @Deprecated
        public Builder attributes(Map<String, String> attributes) {
            return this.setAttributes((Map)attributes);
        }

        @Override
        public Builder setAttributes(Map<String, String> attributes) {
            this.delegate.setAttributes(attributes);
            return this;
        }

        @Override
        public Builder addAttribute(String name, String value) {
            this.delegate.addAttribute(name, value);
            return this;
        }

        @Override
        public Builder removeAttribute(String name) {
            this.delegate.removeAttribute(name);
            return this;
        }

        @Override
        public Builder clearAttributes() {
            this.delegate.clearAttributes();
            return this;
        }

        @Override
        Builder setPublishTime(long publishTime) {
            this.delegate.setPublishTime(publishTime);
            return this;
        }

        @Override
        public ReceivedMessage build() {
            return new ReceivedMessage(this);
        }
    }
}

