/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.AsyncPage;
import com.google.cloud.AsyncPageImpl;
import com.google.cloud.BaseService;
import com.google.cloud.Page;
import com.google.cloud.PageImpl;
import com.google.cloud.Policy;
import com.google.cloud.ServiceOptions;
import com.google.cloud.pubsub.AckDeadlineRenewer;
import com.google.cloud.pubsub.Message;
import com.google.cloud.pubsub.MessageConsumerImpl;
import com.google.cloud.pubsub.Option;
import com.google.cloud.pubsub.PolicyMarshaller;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.PushConfig;
import com.google.cloud.pubsub.ReceivedMessage;
import com.google.cloud.pubsub.Subscription;
import com.google.cloud.pubsub.SubscriptionId;
import com.google.cloud.pubsub.SubscriptionInfo;
import com.google.cloud.pubsub.Topic;
import com.google.cloud.pubsub.TopicInfo;
import com.google.cloud.pubsub.spi.PubSubRpc;
import com.google.cloud.pubsub.spi.v1.PublisherClient;
import com.google.cloud.pubsub.spi.v1.SubscriberClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class PubSubImpl
extends BaseService<PubSubOptions>
implements PubSub {
    private final PubSubRpc rpc;
    private final AckDeadlineRenewer ackDeadlineRenewer;
    private boolean closed;
    private static final Function<Empty, Void> EMPTY_TO_VOID_FUNCTION = new Function<Empty, Void>(){

        public Void apply(Empty empty) {
            return null;
        }
    };
    private static final Function<Empty, Boolean> EMPTY_TO_BOOLEAN_FUNCTION = new Function<Empty, Boolean>(){

        public Boolean apply(Empty input) {
            return input != null;
        }
    };
    private static final Function<com.google.pubsub.v1.ReceivedMessage, String> MESSAGE_TO_ACK_ID_FUNCTION = new Function<com.google.pubsub.v1.ReceivedMessage, String>(){

        public String apply(com.google.pubsub.v1.ReceivedMessage message) {
            return message.getAckId();
        }
    };
    private static final Function<com.google.iam.v1.Policy, Policy> POLICY_TO_PB_FUNCTION = new Function<com.google.iam.v1.Policy, Policy>(){

        public Policy apply(com.google.iam.v1.Policy policyPb) {
            return policyPb == null ? null : PolicyMarshaller.INSTANCE.fromPb(policyPb);
        }
    };

    PubSubImpl(PubSubOptions options) {
        super((ServiceOptions)options);
        this.rpc = (PubSubRpc)options.getRpc();
        this.ackDeadlineRenewer = new AckDeadlineRenewer(this);
    }

    @VisibleForTesting
    PubSubImpl(PubSubOptions options, AckDeadlineRenewer ackDeadlineRenewer) {
        super((ServiceOptions)options);
        this.rpc = (PubSubRpc)options.getRpc();
        this.ackDeadlineRenewer = ackDeadlineRenewer;
    }

    private static <V> V get(Future<V> future) {
        try {
            return (V)Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException ex) {
            throw Throwables.propagate((Throwable)ex.getCause());
        }
    }

    private static <I, O> Future<O> transform(Future<I> future, Function<? super I, ? extends O> function) {
        if (future instanceof ListenableFuture) {
            return Futures.transform((ListenableFuture)((ListenableFuture)future), function);
        }
        return Futures.lazyTransform(future, function);
    }

    @Override
    public Topic create(TopicInfo topic) {
        return PubSubImpl.get(this.createAsync(topic));
    }

    @Override
    public Future<Topic> createAsync(TopicInfo topic) {
        return PubSubImpl.transform(this.rpc.create(topic.toPb(((PubSubOptions)this.getOptions()).getProjectId())), Topic.fromPbFunction(this));
    }

    @Override
    public Topic getTopic(String topic) {
        return PubSubImpl.get(this.getTopicAsync(topic));
    }

    @Override
    public Future<Topic> getTopicAsync(String topic) {
        GetTopicRequest request = GetTopicRequest.newBuilder().setTopic(PublisherClient.formatTopicName(((PubSubOptions)this.getOptions()).getProjectId(), topic)).build();
        return PubSubImpl.transform(this.rpc.get(request), Topic.fromPbFunction(this));
    }

    @Override
    public boolean deleteTopic(String topic) {
        return PubSubImpl.get(this.deleteTopicAsync(topic));
    }

    @Override
    public Future<Boolean> deleteTopicAsync(String topic) {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(PublisherClient.formatTopicName(((PubSubOptions)this.getOptions()).getProjectId(), topic)).build();
        return PubSubImpl.transform(this.rpc.delete(request), EMPTY_TO_BOOLEAN_FUNCTION);
    }

    private static ListTopicsRequest listTopicsRequest(PubSubOptions serviceOptions, Map<Option.OptionType, ?> options) {
        ListTopicsRequest.Builder builder = ListTopicsRequest.newBuilder();
        builder.setProject(SubscriberClient.formatProjectName(serviceOptions.getProjectId()));
        Integer pageSize = (Integer)PubSub.ListOption.OptionType.PAGE_SIZE.get(options);
        String pageToken = (String)PubSub.ListOption.OptionType.PAGE_TOKEN.get(options);
        if (pageSize != null) {
            builder.setPageSize(pageSize.intValue());
        }
        if (pageToken != null) {
            builder.setPageToken(pageToken);
        }
        return builder.build();
    }

    private static Future<AsyncPage<Topic>> listTopicsAsync(final PubSubOptions serviceOptions, final Map<Option.OptionType, ?> options) {
        ListTopicsRequest request = PubSubImpl.listTopicsRequest(serviceOptions, options);
        Future<ListTopicsResponse> list = ((PubSubRpc)serviceOptions.getRpc()).list(request);
        return PubSubImpl.transform(list, new Function<ListTopicsResponse, AsyncPage<Topic>>(){

            public AsyncPage<Topic> apply(ListTopicsResponse listTopicsResponse) {
                ImmutableList topics = listTopicsResponse.getTopicsList() == null ? ImmutableList.of() : Lists.transform((List)listTopicsResponse.getTopicsList(), Topic.fromPbFunction((PubSub)serviceOptions.getService()));
                String cursor = listTopicsResponse.getNextPageToken().equals("") ? null : listTopicsResponse.getNextPageToken();
                return new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)new TopicPageFetcher(serviceOptions, cursor, options), cursor, (Iterable)topics);
            }
        });
    }

    @Override
    public Page<Topic> listTopics(PubSub.ListOption ... options) {
        return (Page)PubSubImpl.get(this.listTopicsAsync(options));
    }

    @Override
    public Future<AsyncPage<Topic>> listTopicsAsync(PubSub.ListOption ... options) {
        return PubSubImpl.listTopicsAsync((PubSubOptions)this.getOptions(), PubSubImpl.optionMap(options));
    }

    @Override
    public String publish(String topic, Message message) {
        return PubSubImpl.get(this.publishAsync(topic, message));
    }

    private static PublishRequest publishRequest(PubSubOptions serviceOptions, String topic, Iterable<Message> messages) {
        PublishRequest.Builder builder = PublishRequest.newBuilder();
        builder.setTopic(PublisherClient.formatTopicName(serviceOptions.getProjectId(), topic));
        builder.addAllMessages(Iterables.transform(messages, Message.TO_PB_FUNCTION));
        return builder.build();
    }

    @Override
    public Future<String> publishAsync(String topic, Message message) {
        return PubSubImpl.transform(this.rpc.publish(PubSubImpl.publishRequest((PubSubOptions)this.getOptions(), topic, Collections.singletonList(message))), new Function<PublishResponse, String>(){

            public String apply(PublishResponse publishResponse) {
                return (String)publishResponse.getMessageIdsList().get(0);
            }
        });
    }

    @Override
    public List<String> publish(String topic, Message message, Message ... messages) {
        return this.publish(topic, Lists.asList((Object)message, (Object[])messages));
    }

    @Override
    public Future<List<String>> publishAsync(String topic, Message message, Message ... messages) {
        return this.publishAsync(topic, Lists.asList((Object)message, (Object[])messages));
    }

    @Override
    public List<String> publish(String topic, Iterable<Message> messages) {
        return PubSubImpl.get(this.publishAsync(topic, messages));
    }

    @Override
    public Future<List<String>> publishAsync(String topic, Iterable<Message> messages) {
        return PubSubImpl.transform(this.rpc.publish(PubSubImpl.publishRequest((PubSubOptions)this.getOptions(), topic, messages)), new Function<PublishResponse, List<String>>(){

            public List<String> apply(PublishResponse publishResponse) {
                return publishResponse.getMessageIdsList();
            }
        });
    }

    @Override
    public Subscription create(SubscriptionInfo subscription) {
        return PubSubImpl.get(this.createAsync(subscription));
    }

    @Override
    public Future<Subscription> createAsync(SubscriptionInfo subscription) {
        return PubSubImpl.transform(this.rpc.create(subscription.toPb(((PubSubOptions)this.getOptions()).getProjectId())), Subscription.fromPbFunction(this));
    }

    @Override
    public Subscription getSubscription(String subscription) {
        return PubSubImpl.get(this.getSubscriptionAsync(subscription));
    }

    @Override
    public Future<Subscription> getSubscriptionAsync(String subscription) {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscription(SubscriberClient.formatSubscriptionName(((PubSubOptions)this.getOptions()).getProjectId(), subscription)).build();
        return PubSubImpl.transform(this.rpc.get(request), Subscription.fromPbFunction(this));
    }

    @Override
    public void replacePushConfig(String subscription, PushConfig pushConfig) {
        PubSubImpl.get(this.replacePushConfigAsync(subscription, pushConfig));
    }

    @Override
    public Future<Void> replacePushConfigAsync(String subscription, PushConfig pushConfig) {
        ModifyPushConfigRequest request = ModifyPushConfigRequest.newBuilder().setSubscription(SubscriberClient.formatSubscriptionName(((PubSubOptions)this.getOptions()).getProjectId(), subscription)).setPushConfig(pushConfig != null ? pushConfig.toPb() : com.google.pubsub.v1.PushConfig.getDefaultInstance()).build();
        return PubSubImpl.transform(this.rpc.modify(request), EMPTY_TO_VOID_FUNCTION);
    }

    @Override
    public boolean deleteSubscription(String subscription) {
        return PubSubImpl.get(this.deleteSubscriptionAsync(subscription));
    }

    @Override
    public Future<Boolean> deleteSubscriptionAsync(String subscription) {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscription(SubscriberClient.formatSubscriptionName(((PubSubOptions)this.getOptions()).getProjectId(), subscription)).build();
        return PubSubImpl.transform(this.rpc.delete(request), EMPTY_TO_BOOLEAN_FUNCTION);
    }

    private static ListSubscriptionsRequest listSubscriptionsRequest(PubSubOptions serviceOptions, Map<Option.OptionType, ?> options) {
        ListSubscriptionsRequest.Builder builder = ListSubscriptionsRequest.newBuilder();
        builder.setProject(SubscriberClient.formatProjectName(serviceOptions.getProjectId()));
        Integer pageSize = PubSub.ListOption.OptionType.PAGE_SIZE.getInteger(options);
        String pageToken = PubSub.ListOption.OptionType.PAGE_TOKEN.getString(options);
        if (pageSize != null) {
            builder.setPageSize(pageSize.intValue());
        }
        if (pageToken != null) {
            builder.setPageToken(pageToken);
        }
        return builder.build();
    }

    private static Future<AsyncPage<Subscription>> listSubscriptionsAsync(final PubSubOptions serviceOptions, final Map<Option.OptionType, ?> options) {
        ListSubscriptionsRequest request = PubSubImpl.listSubscriptionsRequest(serviceOptions, options);
        Future<ListSubscriptionsResponse> list = ((PubSubRpc)serviceOptions.getRpc()).list(request);
        return PubSubImpl.transform(list, new Function<ListSubscriptionsResponse, AsyncPage<Subscription>>(){

            public AsyncPage<Subscription> apply(ListSubscriptionsResponse listSubscriptionsResponse) {
                ImmutableList subscriptions = listSubscriptionsResponse.getSubscriptionsList() == null ? ImmutableList.of() : Lists.transform((List)listSubscriptionsResponse.getSubscriptionsList(), Subscription.fromPbFunction((PubSub)serviceOptions.getService()));
                String cursor = listSubscriptionsResponse.getNextPageToken().equals("") ? null : listSubscriptionsResponse.getNextPageToken();
                return new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)new SubscriptionPageFetcher(serviceOptions, cursor, options), cursor, (Iterable)subscriptions);
            }
        });
    }

    @Override
    public Page<Subscription> listSubscriptions(PubSub.ListOption ... options) {
        return (Page)PubSubImpl.get(this.listSubscriptionsAsync(options));
    }

    @Override
    public Future<AsyncPage<Subscription>> listSubscriptionsAsync(PubSub.ListOption ... options) {
        return PubSubImpl.listSubscriptionsAsync((PubSubOptions)this.getOptions(), PubSubImpl.optionMap(options));
    }

    private static ListTopicSubscriptionsRequest listSubscriptionsRequest(String topic, PubSubOptions serviceOptions, Map<Option.OptionType, ?> options) {
        ListTopicSubscriptionsRequest.Builder builder = ListTopicSubscriptionsRequest.newBuilder();
        builder.setTopic(PublisherClient.formatTopicName(serviceOptions.getProjectId(), topic));
        Integer pageSize = PubSub.ListOption.OptionType.PAGE_SIZE.getInteger(options);
        String pageToken = PubSub.ListOption.OptionType.PAGE_TOKEN.getString(options);
        if (pageSize != null) {
            builder.setPageSize(pageSize.intValue());
        }
        if (pageToken != null) {
            builder.setPageToken(pageToken);
        }
        return builder.build();
    }

    private static Future<AsyncPage<SubscriptionId>> listSubscriptionsAsync(final String topic, final PubSubOptions serviceOptions, final Map<Option.OptionType, ?> options) {
        ListTopicSubscriptionsRequest request = PubSubImpl.listSubscriptionsRequest(topic, serviceOptions, options);
        Future<ListTopicSubscriptionsResponse> list = ((PubSubRpc)serviceOptions.getRpc()).list(request);
        return PubSubImpl.transform(list, new Function<ListTopicSubscriptionsResponse, AsyncPage<SubscriptionId>>(){

            public AsyncPage<SubscriptionId> apply(ListTopicSubscriptionsResponse listSubscriptionsResponse) {
                ImmutableList subscriptions = listSubscriptionsResponse.getSubscriptionsList() == null ? ImmutableList.of() : Lists.transform((List)listSubscriptionsResponse.getSubscriptionsList(), (Function)new Function<String, SubscriptionId>(){

                    public SubscriptionId apply(String compositeSubscription) {
                        return SubscriptionId.fromPb(compositeSubscription);
                    }
                });
                String cursor = listSubscriptionsResponse.getNextPageToken().equals("") ? null : listSubscriptionsResponse.getNextPageToken();
                return new AsyncPageImpl((AsyncPageImpl.NextPageFetcher)new SubscriptionNamePageFetcher(topic, serviceOptions, cursor, options), cursor, (Iterable)subscriptions);
            }
        });
    }

    @Override
    public Page<SubscriptionId> listSubscriptions(String topic, PubSub.ListOption ... options) {
        return (Page)PubSubImpl.get(this.listSubscriptionsAsync(topic, options));
    }

    @Override
    public Future<AsyncPage<SubscriptionId>> listSubscriptionsAsync(String topic, PubSub.ListOption ... options) {
        return PubSubImpl.listSubscriptionsAsync(topic, (PubSubOptions)this.getOptions(), PubSubImpl.optionMap(options));
    }

    private Future<Iterator<ReceivedMessage>> pullAsync(final String subscription, int maxMessages, boolean returnImmediately) {
        PullRequest request = PullRequest.newBuilder().setSubscription(SubscriberClient.formatSubscriptionName(((PubSubOptions)this.getOptions()).getProjectId(), subscription)).setMaxMessages(maxMessages).setReturnImmediately(returnImmediately).build();
        PubSubRpc.PullFuture future = this.rpc.pull(request);
        future.addCallback(new PubSubRpc.PullCallback(){

            @Override
            public void success(PullResponse response) {
                List ackIds = Lists.transform((List)response.getReceivedMessagesList(), (Function)MESSAGE_TO_ACK_ID_FUNCTION);
                PubSubImpl.this.ackDeadlineRenewer.add(subscription, ackIds);
            }

            @Override
            public void failure(Throwable error) {
            }
        });
        return PubSubImpl.transform(future, new Function<PullResponse, Iterator<ReceivedMessage>>(){

            public Iterator<ReceivedMessage> apply(PullResponse response) {
                return Iterators.transform(response.getReceivedMessagesList().iterator(), (Function)new Function<com.google.pubsub.v1.ReceivedMessage, ReceivedMessage>(){

                    public ReceivedMessage apply(com.google.pubsub.v1.ReceivedMessage receivedMessage) {
                        PubSubImpl.this.ackDeadlineRenewer.remove(subscription, receivedMessage.getAckId());
                        return ReceivedMessage.fromPb(PubSubImpl.this, subscription, receivedMessage);
                    }
                });
            }
        });
    }

    @Override
    public Iterator<ReceivedMessage> pull(String subscription, int maxMessages) {
        return PubSubImpl.get(this.pullAsync(subscription, maxMessages, true));
    }

    @Override
    public Future<Iterator<ReceivedMessage>> pullAsync(String subscription, int maxMessages) {
        return this.pullAsync(subscription, maxMessages, false);
    }

    @Override
    public PubSub.MessageConsumer pullAsync(String subscription, PubSub.MessageProcessor callback, PubSub.PullOption ... options) {
        Map<Option.OptionType, ?> optionMap = PubSubImpl.optionMap(options);
        return MessageConsumerImpl.builder((PubSubOptions)this.getOptions(), subscription, this.ackDeadlineRenewer, callback).maxQueuedCallbacks(PubSub.PullOption.OptionType.MAX_QUEUED_CALLBACKS.getInteger(optionMap)).executorFactory(PubSub.PullOption.OptionType.EXECUTOR_FACTORY.getExecutorFactory(optionMap)).build();
    }

    @Override
    public void ack(String subscription, String ackId, String ... ackIds) {
        this.ack(subscription, Lists.asList((Object)ackId, (Object[])ackIds));
    }

    @Override
    public Future<Void> ackAsync(String subscription, String ackId, String ... ackIds) {
        return this.ackAsync(subscription, Lists.asList((Object)ackId, (Object[])ackIds));
    }

    @Override
    public void ack(String subscription, Iterable<String> ackIds) {
        PubSubImpl.get(this.ackAsync(subscription, ackIds));
    }

    @Override
    public Future<Void> ackAsync(String subscription, Iterable<String> ackIds) {
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(SubscriberClient.formatSubscriptionName(((PubSubOptions)this.getOptions()).getProjectId(), subscription)).addAllAckIds(ackIds).build();
        return PubSubImpl.transform(this.rpc.acknowledge(request), EMPTY_TO_VOID_FUNCTION);
    }

    @Override
    public void nack(String subscription, String ackId, String ... ackIds) {
        this.nack(subscription, Lists.asList((Object)ackId, (Object[])ackIds));
    }

    @Override
    public Future<Void> nackAsync(String subscription, String ackId, String ... ackIds) {
        return this.nackAsync(subscription, Lists.asList((Object)ackId, (Object[])ackIds));
    }

    @Override
    public void nack(String subscription, Iterable<String> ackIds) {
        PubSubImpl.get(this.nackAsync(subscription, ackIds));
    }

    @Override
    public Future<Void> nackAsync(String subscription, Iterable<String> ackIds) {
        return this.modifyAckDeadlineAsync(subscription, 0, TimeUnit.SECONDS, ackIds);
    }

    @Override
    public void modifyAckDeadline(String subscription, int deadline, TimeUnit unit, String ackId, String ... ackIds) {
        PubSubImpl.get(this.modifyAckDeadlineAsync(subscription, deadline, unit, Lists.asList((Object)ackId, (Object[])ackIds)));
    }

    @Override
    public Future<Void> modifyAckDeadlineAsync(String subscription, int deadline, TimeUnit unit, String ackId, String ... ackIds) {
        return this.modifyAckDeadlineAsync(subscription, deadline, unit, Lists.asList((Object)ackId, (Object[])ackIds));
    }

    @Override
    public void modifyAckDeadline(String subscription, int deadline, TimeUnit unit, Iterable<String> ackIds) {
        PubSubImpl.get(this.modifyAckDeadlineAsync(subscription, deadline, unit, ackIds));
    }

    @Override
    public Future<Void> modifyAckDeadlineAsync(String subscription, int deadline, TimeUnit unit, Iterable<String> ackIds) {
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setSubscription(SubscriberClient.formatSubscriptionName(((PubSubOptions)this.getOptions()).getProjectId(), subscription)).setAckDeadlineSeconds((int)TimeUnit.SECONDS.convert(deadline, unit)).addAllAckIds(ackIds).build();
        return PubSubImpl.transform(this.rpc.modify(request), EMPTY_TO_VOID_FUNCTION);
    }

    @Override
    public Policy getTopicPolicy(String topic) {
        return PubSubImpl.get(this.getTopicPolicyAsync(topic));
    }

    @Override
    public Future<Policy> getTopicPolicyAsync(String topic) {
        return PubSubImpl.transform(this.rpc.getIamPolicy(PublisherClient.formatTopicName(((PubSubOptions)this.getOptions()).getProjectId(), topic)), POLICY_TO_PB_FUNCTION);
    }

    @Override
    public Policy replaceTopicPolicy(String topic, Policy newPolicy) {
        return PubSubImpl.get(this.replaceTopicPolicyAsync(topic, newPolicy));
    }

    @Override
    public Future<Policy> replaceTopicPolicyAsync(String topic, Policy newPolicy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setPolicy(PolicyMarshaller.INSTANCE.toPb(newPolicy)).setResource(PublisherClient.formatTopicName(((PubSubOptions)this.getOptions()).getProjectId(), topic)).build();
        return PubSubImpl.transform(this.rpc.setIamPolicy(request), POLICY_TO_PB_FUNCTION);
    }

    @Override
    public List<Boolean> testTopicPermissions(String topic, List<String> permissions) {
        return PubSubImpl.get(this.testTopicPermissionsAsync(topic, permissions));
    }

    @Override
    public Future<List<Boolean>> testTopicPermissionsAsync(String topic, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(PublisherClient.formatTopicName(((PubSubOptions)this.getOptions()).getProjectId(), topic)).addAllPermissions(permissions).build();
        return PubSubImpl.transform(this.rpc.testIamPermissions(request), PubSubImpl.permissionsFromPbFunction(permissions));
    }

    @Override
    public Policy getSubscriptionPolicy(String subscription) {
        return PubSubImpl.get(this.getSubscriptionPolicyAsync(subscription));
    }

    @Override
    public Future<Policy> getSubscriptionPolicyAsync(String subscription) {
        return PubSubImpl.transform(this.rpc.getIamPolicy(SubscriberClient.formatSubscriptionName(((PubSubOptions)this.getOptions()).getProjectId(), subscription)), POLICY_TO_PB_FUNCTION);
    }

    @Override
    public Policy replaceSubscriptionPolicy(String subscription, Policy newPolicy) {
        return PubSubImpl.get(this.replaceSubscriptionPolicyAsync(subscription, newPolicy));
    }

    @Override
    public Future<Policy> replaceSubscriptionPolicyAsync(String subscription, Policy newPolicy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setPolicy(PolicyMarshaller.INSTANCE.toPb(newPolicy)).setResource(SubscriberClient.formatSubscriptionName(((PubSubOptions)this.getOptions()).getProjectId(), subscription)).build();
        return PubSubImpl.transform(this.rpc.setIamPolicy(request), POLICY_TO_PB_FUNCTION);
    }

    @Override
    public List<Boolean> testSubscriptionPermissions(String subscription, List<String> permissions) {
        return PubSubImpl.get(this.testSubscriptionPermissionsAsync(subscription, permissions));
    }

    @Override
    public Future<List<Boolean>> testSubscriptionPermissionsAsync(String subscription, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(SubscriberClient.formatSubscriptionName(((PubSubOptions)this.getOptions()).getProjectId(), subscription)).addAllPermissions(permissions).build();
        return PubSubImpl.transform(this.rpc.testIamPermissions(request), PubSubImpl.permissionsFromPbFunction(permissions));
    }

    private static Function<TestIamPermissionsResponse, List<Boolean>> permissionsFromPbFunction(final List<String> permissions) {
        return new Function<TestIamPermissionsResponse, List<Boolean>>(){

            public List<Boolean> apply(TestIamPermissionsResponse response) {
                ImmutableSet permissionsOwned = ImmutableSet.copyOf((Collection)((Collection)MoreObjects.firstNonNull((Object)response.getPermissionsList(), (Object)ImmutableList.of())));
                ImmutableList.Builder answer = ImmutableList.builder();
                for (String permission : permissions) {
                    answer.add((Object)permissionsOwned.contains(permission));
                }
                return answer.build();
            }
        };
    }

    static <T extends Option.OptionType> Map<Option.OptionType, ?> optionMap(Option ... options) {
        HashMap optionMap = Maps.newHashMap();
        for (Option option : options) {
            Object prev = optionMap.put(option.getOptionType(), option.getValue());
            Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Duplicate option %s", (Object[])new Object[]{option});
        }
        return optionMap;
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.rpc.close();
        if (this.ackDeadlineRenewer != null) {
            this.ackDeadlineRenewer.close();
        }
    }

    private static class SubscriptionNamePageFetcher
    extends BasePageFetcher<SubscriptionId> {
        private static final long serialVersionUID = 7250525437694464444L;
        private final String topic;

        SubscriptionNamePageFetcher(String topic, PubSubOptions serviceOptions, String cursor, Map<Option.OptionType, ?> requestOptions) {
            super(serviceOptions, cursor, requestOptions);
            this.topic = topic;
        }

        @Deprecated
        public Future<AsyncPage<SubscriptionId>> nextPage() {
            return this.getNextPage();
        }

        public Future<AsyncPage<SubscriptionId>> getNextPage() {
            return PubSubImpl.listSubscriptionsAsync(this.topic, this.serviceOptions(), this.requestOptions());
        }
    }

    private static class SubscriptionPageFetcher
    extends BasePageFetcher<Subscription> {
        private static final long serialVersionUID = -5634446170301177992L;

        SubscriptionPageFetcher(PubSubOptions serviceOptions, String cursor, Map<Option.OptionType, ?> requestOptions) {
            super(serviceOptions, cursor, requestOptions);
        }

        @Deprecated
        public Future<AsyncPage<Subscription>> nextPage() {
            return this.getNextPage();
        }

        public Future<AsyncPage<Subscription>> getNextPage() {
            return PubSubImpl.listSubscriptionsAsync(this.serviceOptions(), this.requestOptions());
        }
    }

    private static class TopicPageFetcher
    extends BasePageFetcher<Topic> {
        private static final long serialVersionUID = -7153536453427361814L;

        TopicPageFetcher(PubSubOptions serviceOptions, String cursor, Map<Option.OptionType, ?> requestOptions) {
            super(serviceOptions, cursor, requestOptions);
        }

        @Deprecated
        public Future<AsyncPage<Topic>> nextPage() {
            return this.getNextPage();
        }

        public Future<AsyncPage<Topic>> getNextPage() {
            return PubSubImpl.listTopicsAsync(this.serviceOptions(), this.requestOptions());
        }
    }

    private static abstract class BasePageFetcher<T>
    implements AsyncPageImpl.NextPageFetcher<T> {
        private static final long serialVersionUID = -2122989557125999209L;
        private final PubSubOptions serviceOptions;
        private final Map<Option.OptionType, ?> requestOptions;

        private BasePageFetcher(PubSubOptions serviceOptions, String cursor, Map<Option.OptionType, ?> requestOptions) {
            this.serviceOptions = serviceOptions;
            this.requestOptions = PageImpl.nextRequestOptions((Object)PubSub.ListOption.OptionType.PAGE_TOKEN, (String)cursor, requestOptions);
        }

        PubSubOptions serviceOptions() {
            return this.serviceOptions;
        }

        Map<Option.OptionType, ?> requestOptions() {
            return this.requestOptions;
        }
    }
}

