/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.testing;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.RetryParams;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.testing.BaseEmulatorHelper;
import com.google.common.collect.ImmutableList;
import io.grpc.ManagedChannel;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;

public class LocalPubSubHelper
extends BaseEmulatorHelper<PubSubOptions> {
    private final List<BaseEmulatorHelper.EmulatorRunner> emulatorRunners;
    private static final String GCLOUD_CMD_TEXT = "gcloud beta emulators pubsub start";
    private static final String GCLOUD_CMD_PORT_FLAG = "--host-port=";
    private static final String VERSION_PREFIX = "pubsub-emulator";
    private static final String MIN_VERSION = "2016.01.13";
    private static final String BIN_CMD_PORT_FLAG = "--port=";
    private static final String FILENAME = "pubsub-emulator-20160113-2.zip";
    private static final String BIN_NAME = "pubsub-emulator/bin/cloud-pubsub-fake";
    private static final String MD5_CHECKSUM = "20943e9defa300f2de101568459c133d";
    private static final URL EMULATOR_URL;
    private static final Logger LOGGER;

    private LocalPubSubHelper() {
        super("pubsub", BaseEmulatorHelper.findAvailablePort((int)8080), "test-project-" + UUID.randomUUID().toString());
        String binName = BIN_NAME;
        if (LocalPubSubHelper.isWindows()) {
            binName = BIN_NAME.replace("/", "\\");
        }
        ArrayList<String> gcloudCommand = new ArrayList<String>(Arrays.asList(GCLOUD_CMD_TEXT.split(" ")));
        gcloudCommand.add("--host-port=localhost:" + this.getPort());
        BaseEmulatorHelper.GcloudEmulatorRunner gcloudRunner = new BaseEmulatorHelper.GcloudEmulatorRunner(gcloudCommand, VERSION_PREFIX, MIN_VERSION);
        BaseEmulatorHelper.DownloadableEmulatorRunner downloadRunner = new BaseEmulatorHelper.DownloadableEmulatorRunner(Arrays.asList(binName, BIN_CMD_PORT_FLAG + this.getPort()), EMULATOR_URL, MD5_CHECKSUM);
        this.emulatorRunners = ImmutableList.of((Object)gcloudRunner, (Object)downloadRunner);
    }

    protected List<BaseEmulatorHelper.EmulatorRunner> getEmulatorRunners() {
        return this.emulatorRunners;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public ManagedChannel createChannel() {
        return NettyChannelBuilder.forAddress((String)"localhost", (int)this.getPort()).negotiationType(NegotiationType.PLAINTEXT).build();
    }

    public PubSubOptions getOptions() {
        return ((PubSubOptions.Builder)((PubSubOptions.Builder)((PubSubOptions.Builder)((PubSubOptions.Builder)PubSubOptions.newBuilder().setProjectId(this.getProjectId())).setHost("localhost:" + this.getPort())).setCredentials((Credentials)NoCredentials.getInstance())).setRetryParams(RetryParams.noRetries())).build();
    }

    public static LocalPubSubHelper create() {
        return new LocalPubSubHelper();
    }

    public void start() throws IOException, InterruptedException {
        String blockUntilOutput = "Server started, listening on " + this.getPort();
        this.startProcess(blockUntilOutput);
    }

    public void reset() throws IOException {
        this.sendPostRequest("/reset");
    }

    public void stop() throws IOException, InterruptedException {
        this.sendPostRequest("/shutdown");
        this.stopProcess();
    }

    static {
        LOGGER = Logger.getLogger(LocalPubSubHelper.class.getName());
        try {
            EMULATOR_URL = new URL("http://storage.googleapis.com/pubsub/tools/pubsub-emulator-20160113-2.zip");
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

