/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.spi;

import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.FixedChannelProvider;
import com.google.api.gax.grpc.FixedExecutorProvider;
import com.google.api.gax.grpc.ProviderManager;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.NoCredentials;
import com.google.cloud.pubsub.PubSubException;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.cloud.pubsub.spi.PubSubRpc;
import com.google.cloud.pubsub.spi.v1.PublisherClient;
import com.google.cloud.pubsub.spi.v1.PublisherSettings;
import com.google.cloud.pubsub.spi.v1.SubscriberClient;
import com.google.cloud.pubsub.spi.v1.SubscriberSettings;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class DefaultPubSubRpc
implements PubSubRpc {
    private final PublisherClient publisherClient;
    private final SubscriberClient subscriberClient;
    private final SubscriberClient noTimeoutSubscriberClient;
    private final ScheduledExecutorService executor;
    private final ProviderManager providerManager;
    private final GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    private boolean closed;

    public DefaultPubSubRpc(PubSubOptions options) throws IOException {
        InternalPubSubOptions internalOptions = new InternalPubSubOptions(options);
        this.executorFactory = internalOptions.getExecutorFactory();
        this.executor = (ScheduledExecutorService)this.executorFactory.get();
        try {
            ChannelProvider channelProvider;
            FixedExecutorProvider executorProvider = FixedExecutorProvider.create((ScheduledExecutorService)this.executor);
            if (options.getHost().contains("localhost") || options.getCredentials().equals(NoCredentials.getInstance())) {
                ManagedChannelImpl managedChannel = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)options.getHost()).negotiationType(NegotiationType.PLAINTEXT).executor((Executor)this.executor)).build();
                channelProvider = FixedChannelProvider.create((ManagedChannel)managedChannel);
            } else {
                channelProvider = internalOptions.getChannelProvider();
            }
            this.providerManager = ProviderManager.newBuilder().setChannelProvider(channelProvider).setExecutorProvider((ExecutorProvider)executorProvider).build();
            UnaryCallSettings.Builder callSettingsBuilder = internalOptions.getApiCallSettings();
            PublisherSettings.Builder pubBuilder = PublisherSettings.defaultBuilder().setExecutorProvider((ExecutorProvider)this.providerManager).setChannelProvider((ChannelProvider)this.providerManager).applyToAllUnaryMethods(callSettingsBuilder);
            SubscriberSettings.Builder subBuilder = SubscriberSettings.defaultBuilder().setExecutorProvider((ExecutorProvider)this.providerManager).setChannelProvider((ChannelProvider)this.providerManager).applyToAllUnaryMethods(callSettingsBuilder);
            this.publisherClient = PublisherClient.create(pubBuilder.build());
            this.subscriberClient = SubscriberClient.create(subBuilder.build());
            callSettingsBuilder.setRetrySettingsBuilder(callSettingsBuilder.getRetrySettingsBuilder().setTotalTimeout(Duration.millis((long)Long.MAX_VALUE)).setInitialRpcTimeout(Duration.millis((long)Long.MAX_VALUE)).setMaxRpcTimeout(Duration.millis((long)Long.MAX_VALUE)));
            subBuilder.applyToAllUnaryMethods(callSettingsBuilder);
            this.noTimeoutSubscriberClient = SubscriberClient.create(subBuilder.build());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private static <V> ListenableFuture<V> translate(ListenableFuture<V> from, final boolean idempotent, int ... returnNullOn) {
        final HashSet returnNullOnSet = Sets.newHashSetWithExpectedSize((int)returnNullOn.length);
        for (int value : returnNullOn) {
            returnNullOnSet.add(value);
        }
        return Futures.catching(from, ApiException.class, (Function)new Function<ApiException, V>(){

            public V apply(ApiException exception) {
                if (returnNullOnSet.contains(exception.getStatusCode().value())) {
                    return null;
                }
                throw new PubSubException(exception, idempotent);
            }
        });
    }

    @Override
    public Future<Topic> create(Topic topic) {
        return DefaultPubSubRpc.translate(this.publisherClient.createTopicCallable().futureCall((Object)topic), true, new int[0]);
    }

    @Override
    public Future<PublishResponse> publish(PublishRequest request) {
        return DefaultPubSubRpc.translate(this.publisherClient.publishCallable().futureCall((Object)request), false, new int[0]);
    }

    @Override
    public Future<Topic> get(GetTopicRequest request) {
        return DefaultPubSubRpc.translate(this.publisherClient.getTopicCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<ListTopicsResponse> list(ListTopicsRequest request) {
        return DefaultPubSubRpc.translate(this.publisherClient.listTopicsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<ListTopicSubscriptionsResponse> list(ListTopicSubscriptionsRequest request) {
        return DefaultPubSubRpc.translate(this.publisherClient.listTopicSubscriptionsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<Empty> delete(DeleteTopicRequest request) {
        return DefaultPubSubRpc.translate(this.publisherClient.deleteTopicCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<Subscription> create(Subscription subscription) {
        return DefaultPubSubRpc.translate(this.subscriberClient.createSubscriptionCallable().futureCall((Object)subscription), false, new int[0]);
    }

    @Override
    public Future<Subscription> get(GetSubscriptionRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberClient.getSubscriptionCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<ListSubscriptionsResponse> list(ListSubscriptionsRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberClient.listSubscriptionsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<Empty> delete(DeleteSubscriptionRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberClient.deleteSubscriptionCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<Empty> modify(ModifyAckDeadlineRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberClient.modifyAckDeadlineCallable().futureCall((Object)request), false, new int[0]);
    }

    @Override
    public Future<Empty> acknowledge(AcknowledgeRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberClient.acknowledgeCallable().futureCall((Object)request), false, new int[0]);
    }

    private static PubSubRpc.PullFuture pull(SubscriberClient subscriberClient, PullRequest request) {
        return new PullFutureImpl(DefaultPubSubRpc.translate(subscriberClient.pullCallable().futureCall((Object)request), false, new int[0]));
    }

    @Override
    public PubSubRpc.PullFuture pull(PullRequest request) {
        return request.getReturnImmediately() ? DefaultPubSubRpc.pull(this.subscriberClient, request) : DefaultPubSubRpc.pull(this.noTimeoutSubscriberClient, request);
    }

    @Override
    public Future<Empty> modify(ModifyPushConfigRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberClient.modifyPushConfigCallable().futureCall((Object)request), false, new int[0]);
    }

    @Override
    public Future<Policy> getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return DefaultPubSubRpc.translate(this.subscriberClient.getIamPolicyCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<Policy> setIamPolicy(SetIamPolicyRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberClient.setIamPolicyCallable().futureCall((Object)request), false, new int[0]);
    }

    @Override
    public Future<TestIamPermissionsResponse> testIamPermissions(TestIamPermissionsRequest request) {
        return DefaultPubSubRpc.translate(this.subscriberClient.testIamPermissionsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.subscriberClient.close();
        this.noTimeoutSubscriberClient.close();
        this.publisherClient.close();
        this.providerManager.getChannel().shutdown();
        this.executorFactory.release((ExecutorService)this.executor);
    }

    private static final class PullFutureImpl
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<PullResponse>
    implements PubSubRpc.PullFuture {
        PullFutureImpl(ListenableFuture<PullResponse> delegate) {
            super(delegate);
        }

        @Override
        public void addCallback(final PubSubRpc.PullCallback callback) {
            Futures.addCallback((ListenableFuture)this.delegate(), (FutureCallback)new FutureCallback<PullResponse>(){

                public void onSuccess(PullResponse result) {
                    callback.success(result);
                }

                public void onFailure(Throwable error) {
                    callback.failure(error);
                }
            });
        }
    }

    private static final class InternalPubSubOptions
    extends PubSubOptions {
        private static final long serialVersionUID = -7997372049256706185L;

        private InternalPubSubOptions(PubSubOptions options) {
            super(options.toBuilder());
        }

        @Override
        protected GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService> getExecutorFactory() {
            return super.getExecutorFactory();
        }

        protected UnaryCallSettings.Builder getApiCallSettings() {
            return super.getApiCallSettings();
        }

        protected ChannelProvider getChannelProvider() {
            return super.getChannelProvider();
        }
    }
}

