/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.pubsub.spi.v1.SubscriberClient;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public class SubscriptionId
implements Serializable {
    private static final long serialVersionUID = 6507142968866856283L;
    private final String project;
    private final String subscription;

    SubscriptionId(String project, String subscription) {
        this.project = (String)Preconditions.checkNotNull((Object)project);
        this.subscription = (String)Preconditions.checkNotNull((Object)subscription);
    }

    @Deprecated
    public String project() {
        return this.getProject();
    }

    public String getProject() {
        return this.project;
    }

    @Deprecated
    public String subscription() {
        return this.getSubscription();
    }

    public String getSubscription() {
        return this.subscription;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("project", (Object)this.project).add("subscription", (Object)this.subscription).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.project, this.subscription);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubscriptionId)) {
            return false;
        }
        SubscriptionId other = (SubscriptionId)obj;
        return Objects.equals(this.project, other.project) && Objects.equals(this.subscription, other.subscription);
    }

    static SubscriptionId fromPb(String pb) {
        return new SubscriptionId(SubscriberClient.parseProjectFromSubscriptionName(pb), SubscriberClient.parseSubscriptionFromSubscriptionName(pb));
    }
}

