/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.pubsub.spi.v1.PublisherApi;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class TopicId
implements Serializable {
    private static final long serialVersionUID = -4913169763174877777L;
    private static final String DELETED_TOPIC_NAME = "_deleted-topic_";
    private static final TopicId DELETED_TOPIC = new TopicId(null, "_deleted-topic_", true);
    private final String project;
    private final String topic;
    private final boolean isDeleted;

    private TopicId(String project, String topic, boolean isDeleted) {
        this.project = project;
        this.topic = (String)Preconditions.checkNotNull((Object)topic);
        this.isDeleted = isDeleted;
    }

    private TopicId(String project, String topic) {
        this(project, topic, false);
    }

    public String project() {
        return this.project;
    }

    public String topic() {
        return this.topic;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("project", (Object)this.project).add("topic", (Object)this.topic).add("isDeleted", this.isDeleted).toString();
    }

    public int hashCode() {
        return Objects.hash(this.project, this.topic, this.isDeleted);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TopicId)) {
            return false;
        }
        TopicId other = (TopicId)obj;
        return Objects.equals(this.project, other.project) && Objects.equals(this.topic, other.topic) && Objects.equals(this.isDeleted, other.isDeleted);
    }

    String toPb(String projectId) {
        return PublisherApi.formatTopicName(this.project != null ? this.project : projectId, this.topic);
    }

    public static TopicId deletedTopic() {
        return DELETED_TOPIC;
    }

    public static TopicId of(String topic) {
        return new TopicId(null, topic);
    }

    public static TopicId of(String project, String topic) {
        return new TopicId(project, topic);
    }

    static TopicId fromPb(String pb) {
        if (Objects.equals(pb, DELETED_TOPIC_NAME)) {
            return DELETED_TOPIC;
        }
        return TopicId.of(PublisherApi.parseProjectFromTopicName(pb), PublisherApi.parseTopicFromTopicName(pb));
    }
}

