/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.pubsub.PushConfig;
import com.google.cloud.pubsub.TopicId;
import com.google.cloud.pubsub.spi.v1.SubscriberApi;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.pubsub.v1.Subscription;
import java.io.Serializable;
import java.util.Objects;

public class SubscriptionInfo
implements Serializable {
    private static final long serialVersionUID = 1860057426574127128L;
    private final String name;
    private final TopicId topic;
    private final PushConfig pushConfig;
    private final int ackDeadlineSeconds;

    SubscriptionInfo(BuilderImpl builder) {
        this.topic = builder.topic;
        this.name = builder.name;
        this.pushConfig = builder.pushConfig;
        this.ackDeadlineSeconds = builder.ackDeadlineSeconds;
    }

    public TopicId topic() {
        return this.topic;
    }

    public String name() {
        return this.name;
    }

    public PushConfig pushConfig() {
        return this.pushConfig;
    }

    public long ackDeadlineSeconds() {
        return this.ackDeadlineSeconds;
    }

    final boolean baseEquals(SubscriptionInfo subscriptionInfo) {
        return Objects.equals(this.topic, subscriptionInfo.topic) && Objects.equals(this.name, subscriptionInfo.name) && Objects.equals(this.pushConfig, subscriptionInfo.pushConfig) && this.ackDeadlineSeconds == subscriptionInfo.ackDeadlineSeconds;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(SubscriptionInfo.class) && this.baseEquals((SubscriptionInfo)obj);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.name, this.pushConfig, this.ackDeadlineSeconds);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("name", (Object)this.name).add("pushConfig", (Object)this.pushConfig).add("ackDeadlineSeconds", this.ackDeadlineSeconds).toString();
    }

    Subscription toPb(String projectId) {
        Subscription.Builder builder = Subscription.newBuilder();
        builder.setTopic(this.topic.toPb(projectId));
        builder.setName(SubscriberApi.formatSubscriptionName(projectId, this.name));
        builder.setAckDeadlineSeconds(this.ackDeadlineSeconds);
        if (this.pushConfig != null) {
            builder.setPushConfig(this.pushConfig.toPb());
        }
        return builder.build();
    }

    static SubscriptionInfo fromPb(Subscription subscription) {
        Builder builder = SubscriptionInfo.builder(TopicId.fromPb(subscription.getTopic()), SubscriberApi.parseSubscriptionFromSubscriptionName(subscription.getName()));
        builder.ackDeadLineSeconds(subscription.getAckDeadlineSeconds());
        if (subscription.hasPushConfig() && !subscription.getPushConfig().getPushEndpoint().equals("")) {
            builder.pushConfig(PushConfig.fromPb(subscription.getPushConfig()));
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static SubscriptionInfo of(String topic, String name) {
        return SubscriptionInfo.builder(topic, name).build();
    }

    public static SubscriptionInfo of(TopicId topic, String name) {
        return SubscriptionInfo.builder(topic, name).build();
    }

    public static SubscriptionInfo of(String topic, String name, String endpoint) {
        return SubscriptionInfo.builder(topic, name).pushConfig(PushConfig.of(endpoint)).build();
    }

    public static SubscriptionInfo of(TopicId topic, String name, String endpoint) {
        return SubscriptionInfo.builder(topic, name).pushConfig(PushConfig.of(endpoint)).build();
    }

    public static Builder builder(String topic, String name) {
        return SubscriptionInfo.builder(TopicId.of(topic), name);
    }

    public static Builder builder(TopicId topic, String name) {
        return new BuilderImpl(topic, name);
    }

    static final class BuilderImpl
    extends Builder {
        private String name;
        private TopicId topic;
        private PushConfig pushConfig;
        private int ackDeadlineSeconds;

        private BuilderImpl(TopicId topic, String name) {
            this.topic = (TopicId)Preconditions.checkNotNull((Object)topic);
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        BuilderImpl(SubscriptionInfo subscription) {
            this.name = subscription.name;
            this.topic = subscription.topic;
            this.pushConfig = subscription.pushConfig;
            this.ackDeadlineSeconds = subscription.ackDeadlineSeconds;
        }

        @Override
        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        @Override
        public Builder topic(String project, String topic) {
            return this.topic(TopicId.of((String)Preconditions.checkNotNull((Object)project), topic));
        }

        @Override
        public Builder topic(String topic) {
            return this.topic(TopicId.of(topic));
        }

        @Override
        public Builder topic(TopicId topic) {
            this.topic = (TopicId)Preconditions.checkNotNull((Object)topic);
            return this;
        }

        @Override
        public Builder pushConfig(PushConfig pushConfig) {
            this.pushConfig = pushConfig;
            return this;
        }

        @Override
        public Builder ackDeadLineSeconds(int ackDeadlineSeconds) {
            this.ackDeadlineSeconds = ackDeadlineSeconds;
            return this;
        }

        @Override
        public SubscriptionInfo build() {
            return new SubscriptionInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder name(String var1);

        public abstract Builder topic(String var1);

        public abstract Builder topic(String var1, String var2);

        public abstract Builder topic(TopicId var1);

        public abstract Builder pushConfig(PushConfig var1);

        public abstract Builder ackDeadLineSeconds(int var1);

        public abstract SubscriptionInfo build();
    }
}

