/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.InternalApi;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;

class AtomicRoundRobin {
    private final int max;
    private final AtomicInteger current;

    AtomicRoundRobin(int max) {
        Preconditions.checkArgument((max > 0 ? 1 : 0) != 0);
        this.max = max;
        this.current = new AtomicInteger(0);
    }

    int next() {
        int next = this.current.getAndIncrement() % this.max;
        if (next < 0) {
            next += this.max;
        }
        return next;
    }

    @InternalApi
    void set(int i) {
        this.current.set(i);
    }
}

