/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub;

import com.google.cloud.Clock;
import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.pubsub.PubSub;
import com.google.cloud.pubsub.PubSubOptions;
import com.google.common.base.MoreObjects;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class AckDeadlineRenewer
implements AutoCloseable {
    private static final int MIN_DEADLINE_MILLIS = 10000;
    private static final int DEADLINE_SLACK_MILLIS = 1000;
    private static final int RENEW_THRESHOLD_MILLIS = 3000;
    private static final int NEXT_RENEWAL_THRESHOLD_MILLIS = 1000;
    private final PubSub pubsub;
    private final ScheduledExecutorService executor;
    private final GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    private final Clock clock;
    private final Queue<Message> messageQueue;
    private final Map<MessageId, Long> messageDeadlines;
    private final Object lock = new Object();
    private final Object futureLock = new Object();
    private Future<?> renewerFuture;
    private boolean closed;

    AckDeadlineRenewer(PubSub pubsub) {
        PubSubOptions options = (PubSubOptions)pubsub.options();
        this.pubsub = pubsub;
        this.executorFactory = options.executorFactory();
        this.executor = (ScheduledExecutorService)this.executorFactory.get();
        this.clock = options.clock();
        this.messageQueue = new LinkedList<Message>();
        this.messageDeadlines = new HashMap<MessageId, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsetAndScheduleNextRenewal() {
        Object object = this.futureLock;
        synchronized (object) {
            this.renewerFuture = null;
            this.scheduleNextRenewal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextRenewal() {
        Message nextMessage;
        Object object = this.lock;
        synchronized (object) {
            Message peek = this.messageQueue.peek();
            while (!(peek == null || this.messageDeadlines.containsKey(peek.messageId()) && this.messageDeadlines.get(peek.messageId()) <= peek.expectedDeadline())) {
                this.messageQueue.poll();
                peek = this.messageQueue.peek();
            }
            nextMessage = peek;
        }
        object = this.futureLock;
        synchronized (object) {
            if (this.renewerFuture == null && nextMessage != null) {
                long delay = nextMessage.expectedDeadline() - this.clock.millis() - 1000L;
                this.renewerFuture = this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        AckDeadlineRenewer.this.renewAckDeadlines();
                    }
                }, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void renewAckDeadlines() {
        Message message;
        LinkedListMultimap messagesToRenewNext = LinkedListMultimap.create();
        long threshold = this.clock.millis() + 3000L;
        while ((message = this.nextMessageToRenew(threshold)) != null) {
            if (message.expectedDeadline() == null) continue;
            messagesToRenewNext.put((Object)message.messageId().subscription(), (Object)message.messageId().ackId());
        }
        for (Map.Entry entry : Multimaps.asMap((ListMultimap)messagesToRenewNext).entrySet()) {
            this.pubsub.modifyAckDeadlineAsync((String)entry.getKey(), 10000, TimeUnit.MILLISECONDS, (Iterable)entry.getValue());
        }
        this.unsetAndScheduleNextRenewal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message nextMessageToRenew(long threshold) {
        Object object = this.lock;
        synchronized (object) {
            Message message = this.messageQueue.peek();
            if (message == null || message.expectedDeadline() > threshold) {
                return null;
            }
            MessageId messageId = this.messageQueue.poll().messageId();
            Long deadline = this.messageDeadlines.get(messageId);
            if (deadline == null || deadline > threshold) {
                return new Message(messageId, null);
            }
            this.add(messageId.subscription(), messageId.ackId());
            return new Message(messageId, deadline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(String subscription, String ackId) {
        Object object = this.lock;
        synchronized (object) {
            long deadline = this.clock.millis() + 10000L - 1000L;
            Message message = new Message(new MessageId(subscription, ackId), deadline);
            this.messageQueue.add(message);
            this.messageDeadlines.put(message.messageId(), deadline);
        }
        this.scheduleNextRenewal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(String subscription, Iterable<String> ackIds) {
        Object object = this.lock;
        synchronized (object) {
            long deadline = this.clock.millis() + 10000L - 1000L;
            for (String ackId : ackIds) {
                Message message = new Message(new MessageId(subscription, ackId), deadline);
                this.messageQueue.add(message);
                this.messageDeadlines.put(message.messageId(), deadline);
            }
        }
        this.scheduleNextRenewal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String subscription, String ackId) {
        Object object = this.lock;
        synchronized (object) {
            this.messageDeadlines.remove(new MessageId(subscription, ackId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Object object = this.lock;
        synchronized (object) {
            this.messageDeadlines.clear();
            this.messageQueue.clear();
        }
        object = this.futureLock;
        synchronized (object) {
            if (this.renewerFuture != null) {
                this.renewerFuture.cancel(true);
            }
        }
        this.executorFactory.release((ExecutorService)this.executor);
    }

    private static final class Message {
        private final MessageId messageId;
        private final Long deadline;

        Message(MessageId messageId, Long deadline) {
            this.messageId = messageId;
            this.deadline = deadline;
        }

        MessageId messageId() {
            return this.messageId;
        }

        Long expectedDeadline() {
            return this.deadline;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Message)) {
                return false;
            }
            Message other = (Message)obj;
            return Objects.equals(other.messageId, this.messageId) && Objects.equals(other.deadline, this.deadline);
        }

        public int hashCode() {
            return Objects.hash(this.messageId, this.deadline);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("messageId", (Object)this.messageId).add("expectedDeadline", (Object)this.deadline).toString();
        }
    }

    private static class MessageId {
        private final String subscription;
        private final String ackId;

        MessageId(String subscription, String ackId) {
            this.subscription = subscription;
            this.ackId = ackId;
        }

        String subscription() {
            return this.subscription;
        }

        String ackId() {
            return this.ackId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MessageId)) {
                return false;
            }
            MessageId other = (MessageId)obj;
            return Objects.equals(other.subscription, this.subscription) && Objects.equals(other.ackId, this.ackId);
        }

        public int hashCode() {
            return Objects.hash(this.subscription, this.ackId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("subscription", (Object)this.subscription).add("ackId", (Object)this.ackId).toString();
        }
    }
}

