/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.cloud.pubsub.v1.SubscriberStats;

final class AutoValue_SubscriberStats
extends SubscriberStats {
    private final long receivedMessages;
    private final long ackedMessages;
    private final long totalReceivedMessages;
    private final long totalAckedMessages;
    private final SubscriberStats.Stats endToEndLatency;
    private final SubscriberStats.Stats ackLatency;
    private final long numberOfAutoExtendedAckDeadlines;

    private AutoValue_SubscriberStats(long receivedMessages, long ackedMessages, long totalReceivedMessages, long totalAckedMessages, SubscriberStats.Stats endToEndLatency, SubscriberStats.Stats ackLatency, long numberOfAutoExtendedAckDeadlines) {
        this.receivedMessages = receivedMessages;
        this.ackedMessages = ackedMessages;
        this.totalReceivedMessages = totalReceivedMessages;
        this.totalAckedMessages = totalAckedMessages;
        if (endToEndLatency == null) {
            throw new NullPointerException("Null endToEndLatency");
        }
        this.endToEndLatency = endToEndLatency;
        if (ackLatency == null) {
            throw new NullPointerException("Null ackLatency");
        }
        this.ackLatency = ackLatency;
        this.numberOfAutoExtendedAckDeadlines = numberOfAutoExtendedAckDeadlines;
    }

    @Override
    public long getReceivedMessages() {
        return this.receivedMessages;
    }

    @Override
    public long getAckedMessages() {
        return this.ackedMessages;
    }

    @Override
    public long getTotalReceivedMessages() {
        return this.totalReceivedMessages;
    }

    @Override
    public long getTotalAckedMessages() {
        return this.totalAckedMessages;
    }

    @Override
    public SubscriberStats.Stats getEndToEndLatency() {
        return this.endToEndLatency;
    }

    @Override
    public SubscriberStats.Stats getAckLatency() {
        return this.ackLatency;
    }

    @Override
    public long getNumberOfAutoExtendedAckDeadlines() {
        return this.numberOfAutoExtendedAckDeadlines;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf("SubscriberStats{receivedMessages="));
        long l = this.receivedMessages;
        long l2 = this.ackedMessages;
        long l3 = this.totalReceivedMessages;
        long l4 = this.totalAckedMessages;
        String string2 = String.valueOf(String.valueOf(this.endToEndLatency));
        String string3 = String.valueOf(String.valueOf(this.ackLatency));
        long l5 = this.numberOfAutoExtendedAckDeadlines;
        return new StringBuilder(228 + string.length() + string2.length() + string3.length()).append(string).append(l).append(", ").append("ackedMessages=").append(l2).append(", ").append("totalReceivedMessages=").append(l3).append(", ").append("totalAckedMessages=").append(l4).append(", ").append("endToEndLatency=").append(string2).append(", ").append("ackLatency=").append(string3).append(", ").append("numberOfAutoExtendedAckDeadlines=").append(l5).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriberStats) {
            SubscriberStats that = (SubscriberStats)o;
            return this.receivedMessages == that.getReceivedMessages() && this.ackedMessages == that.getAckedMessages() && this.totalReceivedMessages == that.getTotalReceivedMessages() && this.totalAckedMessages == that.getTotalAckedMessages() && this.endToEndLatency.equals(that.getEndToEndLatency()) && this.ackLatency.equals(that.getAckLatency()) && this.numberOfAutoExtendedAckDeadlines == that.getNumberOfAutoExtendedAckDeadlines();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h = (int)((long)h ^ (this.receivedMessages >>> 32 ^ this.receivedMessages));
        h *= 1000003;
        h = (int)((long)h ^ (this.ackedMessages >>> 32 ^ this.ackedMessages));
        h *= 1000003;
        h = (int)((long)h ^ (this.totalReceivedMessages >>> 32 ^ this.totalReceivedMessages));
        h *= 1000003;
        h = (int)((long)h ^ (this.totalAckedMessages >>> 32 ^ this.totalAckedMessages));
        h *= 1000003;
        h ^= this.endToEndLatency.hashCode();
        h *= 1000003;
        h ^= this.ackLatency.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.numberOfAutoExtendedAckDeadlines >>> 32 ^ this.numberOfAutoExtendedAckDeadlines));
        return h;
    }

    static final class Builder
    extends SubscriberStats.Builder {
        private Long receivedMessages;
        private Long ackedMessages;
        private Long totalReceivedMessages;
        private Long totalAckedMessages;
        private SubscriberStats.Stats endToEndLatency;
        private SubscriberStats.Stats ackLatency;
        private Long numberOfAutoExtendedAckDeadlines;

        Builder() {
        }

        Builder(SubscriberStats source) {
            this.receivedMessages = source.getReceivedMessages();
            this.ackedMessages = source.getAckedMessages();
            this.totalReceivedMessages = source.getTotalReceivedMessages();
            this.totalAckedMessages = source.getTotalAckedMessages();
            this.endToEndLatency = source.getEndToEndLatency();
            this.ackLatency = source.getAckLatency();
            this.numberOfAutoExtendedAckDeadlines = source.getNumberOfAutoExtendedAckDeadlines();
        }

        @Override
        public SubscriberStats.Builder setReceivedMessages(long receivedMessages) {
            this.receivedMessages = receivedMessages;
            return this;
        }

        @Override
        public SubscriberStats.Builder setAckedMessages(long ackedMessages) {
            this.ackedMessages = ackedMessages;
            return this;
        }

        @Override
        public SubscriberStats.Builder setTotalReceivedMessages(long totalReceivedMessages) {
            this.totalReceivedMessages = totalReceivedMessages;
            return this;
        }

        @Override
        public SubscriberStats.Builder setTotalAckedMessages(long totalAckedMessages) {
            this.totalAckedMessages = totalAckedMessages;
            return this;
        }

        @Override
        public SubscriberStats.Builder setEndToEndLatency(SubscriberStats.Stats endToEndLatency) {
            this.endToEndLatency = endToEndLatency;
            return this;
        }

        @Override
        public SubscriberStats.Builder setAckLatency(SubscriberStats.Stats ackLatency) {
            this.ackLatency = ackLatency;
            return this;
        }

        @Override
        public SubscriberStats.Builder setNumberOfAutoExtendedAckDeadlines(long numberOfAutoExtendedAckDeadlines) {
            this.numberOfAutoExtendedAckDeadlines = numberOfAutoExtendedAckDeadlines;
            return this;
        }

        @Override
        public SubscriberStats build() {
            String missing = "";
            if (this.receivedMessages == null) {
                missing = String.valueOf(missing).concat(" receivedMessages");
            }
            if (this.ackedMessages == null) {
                missing = String.valueOf(missing).concat(" ackedMessages");
            }
            if (this.totalReceivedMessages == null) {
                missing = String.valueOf(missing).concat(" totalReceivedMessages");
            }
            if (this.totalAckedMessages == null) {
                missing = String.valueOf(missing).concat(" totalAckedMessages");
            }
            if (this.endToEndLatency == null) {
                missing = String.valueOf(missing).concat(" endToEndLatency");
            }
            if (this.ackLatency == null) {
                missing = String.valueOf(missing).concat(" ackLatency");
            }
            if (this.numberOfAutoExtendedAckDeadlines == null) {
                missing = String.valueOf(missing).concat(" numberOfAutoExtendedAckDeadlines");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_SubscriberStats(this.receivedMessages, this.ackedMessages, this.totalReceivedMessages, this.totalAckedMessages, this.endToEndLatency, this.ackLatency, this.numberOfAutoExtendedAckDeadlines);
        }
    }
}

