/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.spi.v1;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.RequestBuilder;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FlowControlSettings;
import com.google.api.gax.core.FlowController;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.BatchedRequestIssuer;
import com.google.api.gax.grpc.BatchingCallSettings;
import com.google.api.gax.grpc.BatchingDescriptor;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PageContext;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.pubsub.spi.v1.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.Topic;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.joda.time.Duration;

public class TopicAdminSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/pubsub").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/pubsub/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private static final MethodDescriptor<Topic, Topic> METHOD_CREATE_TOPIC;
    private static final MethodDescriptor<PublishRequest, PublishResponse> METHOD_PUBLISH;
    private static final MethodDescriptor<GetTopicRequest, Topic> METHOD_GET_TOPIC;
    private static final MethodDescriptor<ListTopicsRequest, ListTopicsResponse> METHOD_LIST_TOPICS;
    private static final MethodDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> METHOD_LIST_TOPIC_SUBSCRIPTIONS;
    private static final MethodDescriptor<DeleteTopicRequest, Empty> METHOD_DELETE_TOPIC;
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> METHOD_SET_IAM_POLICY;
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> METHOD_GET_IAM_POLICY;
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> METHOD_TEST_IAM_PERMISSIONS;
    private final SimpleCallSettings<Topic, Topic> createTopicSettings;
    private final BatchingCallSettings<PublishRequest, PublishResponse> publishSettings;
    private final SimpleCallSettings<GetTopicRequest, Topic> getTopicSettings;
    private final PagedCallSettings<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse> listTopicsSettings;
    private final PagedCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings;
    private final SimpleCallSettings<DeleteTopicRequest, Empty> deleteTopicSettings;
    private final SimpleCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final SimpleCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final SimpleCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListTopicsRequest, ListTopicsResponse, Topic> LIST_TOPICS_PAGE_STR_DESC;
    private static final PagedListDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse> LIST_TOPICS_PAGE_STR_FACT;
    private static final PagedListResponseFactory<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_FACT;
    private static final BatchingDescriptor<PublishRequest, PublishResponse> PUBLISH_BATCHING_DESC;

    public SimpleCallSettings<Topic, Topic> createTopicSettings() {
        return this.createTopicSettings;
    }

    public BatchingCallSettings<PublishRequest, PublishResponse> publishSettings() {
        return this.publishSettings;
    }

    public SimpleCallSettings<GetTopicRequest, Topic> getTopicSettings() {
        return this.getTopicSettings;
    }

    public PagedCallSettings<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse> listTopicsSettings() {
        return this.listTopicsSettings;
    }

    public PagedCallSettings<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings() {
        return this.listTopicSubscriptionsSettings;
    }

    public SimpleCallSettings<DeleteTopicRequest, Empty> deleteTopicSettings() {
        return this.deleteTopicSettings;
    }

    public SimpleCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public SimpleCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public SimpleCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "pubsub.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(TopicAdminSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, TopicAdminSettings.getGapicVersion()).setCredentialsProvider((CredentialsProvider)TopicAdminSettings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(TopicAdminSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TopicAdminSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.createTopicSettings = settingsBuilder.createTopicSettings().build();
        this.publishSettings = settingsBuilder.publishSettings().build();
        this.getTopicSettings = settingsBuilder.getTopicSettings().build();
        this.listTopicsSettings = settingsBuilder.listTopicsSettings().build();
        this.listTopicSubscriptionsSettings = settingsBuilder.listTopicSubscriptionsSettings().build();
        this.deleteTopicSettings = settingsBuilder.deleteTopicSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    static {
        METHOD_CREATE_TOPIC = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Publisher/CreateTopic", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Topic.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Topic.getDefaultInstance()));
        METHOD_PUBLISH = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Publisher/Publish", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)PublishRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)PublishResponse.getDefaultInstance()));
        METHOD_GET_TOPIC = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Publisher/GetTopic", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)GetTopicRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Topic.getDefaultInstance()));
        METHOD_LIST_TOPICS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Publisher/ListTopics", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListTopicsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListTopicsResponse.getDefaultInstance()));
        METHOD_LIST_TOPIC_SUBSCRIPTIONS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Publisher/ListTopicSubscriptions", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListTopicSubscriptionsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListTopicSubscriptionsResponse.getDefaultInstance()));
        METHOD_DELETE_TOPIC = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.pubsub.v1.Publisher/DeleteTopic", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)DeleteTopicRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
        METHOD_SET_IAM_POLICY = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.iam.v1.IAMPolicy/SetIamPolicy", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Policy.getDefaultInstance()));
        METHOD_GET_IAM_POLICY = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.iam.v1.IAMPolicy/GetIamPolicy", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Policy.getDefaultInstance()));
        METHOD_TEST_IAM_PERMISSIONS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.iam.v1.IAMPolicy/TestIamPermissions", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance()));
        LIST_TOPICS_PAGE_STR_DESC = new PagedListDescriptor<ListTopicsRequest, ListTopicsResponse, Topic>(){

            public String emptyToken() {
                return TopicAdminSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListTopicsRequest injectToken(ListTopicsRequest payload, String token) {
                return ListTopicsRequest.newBuilder((ListTopicsRequest)payload).setPageToken(token).build();
            }

            public ListTopicsRequest injectPageSize(ListTopicsRequest payload, int pageSize) {
                return ListTopicsRequest.newBuilder((ListTopicsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListTopicsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListTopicsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<Topic> extractResources(ListTopicsResponse payload) {
                return payload.getTopicsList();
            }
        };
        LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String>(){

            public String emptyToken() {
                return TopicAdminSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListTopicSubscriptionsRequest injectToken(ListTopicSubscriptionsRequest payload, String token) {
                return ListTopicSubscriptionsRequest.newBuilder((ListTopicSubscriptionsRequest)payload).setPageToken(token).build();
            }

            public ListTopicSubscriptionsRequest injectPageSize(ListTopicSubscriptionsRequest payload, int pageSize) {
                return ListTopicSubscriptionsRequest.newBuilder((ListTopicSubscriptionsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListTopicSubscriptionsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListTopicSubscriptionsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<String> extractResources(ListTopicSubscriptionsResponse payload) {
                return payload.getSubscriptionsList();
            }
        };
        LIST_TOPICS_PAGE_STR_FACT = new PagedListResponseFactory<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListTopicsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTopicsRequest, ListTopicsResponse> callable, ListTopicsRequest request, CallContext context, ApiFuture<ListTopicsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TOPICS_PAGE_STR_DESC, (Object)request, (CallContext)context);
                return PagedResponseWrappers.ListTopicsPagedResponse.createAsync((PageContext<ListTopicsRequest, ListTopicsResponse, Topic>)pageContext, futureResponse);
            }
        };
        LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> callable, ListTopicSubscriptionsRequest request, CallContext context, ApiFuture<ListTopicSubscriptionsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_DESC, (Object)request, (CallContext)context);
                return PagedResponseWrappers.ListTopicSubscriptionsPagedResponse.createAsync((PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String>)pageContext, futureResponse);
            }
        };
        PUBLISH_BATCHING_DESC = new BatchingDescriptor<PublishRequest, PublishResponse>(){

            public PartitionKey getBatchPartitionKey(PublishRequest request) {
                return new PartitionKey(new Object[]{request.getTopic()});
            }

            public RequestBuilder<PublishRequest> getRequestBuilder() {
                return new RequestBuilder<PublishRequest>(){
                    private PublishRequest.Builder builder;

                    public void appendRequest(PublishRequest request) {
                        if (this.builder == null) {
                            this.builder = request.toBuilder();
                        } else {
                            this.builder.addAllMessages((Iterable)request.getMessagesList());
                        }
                    }

                    public PublishRequest build() {
                        return this.builder.build();
                    }
                };
            }

            public void splitResponse(PublishResponse batchResponse, Collection<? extends BatchedRequestIssuer<PublishResponse>> batch) {
                int batchMessageIndex = 0;
                for (BatchedRequestIssuer<PublishResponse> batchedRequestIssuer : batch) {
                    ArrayList<String> subresponseElements = new ArrayList<String>();
                    long subresponseCount = batchedRequestIssuer.getMessageCount();
                    int i = 0;
                    while ((long)i < subresponseCount) {
                        subresponseElements.add(batchResponse.getMessageIds(batchMessageIndex));
                        ++batchMessageIndex;
                        ++i;
                    }
                    PublishResponse response = PublishResponse.newBuilder().addAllMessageIds(subresponseElements).build();
                    batchedRequestIssuer.setResponse((Object)response);
                }
            }

            public void splitException(Throwable throwable, Collection<? extends BatchedRequestIssuer<PublishResponse>> batch) {
                for (BatchedRequestIssuer<PublishResponse> batchedRequestIssuer : batch) {
                    batchedRequestIssuer.setException(throwable);
                }
            }

            public long countElements(PublishRequest request) {
                return request.getMessagesCount();
            }

            public long countBytes(PublishRequest request) {
                return request.getSerializedSize();
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<Topic, Topic> createTopicSettings;
        private final BatchingCallSettings.Builder<PublishRequest, PublishResponse> publishSettings;
        private final SimpleCallSettings.Builder<GetTopicRequest, Topic> getTopicSettings;
        private final PagedCallSettings.Builder<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse> listTopicsSettings;
        private final PagedCallSettings.Builder<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings;
        private final SimpleCallSettings.Builder<DeleteTopicRequest, Empty> deleteTopicSettings;
        private final SimpleCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final SimpleCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final SimpleCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(TopicAdminSettings.defaultChannelProviderBuilder().build());
            this.createTopicSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_CREATE_TOPIC);
            this.publishSettings = BatchingCallSettings.newBuilder((MethodDescriptor)METHOD_PUBLISH, (BatchingDescriptor)PUBLISH_BATCHING_DESC).setBatchingSettingsBuilder(BatchingSettings.newBuilder());
            this.getTopicSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_GET_TOPIC);
            this.listTopicsSettings = PagedCallSettings.newBuilder((MethodDescriptor)METHOD_LIST_TOPICS, (PagedListResponseFactory)LIST_TOPICS_PAGE_STR_FACT);
            this.listTopicSubscriptionsSettings = PagedCallSettings.newBuilder((MethodDescriptor)METHOD_LIST_TOPIC_SUBSCRIPTIONS, (PagedListResponseFactory)LIST_TOPIC_SUBSCRIPTIONS_PAGE_STR_FACT);
            this.deleteTopicSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_DELETE_TOPIC);
            this.setIamPolicySettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_SET_IAM_POLICY);
            this.getIamPolicySettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_GET_IAM_POLICY);
            this.testIamPermissionsSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_TEST_IAM_PERMISSIONS);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTopicSettings, this.publishSettings, this.getTopicSettings, this.listTopicsSettings, this.listTopicSubscriptionsSettings, this.deleteTopicSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.createTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.publishSettings().getBatchingSettingsBuilder().setElementCountThreshold(Long.valueOf(10L)).setRequestByteThreshold(Long.valueOf(1024L)).setDelayThreshold(Duration.millis((long)10L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build());
            builder.publishSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"one_plus_delivery")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"messaging"));
            builder.getTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTopicsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTopicSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteTopicSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(TopicAdminSettings settings) {
            super((ClientSettings)settings);
            this.createTopicSettings = settings.createTopicSettings.toBuilder();
            this.publishSettings = settings.publishSettings.toBuilder();
            this.getTopicSettings = settings.getTopicSettings.toBuilder();
            this.listTopicsSettings = settings.listTopicsSettings.toBuilder();
            this.listTopicSubscriptionsSettings = settings.listTopicSubscriptionsSettings.toBuilder();
            this.deleteTopicSettings = settings.deleteTopicSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTopicSettings, this.publishSettings, this.getTopicSettings, this.listTopicsSettings, this.listTopicSubscriptionsSettings, this.deleteTopicSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<Topic, Topic> createTopicSettings() {
            return this.createTopicSettings;
        }

        public BatchingCallSettings.Builder<PublishRequest, PublishResponse> publishSettings() {
            return this.publishSettings;
        }

        public SimpleCallSettings.Builder<GetTopicRequest, Topic> getTopicSettings() {
            return this.getTopicSettings;
        }

        public PagedCallSettings.Builder<ListTopicsRequest, ListTopicsResponse, PagedResponseWrappers.ListTopicsPagedResponse> listTopicsSettings() {
            return this.listTopicsSettings;
        }

        public PagedCallSettings.Builder<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, PagedResponseWrappers.ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsSettings() {
            return this.listTopicSubscriptionsSettings;
        }

        public SimpleCallSettings.Builder<DeleteTopicRequest, Empty> deleteTopicSettings() {
            return this.deleteTopicSettings;
        }

        public SimpleCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public SimpleCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public SimpleCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public TopicAdminSettings build() throws IOException {
            return new TopicAdminSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"one_plus_delivery", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.CANCELLED, Status.Code.UNKNOWN, Status.Code.DEADLINE_EXCEEDED, Status.Code.RESOURCE_EXHAUSTED, Status.Code.ABORTED, Status.Code.INTERNAL, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)60000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)12000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)12000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"messaging", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

