/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.cloudprofiler.v2;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.devtools.cloudprofiler.v2.CreateOfflineProfileRequest;
import com.google.devtools.cloudprofiler.v2.CreateProfileRequest;
import com.google.devtools.cloudprofiler.v2.Profile;
import com.google.devtools.cloudprofiler.v2.ProfilerServiceSettings;
import com.google.devtools.cloudprofiler.v2.ProjectName;
import com.google.devtools.cloudprofiler.v2.UpdateProfileRequest;
import com.google.devtools.cloudprofiler.v2.stub.ProfilerServiceStub;
import com.google.devtools.cloudprofiler.v2.stub.ProfilerServiceStubSettings;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ProfilerServiceClient
implements BackgroundResource {
    private final ProfilerServiceSettings settings;
    private final ProfilerServiceStub stub;

    public static final ProfilerServiceClient create() throws IOException {
        return ProfilerServiceClient.create(ProfilerServiceSettings.newBuilder().build());
    }

    public static final ProfilerServiceClient create(ProfilerServiceSettings settings) throws IOException {
        return new ProfilerServiceClient(settings);
    }

    public static final ProfilerServiceClient create(ProfilerServiceStub stub) {
        return new ProfilerServiceClient(stub);
    }

    protected ProfilerServiceClient(ProfilerServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProfilerServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ProfilerServiceClient(ProfilerServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ProfilerServiceSettings getSettings() {
        return this.settings;
    }

    public ProfilerServiceStub getStub() {
        return this.stub;
    }

    public final Profile createProfile(CreateProfileRequest request) {
        return (Profile)this.createProfileCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProfileRequest, Profile> createProfileCallable() {
        return this.stub.createProfileCallable();
    }

    public final Profile createOfflineProfile(ProjectName parent, Profile profile) {
        CreateOfflineProfileRequest request = CreateOfflineProfileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProfile(profile).build();
        return this.createOfflineProfile(request);
    }

    public final Profile createOfflineProfile(String parent, Profile profile) {
        CreateOfflineProfileRequest request = CreateOfflineProfileRequest.newBuilder().setParent(parent).setProfile(profile).build();
        return this.createOfflineProfile(request);
    }

    public final Profile createOfflineProfile(CreateOfflineProfileRequest request) {
        return (Profile)this.createOfflineProfileCallable().call((Object)request);
    }

    public final UnaryCallable<CreateOfflineProfileRequest, Profile> createOfflineProfileCallable() {
        return this.stub.createOfflineProfileCallable();
    }

    public final Profile updateProfile(Profile profile, FieldMask updateMask) {
        UpdateProfileRequest request = UpdateProfileRequest.newBuilder().setProfile(profile).setUpdateMask(updateMask).build();
        return this.updateProfile(request);
    }

    public final Profile updateProfile(UpdateProfileRequest request) {
        return (Profile)this.updateProfileCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProfileRequest, Profile> updateProfileCallable() {
        return this.stub.updateProfileCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

