/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.privilegedaccessmanager.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.privilegedaccessmanager.v1.ApproveGrantRequest;
import com.google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusRequest;
import com.google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse;
import com.google.cloud.privilegedaccessmanager.v1.CreateEntitlementRequest;
import com.google.cloud.privilegedaccessmanager.v1.CreateGrantRequest;
import com.google.cloud.privilegedaccessmanager.v1.DeleteEntitlementRequest;
import com.google.cloud.privilegedaccessmanager.v1.DenyGrantRequest;
import com.google.cloud.privilegedaccessmanager.v1.Entitlement;
import com.google.cloud.privilegedaccessmanager.v1.GetEntitlementRequest;
import com.google.cloud.privilegedaccessmanager.v1.GetGrantRequest;
import com.google.cloud.privilegedaccessmanager.v1.Grant;
import com.google.cloud.privilegedaccessmanager.v1.ListEntitlementsRequest;
import com.google.cloud.privilegedaccessmanager.v1.ListEntitlementsResponse;
import com.google.cloud.privilegedaccessmanager.v1.ListGrantsRequest;
import com.google.cloud.privilegedaccessmanager.v1.ListGrantsResponse;
import com.google.cloud.privilegedaccessmanager.v1.OperationMetadata;
import com.google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManagerClient;
import com.google.cloud.privilegedaccessmanager.v1.RevokeGrantRequest;
import com.google.cloud.privilegedaccessmanager.v1.SearchEntitlementsRequest;
import com.google.cloud.privilegedaccessmanager.v1.SearchEntitlementsResponse;
import com.google.cloud.privilegedaccessmanager.v1.SearchGrantsRequest;
import com.google.cloud.privilegedaccessmanager.v1.SearchGrantsResponse;
import com.google.cloud.privilegedaccessmanager.v1.UpdateEntitlementRequest;
import com.google.cloud.privilegedaccessmanager.v1.stub.GrpcPrivilegedAccessManagerStub;
import com.google.cloud.privilegedaccessmanager.v1.stub.HttpJsonPrivilegedAccessManagerStub;
import com.google.cloud.privilegedaccessmanager.v1.stub.PrivilegedAccessManagerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class PrivilegedAccessManagerStubSettings
extends StubSettings<PrivilegedAccessManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CheckOnboardingStatusRequest, CheckOnboardingStatusResponse> checkOnboardingStatusSettings;
    private final PagedCallSettings<ListEntitlementsRequest, ListEntitlementsResponse, PrivilegedAccessManagerClient.ListEntitlementsPagedResponse> listEntitlementsSettings;
    private final PagedCallSettings<SearchEntitlementsRequest, SearchEntitlementsResponse, PrivilegedAccessManagerClient.SearchEntitlementsPagedResponse> searchEntitlementsSettings;
    private final UnaryCallSettings<GetEntitlementRequest, Entitlement> getEntitlementSettings;
    private final UnaryCallSettings<CreateEntitlementRequest, Operation> createEntitlementSettings;
    private final OperationCallSettings<CreateEntitlementRequest, Entitlement, OperationMetadata> createEntitlementOperationSettings;
    private final UnaryCallSettings<DeleteEntitlementRequest, Operation> deleteEntitlementSettings;
    private final OperationCallSettings<DeleteEntitlementRequest, Entitlement, OperationMetadata> deleteEntitlementOperationSettings;
    private final UnaryCallSettings<UpdateEntitlementRequest, Operation> updateEntitlementSettings;
    private final OperationCallSettings<UpdateEntitlementRequest, Entitlement, OperationMetadata> updateEntitlementOperationSettings;
    private final PagedCallSettings<ListGrantsRequest, ListGrantsResponse, PrivilegedAccessManagerClient.ListGrantsPagedResponse> listGrantsSettings;
    private final PagedCallSettings<SearchGrantsRequest, SearchGrantsResponse, PrivilegedAccessManagerClient.SearchGrantsPagedResponse> searchGrantsSettings;
    private final UnaryCallSettings<GetGrantRequest, Grant> getGrantSettings;
    private final UnaryCallSettings<CreateGrantRequest, Grant> createGrantSettings;
    private final UnaryCallSettings<ApproveGrantRequest, Grant> approveGrantSettings;
    private final UnaryCallSettings<DenyGrantRequest, Grant> denyGrantSettings;
    private final UnaryCallSettings<RevokeGrantRequest, Operation> revokeGrantSettings;
    private final OperationCallSettings<RevokeGrantRequest, Grant, OperationMetadata> revokeGrantOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, PrivilegedAccessManagerClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> LIST_ENTITLEMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement>(){

        public String emptyToken() {
            return "";
        }

        public ListEntitlementsRequest injectToken(ListEntitlementsRequest payload, String token) {
            return ListEntitlementsRequest.newBuilder((ListEntitlementsRequest)payload).setPageToken(token).build();
        }

        public ListEntitlementsRequest injectPageSize(ListEntitlementsRequest payload, int pageSize) {
            return ListEntitlementsRequest.newBuilder((ListEntitlementsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntitlementsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntitlementsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Entitlement> extractResources(ListEntitlementsResponse payload) {
            return payload.getEntitlementsList() == null ? ImmutableList.of() : payload.getEntitlementsList();
        }
    };
    private static final PagedListDescriptor<SearchEntitlementsRequest, SearchEntitlementsResponse, Entitlement> SEARCH_ENTITLEMENTS_PAGE_STR_DESC = new PagedListDescriptor<SearchEntitlementsRequest, SearchEntitlementsResponse, Entitlement>(){

        public String emptyToken() {
            return "";
        }

        public SearchEntitlementsRequest injectToken(SearchEntitlementsRequest payload, String token) {
            return SearchEntitlementsRequest.newBuilder((SearchEntitlementsRequest)payload).setPageToken(token).build();
        }

        public SearchEntitlementsRequest injectPageSize(SearchEntitlementsRequest payload, int pageSize) {
            return SearchEntitlementsRequest.newBuilder((SearchEntitlementsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchEntitlementsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchEntitlementsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Entitlement> extractResources(SearchEntitlementsResponse payload) {
            return payload.getEntitlementsList() == null ? ImmutableList.of() : payload.getEntitlementsList();
        }
    };
    private static final PagedListDescriptor<ListGrantsRequest, ListGrantsResponse, Grant> LIST_GRANTS_PAGE_STR_DESC = new PagedListDescriptor<ListGrantsRequest, ListGrantsResponse, Grant>(){

        public String emptyToken() {
            return "";
        }

        public ListGrantsRequest injectToken(ListGrantsRequest payload, String token) {
            return ListGrantsRequest.newBuilder((ListGrantsRequest)payload).setPageToken(token).build();
        }

        public ListGrantsRequest injectPageSize(ListGrantsRequest payload, int pageSize) {
            return ListGrantsRequest.newBuilder((ListGrantsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGrantsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGrantsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Grant> extractResources(ListGrantsResponse payload) {
            return payload.getGrantsList() == null ? ImmutableList.of() : payload.getGrantsList();
        }
    };
    private static final PagedListDescriptor<SearchGrantsRequest, SearchGrantsResponse, Grant> SEARCH_GRANTS_PAGE_STR_DESC = new PagedListDescriptor<SearchGrantsRequest, SearchGrantsResponse, Grant>(){

        public String emptyToken() {
            return "";
        }

        public SearchGrantsRequest injectToken(SearchGrantsRequest payload, String token) {
            return SearchGrantsRequest.newBuilder((SearchGrantsRequest)payload).setPageToken(token).build();
        }

        public SearchGrantsRequest injectPageSize(SearchGrantsRequest payload, int pageSize) {
            return SearchGrantsRequest.newBuilder((SearchGrantsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchGrantsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchGrantsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Grant> extractResources(SearchGrantsResponse payload) {
            return payload.getGrantsList() == null ? ImmutableList.of() : payload.getGrantsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListEntitlementsRequest, ListEntitlementsResponse, PrivilegedAccessManagerClient.ListEntitlementsPagedResponse> LIST_ENTITLEMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEntitlementsRequest, ListEntitlementsResponse, PrivilegedAccessManagerClient.ListEntitlementsPagedResponse>(){

        public ApiFuture<PrivilegedAccessManagerClient.ListEntitlementsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntitlementsRequest, ListEntitlementsResponse> callable, ListEntitlementsRequest request, ApiCallContext context, ApiFuture<ListEntitlementsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTITLEMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PrivilegedAccessManagerClient.ListEntitlementsPagedResponse.createAsync((PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchEntitlementsRequest, SearchEntitlementsResponse, PrivilegedAccessManagerClient.SearchEntitlementsPagedResponse> SEARCH_ENTITLEMENTS_PAGE_STR_FACT = new PagedListResponseFactory<SearchEntitlementsRequest, SearchEntitlementsResponse, PrivilegedAccessManagerClient.SearchEntitlementsPagedResponse>(){

        public ApiFuture<PrivilegedAccessManagerClient.SearchEntitlementsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchEntitlementsRequest, SearchEntitlementsResponse> callable, SearchEntitlementsRequest request, ApiCallContext context, ApiFuture<SearchEntitlementsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_ENTITLEMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PrivilegedAccessManagerClient.SearchEntitlementsPagedResponse.createAsync((PageContext<SearchEntitlementsRequest, SearchEntitlementsResponse, Entitlement>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGrantsRequest, ListGrantsResponse, PrivilegedAccessManagerClient.ListGrantsPagedResponse> LIST_GRANTS_PAGE_STR_FACT = new PagedListResponseFactory<ListGrantsRequest, ListGrantsResponse, PrivilegedAccessManagerClient.ListGrantsPagedResponse>(){

        public ApiFuture<PrivilegedAccessManagerClient.ListGrantsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGrantsRequest, ListGrantsResponse> callable, ListGrantsRequest request, ApiCallContext context, ApiFuture<ListGrantsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GRANTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PrivilegedAccessManagerClient.ListGrantsPagedResponse.createAsync((PageContext<ListGrantsRequest, ListGrantsResponse, Grant>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchGrantsRequest, SearchGrantsResponse, PrivilegedAccessManagerClient.SearchGrantsPagedResponse> SEARCH_GRANTS_PAGE_STR_FACT = new PagedListResponseFactory<SearchGrantsRequest, SearchGrantsResponse, PrivilegedAccessManagerClient.SearchGrantsPagedResponse>(){

        public ApiFuture<PrivilegedAccessManagerClient.SearchGrantsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchGrantsRequest, SearchGrantsResponse> callable, SearchGrantsRequest request, ApiCallContext context, ApiFuture<SearchGrantsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_GRANTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PrivilegedAccessManagerClient.SearchGrantsPagedResponse.createAsync((PageContext<SearchGrantsRequest, SearchGrantsResponse, Grant>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, PrivilegedAccessManagerClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, PrivilegedAccessManagerClient.ListLocationsPagedResponse>(){

        public ApiFuture<PrivilegedAccessManagerClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PrivilegedAccessManagerClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CheckOnboardingStatusRequest, CheckOnboardingStatusResponse> checkOnboardingStatusSettings() {
        return this.checkOnboardingStatusSettings;
    }

    public PagedCallSettings<ListEntitlementsRequest, ListEntitlementsResponse, PrivilegedAccessManagerClient.ListEntitlementsPagedResponse> listEntitlementsSettings() {
        return this.listEntitlementsSettings;
    }

    public PagedCallSettings<SearchEntitlementsRequest, SearchEntitlementsResponse, PrivilegedAccessManagerClient.SearchEntitlementsPagedResponse> searchEntitlementsSettings() {
        return this.searchEntitlementsSettings;
    }

    public UnaryCallSettings<GetEntitlementRequest, Entitlement> getEntitlementSettings() {
        return this.getEntitlementSettings;
    }

    public UnaryCallSettings<CreateEntitlementRequest, Operation> createEntitlementSettings() {
        return this.createEntitlementSettings;
    }

    public OperationCallSettings<CreateEntitlementRequest, Entitlement, OperationMetadata> createEntitlementOperationSettings() {
        return this.createEntitlementOperationSettings;
    }

    public UnaryCallSettings<DeleteEntitlementRequest, Operation> deleteEntitlementSettings() {
        return this.deleteEntitlementSettings;
    }

    public OperationCallSettings<DeleteEntitlementRequest, Entitlement, OperationMetadata> deleteEntitlementOperationSettings() {
        return this.deleteEntitlementOperationSettings;
    }

    public UnaryCallSettings<UpdateEntitlementRequest, Operation> updateEntitlementSettings() {
        return this.updateEntitlementSettings;
    }

    public OperationCallSettings<UpdateEntitlementRequest, Entitlement, OperationMetadata> updateEntitlementOperationSettings() {
        return this.updateEntitlementOperationSettings;
    }

    public PagedCallSettings<ListGrantsRequest, ListGrantsResponse, PrivilegedAccessManagerClient.ListGrantsPagedResponse> listGrantsSettings() {
        return this.listGrantsSettings;
    }

    public PagedCallSettings<SearchGrantsRequest, SearchGrantsResponse, PrivilegedAccessManagerClient.SearchGrantsPagedResponse> searchGrantsSettings() {
        return this.searchGrantsSettings;
    }

    public UnaryCallSettings<GetGrantRequest, Grant> getGrantSettings() {
        return this.getGrantSettings;
    }

    public UnaryCallSettings<CreateGrantRequest, Grant> createGrantSettings() {
        return this.createGrantSettings;
    }

    public UnaryCallSettings<ApproveGrantRequest, Grant> approveGrantSettings() {
        return this.approveGrantSettings;
    }

    public UnaryCallSettings<DenyGrantRequest, Grant> denyGrantSettings() {
        return this.denyGrantSettings;
    }

    public UnaryCallSettings<RevokeGrantRequest, Operation> revokeGrantSettings() {
        return this.revokeGrantSettings;
    }

    public OperationCallSettings<RevokeGrantRequest, Grant, OperationMetadata> revokeGrantOperationSettings() {
        return this.revokeGrantOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, PrivilegedAccessManagerClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public PrivilegedAccessManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPrivilegedAccessManagerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPrivilegedAccessManagerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "privilegedaccessmanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "privilegedaccessmanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "privilegedaccessmanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PrivilegedAccessManagerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PrivilegedAccessManagerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PrivilegedAccessManagerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PrivilegedAccessManagerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PrivilegedAccessManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.checkOnboardingStatusSettings = settingsBuilder.checkOnboardingStatusSettings().build();
        this.listEntitlementsSettings = settingsBuilder.listEntitlementsSettings().build();
        this.searchEntitlementsSettings = settingsBuilder.searchEntitlementsSettings().build();
        this.getEntitlementSettings = settingsBuilder.getEntitlementSettings().build();
        this.createEntitlementSettings = settingsBuilder.createEntitlementSettings().build();
        this.createEntitlementOperationSettings = settingsBuilder.createEntitlementOperationSettings().build();
        this.deleteEntitlementSettings = settingsBuilder.deleteEntitlementSettings().build();
        this.deleteEntitlementOperationSettings = settingsBuilder.deleteEntitlementOperationSettings().build();
        this.updateEntitlementSettings = settingsBuilder.updateEntitlementSettings().build();
        this.updateEntitlementOperationSettings = settingsBuilder.updateEntitlementOperationSettings().build();
        this.listGrantsSettings = settingsBuilder.listGrantsSettings().build();
        this.searchGrantsSettings = settingsBuilder.searchGrantsSettings().build();
        this.getGrantSettings = settingsBuilder.getGrantSettings().build();
        this.createGrantSettings = settingsBuilder.createGrantSettings().build();
        this.approveGrantSettings = settingsBuilder.approveGrantSettings().build();
        this.denyGrantSettings = settingsBuilder.denyGrantSettings().build();
        this.revokeGrantSettings = settingsBuilder.revokeGrantSettings().build();
        this.revokeGrantOperationSettings = settingsBuilder.revokeGrantOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PrivilegedAccessManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CheckOnboardingStatusRequest, CheckOnboardingStatusResponse> checkOnboardingStatusSettings;
        private final PagedCallSettings.Builder<ListEntitlementsRequest, ListEntitlementsResponse, PrivilegedAccessManagerClient.ListEntitlementsPagedResponse> listEntitlementsSettings;
        private final PagedCallSettings.Builder<SearchEntitlementsRequest, SearchEntitlementsResponse, PrivilegedAccessManagerClient.SearchEntitlementsPagedResponse> searchEntitlementsSettings;
        private final UnaryCallSettings.Builder<GetEntitlementRequest, Entitlement> getEntitlementSettings;
        private final UnaryCallSettings.Builder<CreateEntitlementRequest, Operation> createEntitlementSettings;
        private final OperationCallSettings.Builder<CreateEntitlementRequest, Entitlement, OperationMetadata> createEntitlementOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEntitlementRequest, Operation> deleteEntitlementSettings;
        private final OperationCallSettings.Builder<DeleteEntitlementRequest, Entitlement, OperationMetadata> deleteEntitlementOperationSettings;
        private final UnaryCallSettings.Builder<UpdateEntitlementRequest, Operation> updateEntitlementSettings;
        private final OperationCallSettings.Builder<UpdateEntitlementRequest, Entitlement, OperationMetadata> updateEntitlementOperationSettings;
        private final PagedCallSettings.Builder<ListGrantsRequest, ListGrantsResponse, PrivilegedAccessManagerClient.ListGrantsPagedResponse> listGrantsSettings;
        private final PagedCallSettings.Builder<SearchGrantsRequest, SearchGrantsResponse, PrivilegedAccessManagerClient.SearchGrantsPagedResponse> searchGrantsSettings;
        private final UnaryCallSettings.Builder<GetGrantRequest, Grant> getGrantSettings;
        private final UnaryCallSettings.Builder<CreateGrantRequest, Grant> createGrantSettings;
        private final UnaryCallSettings.Builder<ApproveGrantRequest, Grant> approveGrantSettings;
        private final UnaryCallSettings.Builder<DenyGrantRequest, Grant> denyGrantSettings;
        private final UnaryCallSettings.Builder<RevokeGrantRequest, Operation> revokeGrantSettings;
        private final OperationCallSettings.Builder<RevokeGrantRequest, Grant, OperationMetadata> revokeGrantOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, PrivilegedAccessManagerClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.checkOnboardingStatusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEntitlementsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTITLEMENTS_PAGE_STR_FACT);
            this.searchEntitlementsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_ENTITLEMENTS_PAGE_STR_FACT);
            this.getEntitlementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntitlementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntitlementOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEntitlementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEntitlementOperationSettings = OperationCallSettings.newBuilder();
            this.updateEntitlementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEntitlementOperationSettings = OperationCallSettings.newBuilder();
            this.listGrantsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GRANTS_PAGE_STR_FACT);
            this.searchGrantsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_GRANTS_PAGE_STR_FACT);
            this.getGrantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGrantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.approveGrantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.denyGrantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.revokeGrantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.revokeGrantOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.checkOnboardingStatusSettings, this.listEntitlementsSettings, this.searchEntitlementsSettings, this.getEntitlementSettings, this.createEntitlementSettings, this.deleteEntitlementSettings, this.updateEntitlementSettings, this.listGrantsSettings, this.searchGrantsSettings, this.getGrantSettings, this.createGrantSettings, this.approveGrantSettings, (Object[])new UnaryCallSettings.Builder[]{this.denyGrantSettings, this.revokeGrantSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(PrivilegedAccessManagerStubSettings settings) {
            super((StubSettings)settings);
            this.checkOnboardingStatusSettings = settings.checkOnboardingStatusSettings.toBuilder();
            this.listEntitlementsSettings = settings.listEntitlementsSettings.toBuilder();
            this.searchEntitlementsSettings = settings.searchEntitlementsSettings.toBuilder();
            this.getEntitlementSettings = settings.getEntitlementSettings.toBuilder();
            this.createEntitlementSettings = settings.createEntitlementSettings.toBuilder();
            this.createEntitlementOperationSettings = settings.createEntitlementOperationSettings.toBuilder();
            this.deleteEntitlementSettings = settings.deleteEntitlementSettings.toBuilder();
            this.deleteEntitlementOperationSettings = settings.deleteEntitlementOperationSettings.toBuilder();
            this.updateEntitlementSettings = settings.updateEntitlementSettings.toBuilder();
            this.updateEntitlementOperationSettings = settings.updateEntitlementOperationSettings.toBuilder();
            this.listGrantsSettings = settings.listGrantsSettings.toBuilder();
            this.searchGrantsSettings = settings.searchGrantsSettings.toBuilder();
            this.getGrantSettings = settings.getGrantSettings.toBuilder();
            this.createGrantSettings = settings.createGrantSettings.toBuilder();
            this.approveGrantSettings = settings.approveGrantSettings.toBuilder();
            this.denyGrantSettings = settings.denyGrantSettings.toBuilder();
            this.revokeGrantSettings = settings.revokeGrantSettings.toBuilder();
            this.revokeGrantOperationSettings = settings.revokeGrantOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.checkOnboardingStatusSettings, this.listEntitlementsSettings, this.searchEntitlementsSettings, this.getEntitlementSettings, this.createEntitlementSettings, this.deleteEntitlementSettings, this.updateEntitlementSettings, this.listGrantsSettings, this.searchGrantsSettings, this.getGrantSettings, this.createGrantSettings, this.approveGrantSettings, (Object[])new UnaryCallSettings.Builder[]{this.denyGrantSettings, this.revokeGrantSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PrivilegedAccessManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PrivilegedAccessManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PrivilegedAccessManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PrivilegedAccessManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PrivilegedAccessManagerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PrivilegedAccessManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PrivilegedAccessManagerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PrivilegedAccessManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.checkOnboardingStatusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listEntitlementsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.searchEntitlementsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getEntitlementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEntitlementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteEntitlementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateEntitlementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listGrantsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.searchGrantsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getGrantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createGrantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.approveGrantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.denyGrantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.revokeGrantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEntitlementOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Entitlement.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)900000L)).build()));
            builder.deleteEntitlementOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Entitlement.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)900000L)).build()));
            builder.updateEntitlementOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Entitlement.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)900000L)).build()));
            builder.revokeGrantOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Grant.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)900000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CheckOnboardingStatusRequest, CheckOnboardingStatusResponse> checkOnboardingStatusSettings() {
            return this.checkOnboardingStatusSettings;
        }

        public PagedCallSettings.Builder<ListEntitlementsRequest, ListEntitlementsResponse, PrivilegedAccessManagerClient.ListEntitlementsPagedResponse> listEntitlementsSettings() {
            return this.listEntitlementsSettings;
        }

        public PagedCallSettings.Builder<SearchEntitlementsRequest, SearchEntitlementsResponse, PrivilegedAccessManagerClient.SearchEntitlementsPagedResponse> searchEntitlementsSettings() {
            return this.searchEntitlementsSettings;
        }

        public UnaryCallSettings.Builder<GetEntitlementRequest, Entitlement> getEntitlementSettings() {
            return this.getEntitlementSettings;
        }

        public UnaryCallSettings.Builder<CreateEntitlementRequest, Operation> createEntitlementSettings() {
            return this.createEntitlementSettings;
        }

        public OperationCallSettings.Builder<CreateEntitlementRequest, Entitlement, OperationMetadata> createEntitlementOperationSettings() {
            return this.createEntitlementOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEntitlementRequest, Operation> deleteEntitlementSettings() {
            return this.deleteEntitlementSettings;
        }

        public OperationCallSettings.Builder<DeleteEntitlementRequest, Entitlement, OperationMetadata> deleteEntitlementOperationSettings() {
            return this.deleteEntitlementOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateEntitlementRequest, Operation> updateEntitlementSettings() {
            return this.updateEntitlementSettings;
        }

        public OperationCallSettings.Builder<UpdateEntitlementRequest, Entitlement, OperationMetadata> updateEntitlementOperationSettings() {
            return this.updateEntitlementOperationSettings;
        }

        public PagedCallSettings.Builder<ListGrantsRequest, ListGrantsResponse, PrivilegedAccessManagerClient.ListGrantsPagedResponse> listGrantsSettings() {
            return this.listGrantsSettings;
        }

        public PagedCallSettings.Builder<SearchGrantsRequest, SearchGrantsResponse, PrivilegedAccessManagerClient.SearchGrantsPagedResponse> searchGrantsSettings() {
            return this.searchGrantsSettings;
        }

        public UnaryCallSettings.Builder<GetGrantRequest, Grant> getGrantSettings() {
            return this.getGrantSettings;
        }

        public UnaryCallSettings.Builder<CreateGrantRequest, Grant> createGrantSettings() {
            return this.createGrantSettings;
        }

        public UnaryCallSettings.Builder<ApproveGrantRequest, Grant> approveGrantSettings() {
            return this.approveGrantSettings;
        }

        public UnaryCallSettings.Builder<DenyGrantRequest, Grant> denyGrantSettings() {
            return this.denyGrantSettings;
        }

        public UnaryCallSettings.Builder<RevokeGrantRequest, Operation> revokeGrantSettings() {
            return this.revokeGrantSettings;
        }

        public OperationCallSettings.Builder<RevokeGrantRequest, Grant, OperationMetadata> revokeGrantOperationSettings() {
            return this.revokeGrantOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, PrivilegedAccessManagerClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public PrivilegedAccessManagerStubSettings build() throws IOException {
            return new PrivilegedAccessManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

