/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.privatecatalog.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.privatecatalog.v1beta1.PrivateCatalogClient;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchCatalogsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchProductsResponse;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsRequest;
import com.google.cloud.privatecatalog.v1beta1.SearchVersionsResponse;
import com.google.cloud.privatecatalog.v1beta1.stub.HttpJsonPrivateCatalogCallableFactory;
import com.google.cloud.privatecatalog.v1beta1.stub.PrivateCatalogStub;
import com.google.cloud.privatecatalog.v1beta1.stub.PrivateCatalogStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonPrivateCatalogStub
extends PrivateCatalogStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<SearchCatalogsRequest, SearchCatalogsResponse> searchCatalogsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchCatalogs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{resource=projects/*}/catalogs:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta1/{resource=organizations/*}/catalogs:search", "/v1beta1/{resource=folders/*}/catalogs:search"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchCatalogsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchProductsRequest, SearchProductsResponse> searchProductsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchProducts").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{resource=projects/*}/products:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta1/{resource=organizations/*}/products:search", "/v1beta1/{resource=folders/*}/products:search"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchProductsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchVersionsRequest, SearchVersionsResponse> searchVersionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.privatecatalog.v1beta1.PrivateCatalog/SearchVersions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1beta1/{resource=projects/*}/versions:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1beta1/{resource=organizations/*}/versions:search", "/v1beta1/{resource=folders/*}/versions:search"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchVersionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<SearchCatalogsRequest, SearchCatalogsResponse> searchCatalogsCallable;
    private final UnaryCallable<SearchCatalogsRequest, PrivateCatalogClient.SearchCatalogsPagedResponse> searchCatalogsPagedCallable;
    private final UnaryCallable<SearchProductsRequest, SearchProductsResponse> searchProductsCallable;
    private final UnaryCallable<SearchProductsRequest, PrivateCatalogClient.SearchProductsPagedResponse> searchProductsPagedCallable;
    private final UnaryCallable<SearchVersionsRequest, SearchVersionsResponse> searchVersionsCallable;
    private final UnaryCallable<SearchVersionsRequest, PrivateCatalogClient.SearchVersionsPagedResponse> searchVersionsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonPrivateCatalogStub create(PrivateCatalogStubSettings settings) throws IOException {
        return new HttpJsonPrivateCatalogStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonPrivateCatalogStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonPrivateCatalogStub(PrivateCatalogStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonPrivateCatalogStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonPrivateCatalogStub(PrivateCatalogStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonPrivateCatalogStub(PrivateCatalogStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonPrivateCatalogCallableFactory());
    }

    protected HttpJsonPrivateCatalogStub(PrivateCatalogStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings searchCatalogsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchCatalogsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings searchProductsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchProductsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings searchVersionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchVersionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.searchCatalogsCallable = callableFactory.createUnaryCallable(searchCatalogsTransportSettings, settings.searchCatalogsSettings(), clientContext);
        this.searchCatalogsPagedCallable = callableFactory.createPagedCallable(searchCatalogsTransportSettings, settings.searchCatalogsSettings(), clientContext);
        this.searchProductsCallable = callableFactory.createUnaryCallable(searchProductsTransportSettings, settings.searchProductsSettings(), clientContext);
        this.searchProductsPagedCallable = callableFactory.createPagedCallable(searchProductsTransportSettings, settings.searchProductsSettings(), clientContext);
        this.searchVersionsCallable = callableFactory.createUnaryCallable(searchVersionsTransportSettings, settings.searchVersionsSettings(), clientContext);
        this.searchVersionsPagedCallable = callableFactory.createPagedCallable(searchVersionsTransportSettings, settings.searchVersionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(searchCatalogsMethodDescriptor);
        methodDescriptors.add(searchProductsMethodDescriptor);
        methodDescriptors.add(searchVersionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<SearchCatalogsRequest, SearchCatalogsResponse> searchCatalogsCallable() {
        return this.searchCatalogsCallable;
    }

    @Override
    public UnaryCallable<SearchCatalogsRequest, PrivateCatalogClient.SearchCatalogsPagedResponse> searchCatalogsPagedCallable() {
        return this.searchCatalogsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchProductsRequest, SearchProductsResponse> searchProductsCallable() {
        return this.searchProductsCallable;
    }

    @Override
    public UnaryCallable<SearchProductsRequest, PrivateCatalogClient.SearchProductsPagedResponse> searchProductsPagedCallable() {
        return this.searchProductsPagedCallable;
    }

    @Override
    public UnaryCallable<SearchVersionsRequest, SearchVersionsResponse> searchVersionsCallable() {
        return this.searchVersionsCallable;
    }

    @Override
    public UnaryCallable<SearchVersionsRequest, PrivateCatalogClient.SearchVersionsPagedResponse> searchVersionsPagedCallable() {
        return this.searchVersionsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

