/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.policysimulator.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.policysimulator.v1.CreateReplayRequest;
import com.google.cloud.policysimulator.v1.GetReplayRequest;
import com.google.cloud.policysimulator.v1.ListReplayResultsRequest;
import com.google.cloud.policysimulator.v1.ListReplayResultsResponse;
import com.google.cloud.policysimulator.v1.Replay;
import com.google.cloud.policysimulator.v1.ReplayOperationMetadata;
import com.google.cloud.policysimulator.v1.SimulatorClient;
import com.google.cloud.policysimulator.v1.stub.GrpcSimulatorCallableFactory;
import com.google.cloud.policysimulator.v1.stub.SimulatorStub;
import com.google.cloud.policysimulator.v1.stub.SimulatorStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSimulatorStub
extends SimulatorStub {
    private static final MethodDescriptor<GetReplayRequest, Replay> getReplayMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.policysimulator.v1.Simulator/GetReplay").setRequestMarshaller(ProtoUtils.marshaller((Message)GetReplayRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Replay.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateReplayRequest, Operation> createReplayMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.policysimulator.v1.Simulator/CreateReplay").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateReplayRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListReplayResultsRequest, ListReplayResultsResponse> listReplayResultsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.policysimulator.v1.Simulator/ListReplayResults").setRequestMarshaller(ProtoUtils.marshaller((Message)ListReplayResultsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListReplayResultsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetReplayRequest, Replay> getReplayCallable;
    private final UnaryCallable<CreateReplayRequest, Operation> createReplayCallable;
    private final OperationCallable<CreateReplayRequest, Replay, ReplayOperationMetadata> createReplayOperationCallable;
    private final UnaryCallable<ListReplayResultsRequest, ListReplayResultsResponse> listReplayResultsCallable;
    private final UnaryCallable<ListReplayResultsRequest, SimulatorClient.ListReplayResultsPagedResponse> listReplayResultsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSimulatorStub create(SimulatorStubSettings settings) throws IOException {
        return new GrpcSimulatorStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSimulatorStub create(ClientContext clientContext) throws IOException {
        return new GrpcSimulatorStub(SimulatorStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSimulatorStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSimulatorStub(SimulatorStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSimulatorStub(SimulatorStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSimulatorCallableFactory());
    }

    protected GrpcSimulatorStub(SimulatorStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getReplayTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getReplayMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createReplayTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createReplayMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listReplayResultsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listReplayResultsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getReplayCallable = callableFactory.createUnaryCallable(getReplayTransportSettings, settings.getReplaySettings(), clientContext);
        this.createReplayCallable = callableFactory.createUnaryCallable(createReplayTransportSettings, settings.createReplaySettings(), clientContext);
        this.createReplayOperationCallable = callableFactory.createOperationCallable(createReplayTransportSettings, settings.createReplayOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listReplayResultsCallable = callableFactory.createUnaryCallable(listReplayResultsTransportSettings, settings.listReplayResultsSettings(), clientContext);
        this.listReplayResultsPagedCallable = callableFactory.createPagedCallable(listReplayResultsTransportSettings, settings.listReplayResultsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetReplayRequest, Replay> getReplayCallable() {
        return this.getReplayCallable;
    }

    @Override
    public UnaryCallable<CreateReplayRequest, Operation> createReplayCallable() {
        return this.createReplayCallable;
    }

    @Override
    public OperationCallable<CreateReplayRequest, Replay, ReplayOperationMetadata> createReplayOperationCallable() {
        return this.createReplayOperationCallable;
    }

    @Override
    public UnaryCallable<ListReplayResultsRequest, ListReplayResultsResponse> listReplayResultsCallable() {
        return this.listReplayResultsCallable;
    }

    @Override
    public UnaryCallable<ListReplayResultsRequest, SimulatorClient.ListReplayResultsPagedResponse> listReplayResultsPagedCallable() {
        return this.listReplayResultsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

