/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.policysimulator.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.policysimulator.v1.CreateReplayRequest;
import com.google.cloud.policysimulator.v1.GetReplayRequest;
import com.google.cloud.policysimulator.v1.ListReplayResultsRequest;
import com.google.cloud.policysimulator.v1.ListReplayResultsResponse;
import com.google.cloud.policysimulator.v1.Replay;
import com.google.cloud.policysimulator.v1.ReplayOperationMetadata;
import com.google.cloud.policysimulator.v1.SimulatorClient;
import com.google.cloud.policysimulator.v1.stub.HttpJsonSimulatorCallableFactory;
import com.google.cloud.policysimulator.v1.stub.SimulatorStub;
import com.google.cloud.policysimulator.v1.stub.SimulatorStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonSimulatorStub
extends SimulatorStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Replay.getDescriptor()).add(ReplayOperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetReplayRequest, Replay> getReplayMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.policysimulator.v1.Simulator/GetReplay").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/replays/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=folders/*/locations/*/replays/*}", "/v1/{name=organizations/*/locations/*/replays/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Replay.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateReplayRequest, Operation> createReplayMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.policysimulator.v1.Simulator/CreateReplay").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/replays", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=folders/*/locations/*}/replays", "/v1/{parent=organizations/*/locations/*}/replays"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("replay", (Message)request.getReplay(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListReplayResultsRequest, ListReplayResultsResponse> listReplayResultsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.policysimulator.v1.Simulator/ListReplayResults").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/replays/*}/results", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=folders/*/locations/*/replays/*}/results", "/v1/{parent=organizations/*/locations/*/replays/*}/results"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListReplayResultsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetReplayRequest, Replay> getReplayCallable;
    private final UnaryCallable<CreateReplayRequest, Operation> createReplayCallable;
    private final OperationCallable<CreateReplayRequest, Replay, ReplayOperationMetadata> createReplayOperationCallable;
    private final UnaryCallable<ListReplayResultsRequest, ListReplayResultsResponse> listReplayResultsCallable;
    private final UnaryCallable<ListReplayResultsRequest, SimulatorClient.ListReplayResultsPagedResponse> listReplayResultsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSimulatorStub create(SimulatorStubSettings settings) throws IOException {
        return new HttpJsonSimulatorStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSimulatorStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSimulatorStub(SimulatorStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSimulatorStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSimulatorStub(SimulatorStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSimulatorStub(SimulatorStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSimulatorCallableFactory());
    }

    protected HttpJsonSimulatorStub(SimulatorStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=operations/**}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/replays/*/operations/**}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=folders/*/locations/*/replays/*/operations/**}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=organizations/*/locations/*/replays/*/operations/**}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=operations}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/replays/*/operations}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=folders/*/locations/*/replays/*/operations}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=organizations/*/locations/*/replays/*/operations}").build()).build()).build());
        HttpJsonCallSettings getReplayTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getReplayMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createReplayTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createReplayMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listReplayResultsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listReplayResultsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getReplayCallable = callableFactory.createUnaryCallable(getReplayTransportSettings, settings.getReplaySettings(), clientContext);
        this.createReplayCallable = callableFactory.createUnaryCallable(createReplayTransportSettings, settings.createReplaySettings(), clientContext);
        this.createReplayOperationCallable = callableFactory.createOperationCallable(createReplayTransportSettings, settings.createReplayOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listReplayResultsCallable = callableFactory.createUnaryCallable(listReplayResultsTransportSettings, settings.listReplayResultsSettings(), clientContext);
        this.listReplayResultsPagedCallable = callableFactory.createPagedCallable(listReplayResultsTransportSettings, settings.listReplayResultsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getReplayMethodDescriptor);
        methodDescriptors.add(createReplayMethodDescriptor);
        methodDescriptors.add(listReplayResultsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetReplayRequest, Replay> getReplayCallable() {
        return this.getReplayCallable;
    }

    @Override
    public UnaryCallable<CreateReplayRequest, Operation> createReplayCallable() {
        return this.createReplayCallable;
    }

    @Override
    public OperationCallable<CreateReplayRequest, Replay, ReplayOperationMetadata> createReplayOperationCallable() {
        return this.createReplayOperationCallable;
    }

    @Override
    public UnaryCallable<ListReplayResultsRequest, ListReplayResultsResponse> listReplayResultsCallable() {
        return this.listReplayResultsCallable;
    }

    @Override
    public UnaryCallable<ListReplayResultsRequest, SimulatorClient.ListReplayResultsPagedResponse> listReplayResultsPagedCallable() {
        return this.listReplayResultsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

