/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.parametermanager.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.parametermanager.v1.CreateParameterRequest;
import com.google.cloud.parametermanager.v1.CreateParameterVersionRequest;
import com.google.cloud.parametermanager.v1.DeleteParameterRequest;
import com.google.cloud.parametermanager.v1.DeleteParameterVersionRequest;
import com.google.cloud.parametermanager.v1.GetParameterRequest;
import com.google.cloud.parametermanager.v1.GetParameterVersionRequest;
import com.google.cloud.parametermanager.v1.ListParameterVersionsRequest;
import com.google.cloud.parametermanager.v1.ListParameterVersionsResponse;
import com.google.cloud.parametermanager.v1.ListParametersRequest;
import com.google.cloud.parametermanager.v1.ListParametersResponse;
import com.google.cloud.parametermanager.v1.LocationName;
import com.google.cloud.parametermanager.v1.Parameter;
import com.google.cloud.parametermanager.v1.ParameterManagerSettings;
import com.google.cloud.parametermanager.v1.ParameterName;
import com.google.cloud.parametermanager.v1.ParameterVersion;
import com.google.cloud.parametermanager.v1.ParameterVersionName;
import com.google.cloud.parametermanager.v1.RenderParameterVersionRequest;
import com.google.cloud.parametermanager.v1.RenderParameterVersionResponse;
import com.google.cloud.parametermanager.v1.UpdateParameterRequest;
import com.google.cloud.parametermanager.v1.UpdateParameterVersionRequest;
import com.google.cloud.parametermanager.v1.stub.ParameterManagerStub;
import com.google.cloud.parametermanager.v1.stub.ParameterManagerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ParameterManagerClient
implements BackgroundResource {
    private final ParameterManagerSettings settings;
    private final ParameterManagerStub stub;

    public static final ParameterManagerClient create() throws IOException {
        return ParameterManagerClient.create(ParameterManagerSettings.newBuilder().build());
    }

    public static final ParameterManagerClient create(ParameterManagerSettings settings) throws IOException {
        return new ParameterManagerClient(settings);
    }

    public static final ParameterManagerClient create(ParameterManagerStub stub) {
        return new ParameterManagerClient(stub);
    }

    protected ParameterManagerClient(ParameterManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ParameterManagerStubSettings)settings.getStubSettings()).createStub();
    }

    protected ParameterManagerClient(ParameterManagerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ParameterManagerSettings getSettings() {
        return this.settings;
    }

    public ParameterManagerStub getStub() {
        return this.stub;
    }

    public final ListParametersPagedResponse listParameters(LocationName parent) {
        ListParametersRequest request = ListParametersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listParameters(request);
    }

    public final ListParametersPagedResponse listParameters(String parent) {
        ListParametersRequest request = ListParametersRequest.newBuilder().setParent(parent).build();
        return this.listParameters(request);
    }

    public final ListParametersPagedResponse listParameters(ListParametersRequest request) {
        return (ListParametersPagedResponse)((Object)this.listParametersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListParametersRequest, ListParametersPagedResponse> listParametersPagedCallable() {
        return this.stub.listParametersPagedCallable();
    }

    public final UnaryCallable<ListParametersRequest, ListParametersResponse> listParametersCallable() {
        return this.stub.listParametersCallable();
    }

    public final Parameter getParameter(ParameterName name) {
        GetParameterRequest request = GetParameterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getParameter(request);
    }

    public final Parameter getParameter(String name) {
        GetParameterRequest request = GetParameterRequest.newBuilder().setName(name).build();
        return this.getParameter(request);
    }

    public final Parameter getParameter(GetParameterRequest request) {
        return (Parameter)this.getParameterCallable().call((Object)request);
    }

    public final UnaryCallable<GetParameterRequest, Parameter> getParameterCallable() {
        return this.stub.getParameterCallable();
    }

    public final Parameter createParameter(LocationName parent, Parameter parameter, String parameterId) {
        CreateParameterRequest request = CreateParameterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setParameter(parameter).setParameterId(parameterId).build();
        return this.createParameter(request);
    }

    public final Parameter createParameter(String parent, Parameter parameter, String parameterId) {
        CreateParameterRequest request = CreateParameterRequest.newBuilder().setParent(parent).setParameter(parameter).setParameterId(parameterId).build();
        return this.createParameter(request);
    }

    public final Parameter createParameter(CreateParameterRequest request) {
        return (Parameter)this.createParameterCallable().call((Object)request);
    }

    public final UnaryCallable<CreateParameterRequest, Parameter> createParameterCallable() {
        return this.stub.createParameterCallable();
    }

    public final Parameter updateParameter(Parameter parameter, FieldMask updateMask) {
        UpdateParameterRequest request = UpdateParameterRequest.newBuilder().setParameter(parameter).setUpdateMask(updateMask).build();
        return this.updateParameter(request);
    }

    public final Parameter updateParameter(UpdateParameterRequest request) {
        return (Parameter)this.updateParameterCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateParameterRequest, Parameter> updateParameterCallable() {
        return this.stub.updateParameterCallable();
    }

    public final void deleteParameter(ParameterName name) {
        DeleteParameterRequest request = DeleteParameterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteParameter(request);
    }

    public final void deleteParameter(String name) {
        DeleteParameterRequest request = DeleteParameterRequest.newBuilder().setName(name).build();
        this.deleteParameter(request);
    }

    public final void deleteParameter(DeleteParameterRequest request) {
        this.deleteParameterCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteParameterRequest, Empty> deleteParameterCallable() {
        return this.stub.deleteParameterCallable();
    }

    public final ListParameterVersionsPagedResponse listParameterVersions(ParameterName parent) {
        ListParameterVersionsRequest request = ListParameterVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listParameterVersions(request);
    }

    public final ListParameterVersionsPagedResponse listParameterVersions(String parent) {
        ListParameterVersionsRequest request = ListParameterVersionsRequest.newBuilder().setParent(parent).build();
        return this.listParameterVersions(request);
    }

    public final ListParameterVersionsPagedResponse listParameterVersions(ListParameterVersionsRequest request) {
        return (ListParameterVersionsPagedResponse)((Object)this.listParameterVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListParameterVersionsRequest, ListParameterVersionsPagedResponse> listParameterVersionsPagedCallable() {
        return this.stub.listParameterVersionsPagedCallable();
    }

    public final UnaryCallable<ListParameterVersionsRequest, ListParameterVersionsResponse> listParameterVersionsCallable() {
        return this.stub.listParameterVersionsCallable();
    }

    public final ParameterVersion getParameterVersion(ParameterVersionName name) {
        GetParameterVersionRequest request = GetParameterVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getParameterVersion(request);
    }

    public final ParameterVersion getParameterVersion(String name) {
        GetParameterVersionRequest request = GetParameterVersionRequest.newBuilder().setName(name).build();
        return this.getParameterVersion(request);
    }

    public final ParameterVersion getParameterVersion(GetParameterVersionRequest request) {
        return (ParameterVersion)this.getParameterVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetParameterVersionRequest, ParameterVersion> getParameterVersionCallable() {
        return this.stub.getParameterVersionCallable();
    }

    public final RenderParameterVersionResponse renderParameterVersion(ParameterVersionName name) {
        RenderParameterVersionRequest request = RenderParameterVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.renderParameterVersion(request);
    }

    public final RenderParameterVersionResponse renderParameterVersion(String name) {
        RenderParameterVersionRequest request = RenderParameterVersionRequest.newBuilder().setName(name).build();
        return this.renderParameterVersion(request);
    }

    public final RenderParameterVersionResponse renderParameterVersion(RenderParameterVersionRequest request) {
        return (RenderParameterVersionResponse)this.renderParameterVersionCallable().call((Object)request);
    }

    public final UnaryCallable<RenderParameterVersionRequest, RenderParameterVersionResponse> renderParameterVersionCallable() {
        return this.stub.renderParameterVersionCallable();
    }

    public final ParameterVersion createParameterVersion(ParameterName parent, ParameterVersion parameterVersion, String parameterVersionId) {
        CreateParameterVersionRequest request = CreateParameterVersionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setParameterVersion(parameterVersion).setParameterVersionId(parameterVersionId).build();
        return this.createParameterVersion(request);
    }

    public final ParameterVersion createParameterVersion(String parent, ParameterVersion parameterVersion, String parameterVersionId) {
        CreateParameterVersionRequest request = CreateParameterVersionRequest.newBuilder().setParent(parent).setParameterVersion(parameterVersion).setParameterVersionId(parameterVersionId).build();
        return this.createParameterVersion(request);
    }

    public final ParameterVersion createParameterVersion(CreateParameterVersionRequest request) {
        return (ParameterVersion)this.createParameterVersionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateParameterVersionRequest, ParameterVersion> createParameterVersionCallable() {
        return this.stub.createParameterVersionCallable();
    }

    public final ParameterVersion updateParameterVersion(ParameterVersion parameterVersion, FieldMask updateMask) {
        UpdateParameterVersionRequest request = UpdateParameterVersionRequest.newBuilder().setParameterVersion(parameterVersion).setUpdateMask(updateMask).build();
        return this.updateParameterVersion(request);
    }

    public final ParameterVersion updateParameterVersion(UpdateParameterVersionRequest request) {
        return (ParameterVersion)this.updateParameterVersionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateParameterVersionRequest, ParameterVersion> updateParameterVersionCallable() {
        return this.stub.updateParameterVersionCallable();
    }

    public final void deleteParameterVersion(ParameterVersionName name) {
        DeleteParameterVersionRequest request = DeleteParameterVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteParameterVersion(request);
    }

    public final void deleteParameterVersion(String name) {
        DeleteParameterVersionRequest request = DeleteParameterVersionRequest.newBuilder().setName(name).build();
        this.deleteParameterVersion(request);
    }

    public final void deleteParameterVersion(DeleteParameterVersionRequest request) {
        this.deleteParameterVersionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteParameterVersionRequest, Empty> deleteParameterVersionCallable() {
        return this.stub.deleteParameterVersionCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListParameterVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterVersion, ListParameterVersionsPage, ListParameterVersionsFixedSizeCollection> {
        private ListParameterVersionsFixedSizeCollection(List<ListParameterVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListParameterVersionsFixedSizeCollection createEmptyCollection() {
            return new ListParameterVersionsFixedSizeCollection(null, 0);
        }

        protected ListParameterVersionsFixedSizeCollection createCollection(List<ListParameterVersionsPage> pages, int collectionSize) {
            return new ListParameterVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListParameterVersionsPage
    extends AbstractPage<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterVersion, ListParameterVersionsPage> {
        private ListParameterVersionsPage(PageContext<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterVersion> context, ListParameterVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListParameterVersionsPage createEmptyPage() {
            return new ListParameterVersionsPage(null, null);
        }

        protected ListParameterVersionsPage createPage(PageContext<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterVersion> context, ListParameterVersionsResponse response) {
            return new ListParameterVersionsPage(context, response);
        }

        public ApiFuture<ListParameterVersionsPage> createPageAsync(PageContext<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterVersion> context, ApiFuture<ListParameterVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListParameterVersionsPagedResponse
    extends AbstractPagedListResponse<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterVersion, ListParameterVersionsPage, ListParameterVersionsFixedSizeCollection> {
        public static ApiFuture<ListParameterVersionsPagedResponse> createAsync(PageContext<ListParameterVersionsRequest, ListParameterVersionsResponse, ParameterVersion> context, ApiFuture<ListParameterVersionsResponse> futureResponse) {
            ApiFuture<ListParameterVersionsPage> futurePage = ListParameterVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListParameterVersionsPagedResponse((ListParameterVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListParameterVersionsPagedResponse(ListParameterVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListParameterVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListParametersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListParametersRequest, ListParametersResponse, Parameter, ListParametersPage, ListParametersFixedSizeCollection> {
        private ListParametersFixedSizeCollection(List<ListParametersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListParametersFixedSizeCollection createEmptyCollection() {
            return new ListParametersFixedSizeCollection(null, 0);
        }

        protected ListParametersFixedSizeCollection createCollection(List<ListParametersPage> pages, int collectionSize) {
            return new ListParametersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListParametersPage
    extends AbstractPage<ListParametersRequest, ListParametersResponse, Parameter, ListParametersPage> {
        private ListParametersPage(PageContext<ListParametersRequest, ListParametersResponse, Parameter> context, ListParametersResponse response) {
            super(context, (Object)response);
        }

        private static ListParametersPage createEmptyPage() {
            return new ListParametersPage(null, null);
        }

        protected ListParametersPage createPage(PageContext<ListParametersRequest, ListParametersResponse, Parameter> context, ListParametersResponse response) {
            return new ListParametersPage(context, response);
        }

        public ApiFuture<ListParametersPage> createPageAsync(PageContext<ListParametersRequest, ListParametersResponse, Parameter> context, ApiFuture<ListParametersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListParametersPagedResponse
    extends AbstractPagedListResponse<ListParametersRequest, ListParametersResponse, Parameter, ListParametersPage, ListParametersFixedSizeCollection> {
        public static ApiFuture<ListParametersPagedResponse> createAsync(PageContext<ListParametersRequest, ListParametersResponse, Parameter> context, ApiFuture<ListParametersResponse> futureResponse) {
            ApiFuture<ListParametersPage> futurePage = ListParametersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListParametersPagedResponse((ListParametersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListParametersPagedResponse(ListParametersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListParametersFixedSizeCollection.createEmptyCollection());
        }
    }
}

