/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.parametermanager.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.parametermanager.v1.CreateParameterRequest;
import com.google.cloud.parametermanager.v1.CreateParameterVersionRequest;
import com.google.cloud.parametermanager.v1.DeleteParameterRequest;
import com.google.cloud.parametermanager.v1.DeleteParameterVersionRequest;
import com.google.cloud.parametermanager.v1.GetParameterRequest;
import com.google.cloud.parametermanager.v1.GetParameterVersionRequest;
import com.google.cloud.parametermanager.v1.ListParameterVersionsRequest;
import com.google.cloud.parametermanager.v1.ListParameterVersionsResponse;
import com.google.cloud.parametermanager.v1.ListParametersRequest;
import com.google.cloud.parametermanager.v1.ListParametersResponse;
import com.google.cloud.parametermanager.v1.Parameter;
import com.google.cloud.parametermanager.v1.ParameterManagerClient;
import com.google.cloud.parametermanager.v1.ParameterVersion;
import com.google.cloud.parametermanager.v1.RenderParameterVersionRequest;
import com.google.cloud.parametermanager.v1.RenderParameterVersionResponse;
import com.google.cloud.parametermanager.v1.UpdateParameterRequest;
import com.google.cloud.parametermanager.v1.UpdateParameterVersionRequest;
import com.google.cloud.parametermanager.v1.stub.GrpcParameterManagerCallableFactory;
import com.google.cloud.parametermanager.v1.stub.ParameterManagerStub;
import com.google.cloud.parametermanager.v1.stub.ParameterManagerStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcParameterManagerStub
extends ParameterManagerStub {
    private static final MethodDescriptor<ListParametersRequest, ListParametersResponse> listParametersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/ListParameters").setRequestMarshaller(ProtoUtils.marshaller((Message)ListParametersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListParametersResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetParameterRequest, Parameter> getParameterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/GetParameter").setRequestMarshaller(ProtoUtils.marshaller((Message)GetParameterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Parameter.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateParameterRequest, Parameter> createParameterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/CreateParameter").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateParameterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Parameter.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateParameterRequest, Parameter> updateParameterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/UpdateParameter").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateParameterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Parameter.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteParameterRequest, Empty> deleteParameterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/DeleteParameter").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteParameterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListParameterVersionsRequest, ListParameterVersionsResponse> listParameterVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/ListParameterVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListParameterVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListParameterVersionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetParameterVersionRequest, ParameterVersion> getParameterVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/GetParameterVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)GetParameterVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ParameterVersion.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RenderParameterVersionRequest, RenderParameterVersionResponse> renderParameterVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/RenderParameterVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)RenderParameterVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RenderParameterVersionResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateParameterVersionRequest, ParameterVersion> createParameterVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/CreateParameterVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateParameterVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ParameterVersion.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateParameterVersionRequest, ParameterVersion> updateParameterVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/UpdateParameterVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateParameterVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ParameterVersion.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteParameterVersionRequest, Empty> deleteParameterVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/DeleteParameterVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteParameterVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListParametersRequest, ListParametersResponse> listParametersCallable;
    private final UnaryCallable<ListParametersRequest, ParameterManagerClient.ListParametersPagedResponse> listParametersPagedCallable;
    private final UnaryCallable<GetParameterRequest, Parameter> getParameterCallable;
    private final UnaryCallable<CreateParameterRequest, Parameter> createParameterCallable;
    private final UnaryCallable<UpdateParameterRequest, Parameter> updateParameterCallable;
    private final UnaryCallable<DeleteParameterRequest, Empty> deleteParameterCallable;
    private final UnaryCallable<ListParameterVersionsRequest, ListParameterVersionsResponse> listParameterVersionsCallable;
    private final UnaryCallable<ListParameterVersionsRequest, ParameterManagerClient.ListParameterVersionsPagedResponse> listParameterVersionsPagedCallable;
    private final UnaryCallable<GetParameterVersionRequest, ParameterVersion> getParameterVersionCallable;
    private final UnaryCallable<RenderParameterVersionRequest, RenderParameterVersionResponse> renderParameterVersionCallable;
    private final UnaryCallable<CreateParameterVersionRequest, ParameterVersion> createParameterVersionCallable;
    private final UnaryCallable<UpdateParameterVersionRequest, ParameterVersion> updateParameterVersionCallable;
    private final UnaryCallable<DeleteParameterVersionRequest, Empty> deleteParameterVersionCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ParameterManagerClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcParameterManagerStub create(ParameterManagerStubSettings settings) throws IOException {
        return new GrpcParameterManagerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcParameterManagerStub create(ClientContext clientContext) throws IOException {
        return new GrpcParameterManagerStub(ParameterManagerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcParameterManagerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcParameterManagerStub(ParameterManagerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcParameterManagerStub(ParameterManagerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcParameterManagerCallableFactory());
    }

    protected GrpcParameterManagerStub(ParameterManagerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listParametersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listParametersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getParameterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getParameterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createParameterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createParameterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateParameterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateParameterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parameter.name", String.valueOf(request.getParameter().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteParameterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteParameterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listParameterVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listParameterVersionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getParameterVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getParameterVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings renderParameterVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(renderParameterVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createParameterVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createParameterVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateParameterVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateParameterVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parameter_version.name", String.valueOf(request.getParameterVersion().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteParameterVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteParameterVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listParametersCallable = callableFactory.createUnaryCallable(listParametersTransportSettings, settings.listParametersSettings(), clientContext);
        this.listParametersPagedCallable = callableFactory.createPagedCallable(listParametersTransportSettings, settings.listParametersSettings(), clientContext);
        this.getParameterCallable = callableFactory.createUnaryCallable(getParameterTransportSettings, settings.getParameterSettings(), clientContext);
        this.createParameterCallable = callableFactory.createUnaryCallable(createParameterTransportSettings, settings.createParameterSettings(), clientContext);
        this.updateParameterCallable = callableFactory.createUnaryCallable(updateParameterTransportSettings, settings.updateParameterSettings(), clientContext);
        this.deleteParameterCallable = callableFactory.createUnaryCallable(deleteParameterTransportSettings, settings.deleteParameterSettings(), clientContext);
        this.listParameterVersionsCallable = callableFactory.createUnaryCallable(listParameterVersionsTransportSettings, settings.listParameterVersionsSettings(), clientContext);
        this.listParameterVersionsPagedCallable = callableFactory.createPagedCallable(listParameterVersionsTransportSettings, settings.listParameterVersionsSettings(), clientContext);
        this.getParameterVersionCallable = callableFactory.createUnaryCallable(getParameterVersionTransportSettings, settings.getParameterVersionSettings(), clientContext);
        this.renderParameterVersionCallable = callableFactory.createUnaryCallable(renderParameterVersionTransportSettings, settings.renderParameterVersionSettings(), clientContext);
        this.createParameterVersionCallable = callableFactory.createUnaryCallable(createParameterVersionTransportSettings, settings.createParameterVersionSettings(), clientContext);
        this.updateParameterVersionCallable = callableFactory.createUnaryCallable(updateParameterVersionTransportSettings, settings.updateParameterVersionSettings(), clientContext);
        this.deleteParameterVersionCallable = callableFactory.createUnaryCallable(deleteParameterVersionTransportSettings, settings.deleteParameterVersionSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListParametersRequest, ListParametersResponse> listParametersCallable() {
        return this.listParametersCallable;
    }

    @Override
    public UnaryCallable<ListParametersRequest, ParameterManagerClient.ListParametersPagedResponse> listParametersPagedCallable() {
        return this.listParametersPagedCallable;
    }

    @Override
    public UnaryCallable<GetParameterRequest, Parameter> getParameterCallable() {
        return this.getParameterCallable;
    }

    @Override
    public UnaryCallable<CreateParameterRequest, Parameter> createParameterCallable() {
        return this.createParameterCallable;
    }

    @Override
    public UnaryCallable<UpdateParameterRequest, Parameter> updateParameterCallable() {
        return this.updateParameterCallable;
    }

    @Override
    public UnaryCallable<DeleteParameterRequest, Empty> deleteParameterCallable() {
        return this.deleteParameterCallable;
    }

    @Override
    public UnaryCallable<ListParameterVersionsRequest, ListParameterVersionsResponse> listParameterVersionsCallable() {
        return this.listParameterVersionsCallable;
    }

    @Override
    public UnaryCallable<ListParameterVersionsRequest, ParameterManagerClient.ListParameterVersionsPagedResponse> listParameterVersionsPagedCallable() {
        return this.listParameterVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetParameterVersionRequest, ParameterVersion> getParameterVersionCallable() {
        return this.getParameterVersionCallable;
    }

    @Override
    public UnaryCallable<RenderParameterVersionRequest, RenderParameterVersionResponse> renderParameterVersionCallable() {
        return this.renderParameterVersionCallable;
    }

    @Override
    public UnaryCallable<CreateParameterVersionRequest, ParameterVersion> createParameterVersionCallable() {
        return this.createParameterVersionCallable;
    }

    @Override
    public UnaryCallable<UpdateParameterVersionRequest, ParameterVersion> updateParameterVersionCallable() {
        return this.updateParameterVersionCallable;
    }

    @Override
    public UnaryCallable<DeleteParameterVersionRequest, Empty> deleteParameterVersionCallable() {
        return this.deleteParameterVersionCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ParameterManagerClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

