/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.parallelstore.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.parallelstore.v1.CreateInstanceRequest;
import com.google.cloud.parallelstore.v1.DeleteInstanceRequest;
import com.google.cloud.parallelstore.v1.ExportDataMetadata;
import com.google.cloud.parallelstore.v1.ExportDataRequest;
import com.google.cloud.parallelstore.v1.ExportDataResponse;
import com.google.cloud.parallelstore.v1.GetInstanceRequest;
import com.google.cloud.parallelstore.v1.ImportDataMetadata;
import com.google.cloud.parallelstore.v1.ImportDataRequest;
import com.google.cloud.parallelstore.v1.ImportDataResponse;
import com.google.cloud.parallelstore.v1.Instance;
import com.google.cloud.parallelstore.v1.ListInstancesRequest;
import com.google.cloud.parallelstore.v1.ListInstancesResponse;
import com.google.cloud.parallelstore.v1.OperationMetadata;
import com.google.cloud.parallelstore.v1.ParallelstoreClient;
import com.google.cloud.parallelstore.v1.UpdateInstanceRequest;
import com.google.cloud.parallelstore.v1.stub.GrpcParallelstoreCallableFactory;
import com.google.cloud.parallelstore.v1.stub.ParallelstoreStub;
import com.google.cloud.parallelstore.v1.stub.ParallelstoreStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcParallelstoreStub
extends ParallelstoreStub {
    private static final MethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parallelstore.v1.Parallelstore/ListInstances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInstancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInstancesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parallelstore.v1.Parallelstore/GetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Instance.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateInstanceRequest, Operation> createInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parallelstore.v1.Parallelstore/CreateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateInstanceRequest, Operation> updateInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parallelstore.v1.Parallelstore/UpdateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteInstanceRequest, Operation> deleteInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parallelstore.v1.Parallelstore/DeleteInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportDataRequest, Operation> importDataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parallelstore.v1.Parallelstore/ImportData").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportDataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportDataRequest, Operation> exportDataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.parallelstore.v1.Parallelstore/ExportData").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportDataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, ParallelstoreClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable;
    private final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable;
    private final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable;
    private final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable;
    private final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable;
    private final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable;
    private final UnaryCallable<ImportDataRequest, Operation> importDataCallable;
    private final OperationCallable<ImportDataRequest, ImportDataResponse, ImportDataMetadata> importDataOperationCallable;
    private final UnaryCallable<ExportDataRequest, Operation> exportDataCallable;
    private final OperationCallable<ExportDataRequest, ExportDataResponse, ExportDataMetadata> exportDataOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ParallelstoreClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcParallelstoreStub create(ParallelstoreStubSettings settings) throws IOException {
        return new GrpcParallelstoreStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcParallelstoreStub create(ClientContext clientContext) throws IOException {
        return new GrpcParallelstoreStub(ParallelstoreStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcParallelstoreStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcParallelstoreStub(ParallelstoreStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcParallelstoreStub(ParallelstoreStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcParallelstoreCallableFactory());
    }

    protected GrpcParallelstoreStub(ParallelstoreStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listInstancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("instance.name", String.valueOf(request.getInstance().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings importDataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importDataMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings exportDataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportDataMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.createInstanceCallable = callableFactory.createUnaryCallable(createInstanceTransportSettings, settings.createInstanceSettings(), clientContext);
        this.createInstanceOperationCallable = callableFactory.createOperationCallable(createInstanceTransportSettings, settings.createInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateInstanceCallable = callableFactory.createUnaryCallable(updateInstanceTransportSettings, settings.updateInstanceSettings(), clientContext);
        this.updateInstanceOperationCallable = callableFactory.createOperationCallable(updateInstanceTransportSettings, settings.updateInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteInstanceCallable = callableFactory.createUnaryCallable(deleteInstanceTransportSettings, settings.deleteInstanceSettings(), clientContext);
        this.deleteInstanceOperationCallable = callableFactory.createOperationCallable(deleteInstanceTransportSettings, settings.deleteInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importDataCallable = callableFactory.createUnaryCallable(importDataTransportSettings, settings.importDataSettings(), clientContext);
        this.importDataOperationCallable = callableFactory.createOperationCallable(importDataTransportSettings, settings.importDataOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportDataCallable = callableFactory.createUnaryCallable(exportDataTransportSettings, settings.exportDataSettings(), clientContext);
        this.exportDataOperationCallable = callableFactory.createOperationCallable(exportDataTransportSettings, settings.exportDataOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ParallelstoreClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.createInstanceCallable;
    }

    @Override
    public OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.createInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.updateInstanceCallable;
    }

    @Override
    public OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.updateInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.deleteInstanceCallable;
    }

    @Override
    public OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.deleteInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<ImportDataRequest, Operation> importDataCallable() {
        return this.importDataCallable;
    }

    @Override
    public OperationCallable<ImportDataRequest, ImportDataResponse, ImportDataMetadata> importDataOperationCallable() {
        return this.importDataOperationCallable;
    }

    @Override
    public UnaryCallable<ExportDataRequest, Operation> exportDataCallable() {
        return this.exportDataCallable;
    }

    @Override
    public OperationCallable<ExportDataRequest, ExportDataResponse, ExportDataMetadata> exportDataOperationCallable() {
        return this.exportDataOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ParallelstoreClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

