/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.osconfig.v1beta.GuestPolicies;
import com.google.cloud.osconfig.v1beta.OsConfigServiceClient;
import com.google.cloud.osconfig.v1beta.PatchDeployments;
import com.google.cloud.osconfig.v1beta.PatchJobs;
import com.google.cloud.osconfig.v1beta.stub.GrpcOsConfigServiceStub;
import com.google.cloud.osconfig.v1beta.stub.HttpJsonOsConfigServiceStub;
import com.google.cloud.osconfig.v1beta.stub.OsConfigServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class OsConfigServiceStubSettings
extends StubSettings<OsConfigServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<PatchJobs.ExecutePatchJobRequest, PatchJobs.PatchJob> executePatchJobSettings;
    private final UnaryCallSettings<PatchJobs.GetPatchJobRequest, PatchJobs.PatchJob> getPatchJobSettings;
    private final UnaryCallSettings<PatchJobs.CancelPatchJobRequest, PatchJobs.PatchJob> cancelPatchJobSettings;
    private final PagedCallSettings<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, OsConfigServiceClient.ListPatchJobsPagedResponse> listPatchJobsSettings;
    private final PagedCallSettings<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, OsConfigServiceClient.ListPatchJobInstanceDetailsPagedResponse> listPatchJobInstanceDetailsSettings;
    private final UnaryCallSettings<PatchDeployments.CreatePatchDeploymentRequest, PatchDeployments.PatchDeployment> createPatchDeploymentSettings;
    private final UnaryCallSettings<PatchDeployments.GetPatchDeploymentRequest, PatchDeployments.PatchDeployment> getPatchDeploymentSettings;
    private final PagedCallSettings<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, OsConfigServiceClient.ListPatchDeploymentsPagedResponse> listPatchDeploymentsSettings;
    private final UnaryCallSettings<PatchDeployments.DeletePatchDeploymentRequest, Empty> deletePatchDeploymentSettings;
    private final UnaryCallSettings<PatchDeployments.UpdatePatchDeploymentRequest, PatchDeployments.PatchDeployment> updatePatchDeploymentSettings;
    private final UnaryCallSettings<PatchDeployments.PausePatchDeploymentRequest, PatchDeployments.PatchDeployment> pausePatchDeploymentSettings;
    private final UnaryCallSettings<PatchDeployments.ResumePatchDeploymentRequest, PatchDeployments.PatchDeployment> resumePatchDeploymentSettings;
    private final UnaryCallSettings<GuestPolicies.CreateGuestPolicyRequest, GuestPolicies.GuestPolicy> createGuestPolicySettings;
    private final UnaryCallSettings<GuestPolicies.GetGuestPolicyRequest, GuestPolicies.GuestPolicy> getGuestPolicySettings;
    private final PagedCallSettings<GuestPolicies.ListGuestPoliciesRequest, GuestPolicies.ListGuestPoliciesResponse, OsConfigServiceClient.ListGuestPoliciesPagedResponse> listGuestPoliciesSettings;
    private final UnaryCallSettings<GuestPolicies.UpdateGuestPolicyRequest, GuestPolicies.GuestPolicy> updateGuestPolicySettings;
    private final UnaryCallSettings<GuestPolicies.DeleteGuestPolicyRequest, Empty> deleteGuestPolicySettings;
    private final UnaryCallSettings<GuestPolicies.LookupEffectiveGuestPolicyRequest, GuestPolicies.EffectiveGuestPolicy> lookupEffectiveGuestPolicySettings;
    private static final PagedListDescriptor<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, PatchJobs.PatchJob> LIST_PATCH_JOBS_PAGE_STR_DESC = new PagedListDescriptor<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, PatchJobs.PatchJob>(){

        public String emptyToken() {
            return "";
        }

        public PatchJobs.ListPatchJobsRequest injectToken(PatchJobs.ListPatchJobsRequest payload, String token) {
            return PatchJobs.ListPatchJobsRequest.newBuilder((PatchJobs.ListPatchJobsRequest)payload).setPageToken(token).build();
        }

        public PatchJobs.ListPatchJobsRequest injectPageSize(PatchJobs.ListPatchJobsRequest payload, int pageSize) {
            return PatchJobs.ListPatchJobsRequest.newBuilder((PatchJobs.ListPatchJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(PatchJobs.ListPatchJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(PatchJobs.ListPatchJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PatchJobs.PatchJob> extractResources(PatchJobs.ListPatchJobsResponse payload) {
            return payload.getPatchJobsList() == null ? ImmutableList.of() : payload.getPatchJobsList();
        }
    };
    private static final PagedListDescriptor<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, PatchJobs.PatchJobInstanceDetails> LIST_PATCH_JOB_INSTANCE_DETAILS_PAGE_STR_DESC = new PagedListDescriptor<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, PatchJobs.PatchJobInstanceDetails>(){

        public String emptyToken() {
            return "";
        }

        public PatchJobs.ListPatchJobInstanceDetailsRequest injectToken(PatchJobs.ListPatchJobInstanceDetailsRequest payload, String token) {
            return PatchJobs.ListPatchJobInstanceDetailsRequest.newBuilder((PatchJobs.ListPatchJobInstanceDetailsRequest)payload).setPageToken(token).build();
        }

        public PatchJobs.ListPatchJobInstanceDetailsRequest injectPageSize(PatchJobs.ListPatchJobInstanceDetailsRequest payload, int pageSize) {
            return PatchJobs.ListPatchJobInstanceDetailsRequest.newBuilder((PatchJobs.ListPatchJobInstanceDetailsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(PatchJobs.ListPatchJobInstanceDetailsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(PatchJobs.ListPatchJobInstanceDetailsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PatchJobs.PatchJobInstanceDetails> extractResources(PatchJobs.ListPatchJobInstanceDetailsResponse payload) {
            return payload.getPatchJobInstanceDetailsList() == null ? ImmutableList.of() : payload.getPatchJobInstanceDetailsList();
        }
    };
    private static final PagedListDescriptor<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, PatchDeployments.PatchDeployment> LIST_PATCH_DEPLOYMENTS_PAGE_STR_DESC = new PagedListDescriptor<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, PatchDeployments.PatchDeployment>(){

        public String emptyToken() {
            return "";
        }

        public PatchDeployments.ListPatchDeploymentsRequest injectToken(PatchDeployments.ListPatchDeploymentsRequest payload, String token) {
            return PatchDeployments.ListPatchDeploymentsRequest.newBuilder((PatchDeployments.ListPatchDeploymentsRequest)payload).setPageToken(token).build();
        }

        public PatchDeployments.ListPatchDeploymentsRequest injectPageSize(PatchDeployments.ListPatchDeploymentsRequest payload, int pageSize) {
            return PatchDeployments.ListPatchDeploymentsRequest.newBuilder((PatchDeployments.ListPatchDeploymentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(PatchDeployments.ListPatchDeploymentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(PatchDeployments.ListPatchDeploymentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PatchDeployments.PatchDeployment> extractResources(PatchDeployments.ListPatchDeploymentsResponse payload) {
            return payload.getPatchDeploymentsList() == null ? ImmutableList.of() : payload.getPatchDeploymentsList();
        }
    };
    private static final PagedListDescriptor<GuestPolicies.ListGuestPoliciesRequest, GuestPolicies.ListGuestPoliciesResponse, GuestPolicies.GuestPolicy> LIST_GUEST_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<GuestPolicies.ListGuestPoliciesRequest, GuestPolicies.ListGuestPoliciesResponse, GuestPolicies.GuestPolicy>(){

        public String emptyToken() {
            return "";
        }

        public GuestPolicies.ListGuestPoliciesRequest injectToken(GuestPolicies.ListGuestPoliciesRequest payload, String token) {
            return GuestPolicies.ListGuestPoliciesRequest.newBuilder((GuestPolicies.ListGuestPoliciesRequest)payload).setPageToken(token).build();
        }

        public GuestPolicies.ListGuestPoliciesRequest injectPageSize(GuestPolicies.ListGuestPoliciesRequest payload, int pageSize) {
            return GuestPolicies.ListGuestPoliciesRequest.newBuilder((GuestPolicies.ListGuestPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(GuestPolicies.ListGuestPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(GuestPolicies.ListGuestPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GuestPolicies.GuestPolicy> extractResources(GuestPolicies.ListGuestPoliciesResponse payload) {
            return payload.getGuestPoliciesList() == null ? ImmutableList.of() : payload.getGuestPoliciesList();
        }
    };
    private static final PagedListResponseFactory<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, OsConfigServiceClient.ListPatchJobsPagedResponse> LIST_PATCH_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, OsConfigServiceClient.ListPatchJobsPagedResponse>(){

        public ApiFuture<OsConfigServiceClient.ListPatchJobsPagedResponse> getFuturePagedResponse(UnaryCallable<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse> callable, PatchJobs.ListPatchJobsRequest request, ApiCallContext context, ApiFuture<PatchJobs.ListPatchJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PATCH_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OsConfigServiceClient.ListPatchJobsPagedResponse.createAsync((PageContext<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, PatchJobs.PatchJob>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, OsConfigServiceClient.ListPatchJobInstanceDetailsPagedResponse> LIST_PATCH_JOB_INSTANCE_DETAILS_PAGE_STR_FACT = new PagedListResponseFactory<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, OsConfigServiceClient.ListPatchJobInstanceDetailsPagedResponse>(){

        public ApiFuture<OsConfigServiceClient.ListPatchJobInstanceDetailsPagedResponse> getFuturePagedResponse(UnaryCallable<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse> callable, PatchJobs.ListPatchJobInstanceDetailsRequest request, ApiCallContext context, ApiFuture<PatchJobs.ListPatchJobInstanceDetailsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PATCH_JOB_INSTANCE_DETAILS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OsConfigServiceClient.ListPatchJobInstanceDetailsPagedResponse.createAsync((PageContext<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, PatchJobs.PatchJobInstanceDetails>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, OsConfigServiceClient.ListPatchDeploymentsPagedResponse> LIST_PATCH_DEPLOYMENTS_PAGE_STR_FACT = new PagedListResponseFactory<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, OsConfigServiceClient.ListPatchDeploymentsPagedResponse>(){

        public ApiFuture<OsConfigServiceClient.ListPatchDeploymentsPagedResponse> getFuturePagedResponse(UnaryCallable<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse> callable, PatchDeployments.ListPatchDeploymentsRequest request, ApiCallContext context, ApiFuture<PatchDeployments.ListPatchDeploymentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PATCH_DEPLOYMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OsConfigServiceClient.ListPatchDeploymentsPagedResponse.createAsync((PageContext<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, PatchDeployments.PatchDeployment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<GuestPolicies.ListGuestPoliciesRequest, GuestPolicies.ListGuestPoliciesResponse, OsConfigServiceClient.ListGuestPoliciesPagedResponse> LIST_GUEST_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<GuestPolicies.ListGuestPoliciesRequest, GuestPolicies.ListGuestPoliciesResponse, OsConfigServiceClient.ListGuestPoliciesPagedResponse>(){

        public ApiFuture<OsConfigServiceClient.ListGuestPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<GuestPolicies.ListGuestPoliciesRequest, GuestPolicies.ListGuestPoliciesResponse> callable, GuestPolicies.ListGuestPoliciesRequest request, ApiCallContext context, ApiFuture<GuestPolicies.ListGuestPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GUEST_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OsConfigServiceClient.ListGuestPoliciesPagedResponse.createAsync((PageContext<GuestPolicies.ListGuestPoliciesRequest, GuestPolicies.ListGuestPoliciesResponse, GuestPolicies.GuestPolicy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<PatchJobs.ExecutePatchJobRequest, PatchJobs.PatchJob> executePatchJobSettings() {
        return this.executePatchJobSettings;
    }

    public UnaryCallSettings<PatchJobs.GetPatchJobRequest, PatchJobs.PatchJob> getPatchJobSettings() {
        return this.getPatchJobSettings;
    }

    public UnaryCallSettings<PatchJobs.CancelPatchJobRequest, PatchJobs.PatchJob> cancelPatchJobSettings() {
        return this.cancelPatchJobSettings;
    }

    public PagedCallSettings<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, OsConfigServiceClient.ListPatchJobsPagedResponse> listPatchJobsSettings() {
        return this.listPatchJobsSettings;
    }

    public PagedCallSettings<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, OsConfigServiceClient.ListPatchJobInstanceDetailsPagedResponse> listPatchJobInstanceDetailsSettings() {
        return this.listPatchJobInstanceDetailsSettings;
    }

    public UnaryCallSettings<PatchDeployments.CreatePatchDeploymentRequest, PatchDeployments.PatchDeployment> createPatchDeploymentSettings() {
        return this.createPatchDeploymentSettings;
    }

    public UnaryCallSettings<PatchDeployments.GetPatchDeploymentRequest, PatchDeployments.PatchDeployment> getPatchDeploymentSettings() {
        return this.getPatchDeploymentSettings;
    }

    public PagedCallSettings<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, OsConfigServiceClient.ListPatchDeploymentsPagedResponse> listPatchDeploymentsSettings() {
        return this.listPatchDeploymentsSettings;
    }

    public UnaryCallSettings<PatchDeployments.DeletePatchDeploymentRequest, Empty> deletePatchDeploymentSettings() {
        return this.deletePatchDeploymentSettings;
    }

    public UnaryCallSettings<PatchDeployments.UpdatePatchDeploymentRequest, PatchDeployments.PatchDeployment> updatePatchDeploymentSettings() {
        return this.updatePatchDeploymentSettings;
    }

    public UnaryCallSettings<PatchDeployments.PausePatchDeploymentRequest, PatchDeployments.PatchDeployment> pausePatchDeploymentSettings() {
        return this.pausePatchDeploymentSettings;
    }

    public UnaryCallSettings<PatchDeployments.ResumePatchDeploymentRequest, PatchDeployments.PatchDeployment> resumePatchDeploymentSettings() {
        return this.resumePatchDeploymentSettings;
    }

    public UnaryCallSettings<GuestPolicies.CreateGuestPolicyRequest, GuestPolicies.GuestPolicy> createGuestPolicySettings() {
        return this.createGuestPolicySettings;
    }

    public UnaryCallSettings<GuestPolicies.GetGuestPolicyRequest, GuestPolicies.GuestPolicy> getGuestPolicySettings() {
        return this.getGuestPolicySettings;
    }

    public PagedCallSettings<GuestPolicies.ListGuestPoliciesRequest, GuestPolicies.ListGuestPoliciesResponse, OsConfigServiceClient.ListGuestPoliciesPagedResponse> listGuestPoliciesSettings() {
        return this.listGuestPoliciesSettings;
    }

    public UnaryCallSettings<GuestPolicies.UpdateGuestPolicyRequest, GuestPolicies.GuestPolicy> updateGuestPolicySettings() {
        return this.updateGuestPolicySettings;
    }

    public UnaryCallSettings<GuestPolicies.DeleteGuestPolicyRequest, Empty> deleteGuestPolicySettings() {
        return this.deleteGuestPolicySettings;
    }

    public UnaryCallSettings<GuestPolicies.LookupEffectiveGuestPolicyRequest, GuestPolicies.EffectiveGuestPolicy> lookupEffectiveGuestPolicySettings() {
        return this.lookupEffectiveGuestPolicySettings;
    }

    public OsConfigServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcOsConfigServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonOsConfigServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return OsConfigServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "osconfig";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "osconfig.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "osconfig.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OsConfigServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OsConfigServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OsConfigServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return OsConfigServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OsConfigServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.executePatchJobSettings = settingsBuilder.executePatchJobSettings().build();
        this.getPatchJobSettings = settingsBuilder.getPatchJobSettings().build();
        this.cancelPatchJobSettings = settingsBuilder.cancelPatchJobSettings().build();
        this.listPatchJobsSettings = settingsBuilder.listPatchJobsSettings().build();
        this.listPatchJobInstanceDetailsSettings = settingsBuilder.listPatchJobInstanceDetailsSettings().build();
        this.createPatchDeploymentSettings = settingsBuilder.createPatchDeploymentSettings().build();
        this.getPatchDeploymentSettings = settingsBuilder.getPatchDeploymentSettings().build();
        this.listPatchDeploymentsSettings = settingsBuilder.listPatchDeploymentsSettings().build();
        this.deletePatchDeploymentSettings = settingsBuilder.deletePatchDeploymentSettings().build();
        this.updatePatchDeploymentSettings = settingsBuilder.updatePatchDeploymentSettings().build();
        this.pausePatchDeploymentSettings = settingsBuilder.pausePatchDeploymentSettings().build();
        this.resumePatchDeploymentSettings = settingsBuilder.resumePatchDeploymentSettings().build();
        this.createGuestPolicySettings = settingsBuilder.createGuestPolicySettings().build();
        this.getGuestPolicySettings = settingsBuilder.getGuestPolicySettings().build();
        this.listGuestPoliciesSettings = settingsBuilder.listGuestPoliciesSettings().build();
        this.updateGuestPolicySettings = settingsBuilder.updateGuestPolicySettings().build();
        this.deleteGuestPolicySettings = settingsBuilder.deleteGuestPolicySettings().build();
        this.lookupEffectiveGuestPolicySettings = settingsBuilder.lookupEffectiveGuestPolicySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OsConfigServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<PatchJobs.ExecutePatchJobRequest, PatchJobs.PatchJob> executePatchJobSettings;
        private final UnaryCallSettings.Builder<PatchJobs.GetPatchJobRequest, PatchJobs.PatchJob> getPatchJobSettings;
        private final UnaryCallSettings.Builder<PatchJobs.CancelPatchJobRequest, PatchJobs.PatchJob> cancelPatchJobSettings;
        private final PagedCallSettings.Builder<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, OsConfigServiceClient.ListPatchJobsPagedResponse> listPatchJobsSettings;
        private final PagedCallSettings.Builder<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, OsConfigServiceClient.ListPatchJobInstanceDetailsPagedResponse> listPatchJobInstanceDetailsSettings;
        private final UnaryCallSettings.Builder<PatchDeployments.CreatePatchDeploymentRequest, PatchDeployments.PatchDeployment> createPatchDeploymentSettings;
        private final UnaryCallSettings.Builder<PatchDeployments.GetPatchDeploymentRequest, PatchDeployments.PatchDeployment> getPatchDeploymentSettings;
        private final PagedCallSettings.Builder<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, OsConfigServiceClient.ListPatchDeploymentsPagedResponse> listPatchDeploymentsSettings;
        private final UnaryCallSettings.Builder<PatchDeployments.DeletePatchDeploymentRequest, Empty> deletePatchDeploymentSettings;
        private final UnaryCallSettings.Builder<PatchDeployments.UpdatePatchDeploymentRequest, PatchDeployments.PatchDeployment> updatePatchDeploymentSettings;
        private final UnaryCallSettings.Builder<PatchDeployments.PausePatchDeploymentRequest, PatchDeployments.PatchDeployment> pausePatchDeploymentSettings;
        private final UnaryCallSettings.Builder<PatchDeployments.ResumePatchDeploymentRequest, PatchDeployments.PatchDeployment> resumePatchDeploymentSettings;
        private final UnaryCallSettings.Builder<GuestPolicies.CreateGuestPolicyRequest, GuestPolicies.GuestPolicy> createGuestPolicySettings;
        private final UnaryCallSettings.Builder<GuestPolicies.GetGuestPolicyRequest, GuestPolicies.GuestPolicy> getGuestPolicySettings;
        private final PagedCallSettings.Builder<GuestPolicies.ListGuestPoliciesRequest, GuestPolicies.ListGuestPoliciesResponse, OsConfigServiceClient.ListGuestPoliciesPagedResponse> listGuestPoliciesSettings;
        private final UnaryCallSettings.Builder<GuestPolicies.UpdateGuestPolicyRequest, GuestPolicies.GuestPolicy> updateGuestPolicySettings;
        private final UnaryCallSettings.Builder<GuestPolicies.DeleteGuestPolicyRequest, Empty> deleteGuestPolicySettings;
        private final UnaryCallSettings.Builder<GuestPolicies.LookupEffectiveGuestPolicyRequest, GuestPolicies.EffectiveGuestPolicy> lookupEffectiveGuestPolicySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.executePatchJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPatchJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelPatchJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPatchJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PATCH_JOBS_PAGE_STR_FACT);
            this.listPatchJobInstanceDetailsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PATCH_JOB_INSTANCE_DETAILS_PAGE_STR_FACT);
            this.createPatchDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPatchDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPatchDeploymentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PATCH_DEPLOYMENTS_PAGE_STR_FACT);
            this.deletePatchDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePatchDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.pausePatchDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resumePatchDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGuestPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getGuestPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGuestPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GUEST_POLICIES_PAGE_STR_FACT);
            this.updateGuestPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGuestPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lookupEffectiveGuestPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.executePatchJobSettings, this.getPatchJobSettings, this.cancelPatchJobSettings, this.listPatchJobsSettings, this.listPatchJobInstanceDetailsSettings, this.createPatchDeploymentSettings, this.getPatchDeploymentSettings, this.listPatchDeploymentsSettings, this.deletePatchDeploymentSettings, this.updatePatchDeploymentSettings, this.pausePatchDeploymentSettings, this.resumePatchDeploymentSettings, (Object[])new UnaryCallSettings.Builder[]{this.createGuestPolicySettings, this.getGuestPolicySettings, this.listGuestPoliciesSettings, this.updateGuestPolicySettings, this.deleteGuestPolicySettings, this.lookupEffectiveGuestPolicySettings});
            Builder.initDefaults(this);
        }

        protected Builder(OsConfigServiceStubSettings settings) {
            super((StubSettings)settings);
            this.executePatchJobSettings = settings.executePatchJobSettings.toBuilder();
            this.getPatchJobSettings = settings.getPatchJobSettings.toBuilder();
            this.cancelPatchJobSettings = settings.cancelPatchJobSettings.toBuilder();
            this.listPatchJobsSettings = settings.listPatchJobsSettings.toBuilder();
            this.listPatchJobInstanceDetailsSettings = settings.listPatchJobInstanceDetailsSettings.toBuilder();
            this.createPatchDeploymentSettings = settings.createPatchDeploymentSettings.toBuilder();
            this.getPatchDeploymentSettings = settings.getPatchDeploymentSettings.toBuilder();
            this.listPatchDeploymentsSettings = settings.listPatchDeploymentsSettings.toBuilder();
            this.deletePatchDeploymentSettings = settings.deletePatchDeploymentSettings.toBuilder();
            this.updatePatchDeploymentSettings = settings.updatePatchDeploymentSettings.toBuilder();
            this.pausePatchDeploymentSettings = settings.pausePatchDeploymentSettings.toBuilder();
            this.resumePatchDeploymentSettings = settings.resumePatchDeploymentSettings.toBuilder();
            this.createGuestPolicySettings = settings.createGuestPolicySettings.toBuilder();
            this.getGuestPolicySettings = settings.getGuestPolicySettings.toBuilder();
            this.listGuestPoliciesSettings = settings.listGuestPoliciesSettings.toBuilder();
            this.updateGuestPolicySettings = settings.updateGuestPolicySettings.toBuilder();
            this.deleteGuestPolicySettings = settings.deleteGuestPolicySettings.toBuilder();
            this.lookupEffectiveGuestPolicySettings = settings.lookupEffectiveGuestPolicySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.executePatchJobSettings, this.getPatchJobSettings, this.cancelPatchJobSettings, this.listPatchJobsSettings, this.listPatchJobInstanceDetailsSettings, this.createPatchDeploymentSettings, this.getPatchDeploymentSettings, this.listPatchDeploymentsSettings, this.deletePatchDeploymentSettings, this.updatePatchDeploymentSettings, this.pausePatchDeploymentSettings, this.resumePatchDeploymentSettings, (Object[])new UnaryCallSettings.Builder[]{this.createGuestPolicySettings, this.getGuestPolicySettings, this.listGuestPoliciesSettings, this.updateGuestPolicySettings, this.deleteGuestPolicySettings, this.lookupEffectiveGuestPolicySettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OsConfigServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)OsConfigServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OsConfigServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OsConfigServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)OsConfigServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)OsConfigServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OsConfigServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OsConfigServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.executePatchJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPatchJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.cancelPatchJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPatchJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPatchJobInstanceDetailsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPatchDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPatchDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPatchDeploymentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePatchDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updatePatchDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.pausePatchDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.resumePatchDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createGuestPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getGuestPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listGuestPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateGuestPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteGuestPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.lookupEffectiveGuestPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<PatchJobs.ExecutePatchJobRequest, PatchJobs.PatchJob> executePatchJobSettings() {
            return this.executePatchJobSettings;
        }

        public UnaryCallSettings.Builder<PatchJobs.GetPatchJobRequest, PatchJobs.PatchJob> getPatchJobSettings() {
            return this.getPatchJobSettings;
        }

        public UnaryCallSettings.Builder<PatchJobs.CancelPatchJobRequest, PatchJobs.PatchJob> cancelPatchJobSettings() {
            return this.cancelPatchJobSettings;
        }

        public PagedCallSettings.Builder<PatchJobs.ListPatchJobsRequest, PatchJobs.ListPatchJobsResponse, OsConfigServiceClient.ListPatchJobsPagedResponse> listPatchJobsSettings() {
            return this.listPatchJobsSettings;
        }

        public PagedCallSettings.Builder<PatchJobs.ListPatchJobInstanceDetailsRequest, PatchJobs.ListPatchJobInstanceDetailsResponse, OsConfigServiceClient.ListPatchJobInstanceDetailsPagedResponse> listPatchJobInstanceDetailsSettings() {
            return this.listPatchJobInstanceDetailsSettings;
        }

        public UnaryCallSettings.Builder<PatchDeployments.CreatePatchDeploymentRequest, PatchDeployments.PatchDeployment> createPatchDeploymentSettings() {
            return this.createPatchDeploymentSettings;
        }

        public UnaryCallSettings.Builder<PatchDeployments.GetPatchDeploymentRequest, PatchDeployments.PatchDeployment> getPatchDeploymentSettings() {
            return this.getPatchDeploymentSettings;
        }

        public PagedCallSettings.Builder<PatchDeployments.ListPatchDeploymentsRequest, PatchDeployments.ListPatchDeploymentsResponse, OsConfigServiceClient.ListPatchDeploymentsPagedResponse> listPatchDeploymentsSettings() {
            return this.listPatchDeploymentsSettings;
        }

        public UnaryCallSettings.Builder<PatchDeployments.DeletePatchDeploymentRequest, Empty> deletePatchDeploymentSettings() {
            return this.deletePatchDeploymentSettings;
        }

        public UnaryCallSettings.Builder<PatchDeployments.UpdatePatchDeploymentRequest, PatchDeployments.PatchDeployment> updatePatchDeploymentSettings() {
            return this.updatePatchDeploymentSettings;
        }

        public UnaryCallSettings.Builder<PatchDeployments.PausePatchDeploymentRequest, PatchDeployments.PatchDeployment> pausePatchDeploymentSettings() {
            return this.pausePatchDeploymentSettings;
        }

        public UnaryCallSettings.Builder<PatchDeployments.ResumePatchDeploymentRequest, PatchDeployments.PatchDeployment> resumePatchDeploymentSettings() {
            return this.resumePatchDeploymentSettings;
        }

        public UnaryCallSettings.Builder<GuestPolicies.CreateGuestPolicyRequest, GuestPolicies.GuestPolicy> createGuestPolicySettings() {
            return this.createGuestPolicySettings;
        }

        public UnaryCallSettings.Builder<GuestPolicies.GetGuestPolicyRequest, GuestPolicies.GuestPolicy> getGuestPolicySettings() {
            return this.getGuestPolicySettings;
        }

        public PagedCallSettings.Builder<GuestPolicies.ListGuestPoliciesRequest, GuestPolicies.ListGuestPoliciesResponse, OsConfigServiceClient.ListGuestPoliciesPagedResponse> listGuestPoliciesSettings() {
            return this.listGuestPoliciesSettings;
        }

        public UnaryCallSettings.Builder<GuestPolicies.UpdateGuestPolicyRequest, GuestPolicies.GuestPolicy> updateGuestPolicySettings() {
            return this.updateGuestPolicySettings;
        }

        public UnaryCallSettings.Builder<GuestPolicies.DeleteGuestPolicyRequest, Empty> deleteGuestPolicySettings() {
            return this.deleteGuestPolicySettings;
        }

        public UnaryCallSettings.Builder<GuestPolicies.LookupEffectiveGuestPolicyRequest, GuestPolicies.EffectiveGuestPolicy> lookupEffectiveGuestPolicySettings() {
            return this.lookupEffectiveGuestPolicySettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return OsConfigServiceStubSettings.getDefaultEndpoint();
        }

        public OsConfigServiceStubSettings build() throws IOException {
            return new OsConfigServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

