/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orgpolicy.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.orgpolicy.v2.Constraint;
import com.google.cloud.orgpolicy.v2.CreateCustomConstraintRequest;
import com.google.cloud.orgpolicy.v2.CreatePolicyRequest;
import com.google.cloud.orgpolicy.v2.CustomConstraint;
import com.google.cloud.orgpolicy.v2.CustomConstraintName;
import com.google.cloud.orgpolicy.v2.DeleteCustomConstraintRequest;
import com.google.cloud.orgpolicy.v2.DeletePolicyRequest;
import com.google.cloud.orgpolicy.v2.FolderName;
import com.google.cloud.orgpolicy.v2.GetCustomConstraintRequest;
import com.google.cloud.orgpolicy.v2.GetEffectivePolicyRequest;
import com.google.cloud.orgpolicy.v2.GetPolicyRequest;
import com.google.cloud.orgpolicy.v2.ListConstraintsRequest;
import com.google.cloud.orgpolicy.v2.ListConstraintsResponse;
import com.google.cloud.orgpolicy.v2.ListCustomConstraintsRequest;
import com.google.cloud.orgpolicy.v2.ListCustomConstraintsResponse;
import com.google.cloud.orgpolicy.v2.ListPoliciesRequest;
import com.google.cloud.orgpolicy.v2.ListPoliciesResponse;
import com.google.cloud.orgpolicy.v2.OrgPolicySettings;
import com.google.cloud.orgpolicy.v2.OrganizationName;
import com.google.cloud.orgpolicy.v2.Policy;
import com.google.cloud.orgpolicy.v2.PolicyName;
import com.google.cloud.orgpolicy.v2.ProjectName;
import com.google.cloud.orgpolicy.v2.UpdateCustomConstraintRequest;
import com.google.cloud.orgpolicy.v2.UpdatePolicyRequest;
import com.google.cloud.orgpolicy.v2.stub.OrgPolicyStub;
import com.google.cloud.orgpolicy.v2.stub.OrgPolicyStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OrgPolicyClient
implements BackgroundResource {
    private final OrgPolicySettings settings;
    private final OrgPolicyStub stub;

    public static final OrgPolicyClient create() throws IOException {
        return OrgPolicyClient.create(OrgPolicySettings.newBuilder().build());
    }

    public static final OrgPolicyClient create(OrgPolicySettings settings) throws IOException {
        return new OrgPolicyClient(settings);
    }

    public static final OrgPolicyClient create(OrgPolicyStub stub) {
        return new OrgPolicyClient(stub);
    }

    protected OrgPolicyClient(OrgPolicySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OrgPolicyStubSettings)settings.getStubSettings()).createStub();
    }

    protected OrgPolicyClient(OrgPolicyStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final OrgPolicySettings getSettings() {
        return this.settings;
    }

    public OrgPolicyStub getStub() {
        return this.stub;
    }

    public final ListConstraintsPagedResponse listConstraints(FolderName parent) {
        ListConstraintsRequest request = ListConstraintsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConstraints(request);
    }

    public final ListConstraintsPagedResponse listConstraints(OrganizationName parent) {
        ListConstraintsRequest request = ListConstraintsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConstraints(request);
    }

    public final ListConstraintsPagedResponse listConstraints(ProjectName parent) {
        ListConstraintsRequest request = ListConstraintsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConstraints(request);
    }

    public final ListConstraintsPagedResponse listConstraints(String parent) {
        ListConstraintsRequest request = ListConstraintsRequest.newBuilder().setParent(parent).build();
        return this.listConstraints(request);
    }

    public final ListConstraintsPagedResponse listConstraints(ListConstraintsRequest request) {
        return (ListConstraintsPagedResponse)((Object)this.listConstraintsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConstraintsRequest, ListConstraintsPagedResponse> listConstraintsPagedCallable() {
        return this.stub.listConstraintsPagedCallable();
    }

    public final UnaryCallable<ListConstraintsRequest, ListConstraintsResponse> listConstraintsCallable() {
        return this.stub.listConstraintsCallable();
    }

    public final ListPoliciesPagedResponse listPolicies(FolderName parent) {
        ListPoliciesRequest request = ListPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPolicies(request);
    }

    public final ListPoliciesPagedResponse listPolicies(OrganizationName parent) {
        ListPoliciesRequest request = ListPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPolicies(request);
    }

    public final ListPoliciesPagedResponse listPolicies(ProjectName parent) {
        ListPoliciesRequest request = ListPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPolicies(request);
    }

    public final ListPoliciesPagedResponse listPolicies(String parent) {
        ListPoliciesRequest request = ListPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listPolicies(request);
    }

    public final ListPoliciesPagedResponse listPolicies(ListPoliciesRequest request) {
        return (ListPoliciesPagedResponse)((Object)this.listPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPoliciesRequest, ListPoliciesPagedResponse> listPoliciesPagedCallable() {
        return this.stub.listPoliciesPagedCallable();
    }

    public final UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> listPoliciesCallable() {
        return this.stub.listPoliciesCallable();
    }

    public final Policy getPolicy(PolicyName name) {
        GetPolicyRequest request = GetPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPolicy(request);
    }

    public final Policy getPolicy(String name) {
        GetPolicyRequest request = GetPolicyRequest.newBuilder().setName(name).build();
        return this.getPolicy(request);
    }

    public final Policy getPolicy(GetPolicyRequest request) {
        return (Policy)this.getPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetPolicyRequest, Policy> getPolicyCallable() {
        return this.stub.getPolicyCallable();
    }

    public final Policy getEffectivePolicy(PolicyName name) {
        GetEffectivePolicyRequest request = GetEffectivePolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEffectivePolicy(request);
    }

    public final Policy getEffectivePolicy(String name) {
        GetEffectivePolicyRequest request = GetEffectivePolicyRequest.newBuilder().setName(name).build();
        return this.getEffectivePolicy(request);
    }

    public final Policy getEffectivePolicy(GetEffectivePolicyRequest request) {
        return (Policy)this.getEffectivePolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetEffectivePolicyRequest, Policy> getEffectivePolicyCallable() {
        return this.stub.getEffectivePolicyCallable();
    }

    public final Policy createPolicy(FolderName parent, Policy policy) {
        CreatePolicyRequest request = CreatePolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPolicy(policy).build();
        return this.createPolicy(request);
    }

    public final Policy createPolicy(OrganizationName parent, Policy policy) {
        CreatePolicyRequest request = CreatePolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPolicy(policy).build();
        return this.createPolicy(request);
    }

    public final Policy createPolicy(ProjectName parent, Policy policy) {
        CreatePolicyRequest request = CreatePolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPolicy(policy).build();
        return this.createPolicy(request);
    }

    public final Policy createPolicy(String parent, Policy policy) {
        CreatePolicyRequest request = CreatePolicyRequest.newBuilder().setParent(parent).setPolicy(policy).build();
        return this.createPolicy(request);
    }

    public final Policy createPolicy(CreatePolicyRequest request) {
        return (Policy)this.createPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePolicyRequest, Policy> createPolicyCallable() {
        return this.stub.createPolicyCallable();
    }

    public final Policy updatePolicy(Policy policy) {
        UpdatePolicyRequest request = UpdatePolicyRequest.newBuilder().setPolicy(policy).build();
        return this.updatePolicy(request);
    }

    public final Policy updatePolicy(UpdatePolicyRequest request) {
        return (Policy)this.updatePolicyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePolicyRequest, Policy> updatePolicyCallable() {
        return this.stub.updatePolicyCallable();
    }

    public final void deletePolicy(PolicyName name) {
        DeletePolicyRequest request = DeletePolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePolicy(request);
    }

    public final void deletePolicy(String name) {
        DeletePolicyRequest request = DeletePolicyRequest.newBuilder().setName(name).build();
        this.deletePolicy(request);
    }

    public final void deletePolicy(DeletePolicyRequest request) {
        this.deletePolicyCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePolicyRequest, Empty> deletePolicyCallable() {
        return this.stub.deletePolicyCallable();
    }

    public final CustomConstraint createCustomConstraint(OrganizationName parent, CustomConstraint customConstraint) {
        CreateCustomConstraintRequest request = CreateCustomConstraintRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCustomConstraint(customConstraint).build();
        return this.createCustomConstraint(request);
    }

    public final CustomConstraint createCustomConstraint(String parent, CustomConstraint customConstraint) {
        CreateCustomConstraintRequest request = CreateCustomConstraintRequest.newBuilder().setParent(parent).setCustomConstraint(customConstraint).build();
        return this.createCustomConstraint(request);
    }

    public final CustomConstraint createCustomConstraint(CreateCustomConstraintRequest request) {
        return (CustomConstraint)this.createCustomConstraintCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCustomConstraintRequest, CustomConstraint> createCustomConstraintCallable() {
        return this.stub.createCustomConstraintCallable();
    }

    public final CustomConstraint updateCustomConstraint(CustomConstraint customConstraint) {
        UpdateCustomConstraintRequest request = UpdateCustomConstraintRequest.newBuilder().setCustomConstraint(customConstraint).build();
        return this.updateCustomConstraint(request);
    }

    public final CustomConstraint updateCustomConstraint(UpdateCustomConstraintRequest request) {
        return (CustomConstraint)this.updateCustomConstraintCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCustomConstraintRequest, CustomConstraint> updateCustomConstraintCallable() {
        return this.stub.updateCustomConstraintCallable();
    }

    public final CustomConstraint getCustomConstraint(CustomConstraintName name) {
        GetCustomConstraintRequest request = GetCustomConstraintRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCustomConstraint(request);
    }

    public final CustomConstraint getCustomConstraint(String name) {
        GetCustomConstraintRequest request = GetCustomConstraintRequest.newBuilder().setName(name).build();
        return this.getCustomConstraint(request);
    }

    public final CustomConstraint getCustomConstraint(GetCustomConstraintRequest request) {
        return (CustomConstraint)this.getCustomConstraintCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomConstraintRequest, CustomConstraint> getCustomConstraintCallable() {
        return this.stub.getCustomConstraintCallable();
    }

    public final ListCustomConstraintsPagedResponse listCustomConstraints(OrganizationName parent) {
        ListCustomConstraintsRequest request = ListCustomConstraintsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCustomConstraints(request);
    }

    public final ListCustomConstraintsPagedResponse listCustomConstraints(String parent) {
        ListCustomConstraintsRequest request = ListCustomConstraintsRequest.newBuilder().setParent(parent).build();
        return this.listCustomConstraints(request);
    }

    public final ListCustomConstraintsPagedResponse listCustomConstraints(ListCustomConstraintsRequest request) {
        return (ListCustomConstraintsPagedResponse)((Object)this.listCustomConstraintsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCustomConstraintsRequest, ListCustomConstraintsPagedResponse> listCustomConstraintsPagedCallable() {
        return this.stub.listCustomConstraintsPagedCallable();
    }

    public final UnaryCallable<ListCustomConstraintsRequest, ListCustomConstraintsResponse> listCustomConstraintsCallable() {
        return this.stub.listCustomConstraintsCallable();
    }

    public final void deleteCustomConstraint(CustomConstraintName name) {
        DeleteCustomConstraintRequest request = DeleteCustomConstraintRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteCustomConstraint(request);
    }

    public final void deleteCustomConstraint(String name) {
        DeleteCustomConstraintRequest request = DeleteCustomConstraintRequest.newBuilder().setName(name).build();
        this.deleteCustomConstraint(request);
    }

    public final void deleteCustomConstraint(DeleteCustomConstraintRequest request) {
        this.deleteCustomConstraintCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteCustomConstraintRequest, Empty> deleteCustomConstraintCallable() {
        return this.stub.deleteCustomConstraintCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCustomConstraintsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCustomConstraintsRequest, ListCustomConstraintsResponse, CustomConstraint, ListCustomConstraintsPage, ListCustomConstraintsFixedSizeCollection> {
        private ListCustomConstraintsFixedSizeCollection(List<ListCustomConstraintsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCustomConstraintsFixedSizeCollection createEmptyCollection() {
            return new ListCustomConstraintsFixedSizeCollection(null, 0);
        }

        protected ListCustomConstraintsFixedSizeCollection createCollection(List<ListCustomConstraintsPage> pages, int collectionSize) {
            return new ListCustomConstraintsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCustomConstraintsPage
    extends AbstractPage<ListCustomConstraintsRequest, ListCustomConstraintsResponse, CustomConstraint, ListCustomConstraintsPage> {
        private ListCustomConstraintsPage(PageContext<ListCustomConstraintsRequest, ListCustomConstraintsResponse, CustomConstraint> context, ListCustomConstraintsResponse response) {
            super(context, (Object)response);
        }

        private static ListCustomConstraintsPage createEmptyPage() {
            return new ListCustomConstraintsPage(null, null);
        }

        protected ListCustomConstraintsPage createPage(PageContext<ListCustomConstraintsRequest, ListCustomConstraintsResponse, CustomConstraint> context, ListCustomConstraintsResponse response) {
            return new ListCustomConstraintsPage(context, response);
        }

        public ApiFuture<ListCustomConstraintsPage> createPageAsync(PageContext<ListCustomConstraintsRequest, ListCustomConstraintsResponse, CustomConstraint> context, ApiFuture<ListCustomConstraintsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCustomConstraintsPagedResponse
    extends AbstractPagedListResponse<ListCustomConstraintsRequest, ListCustomConstraintsResponse, CustomConstraint, ListCustomConstraintsPage, ListCustomConstraintsFixedSizeCollection> {
        public static ApiFuture<ListCustomConstraintsPagedResponse> createAsync(PageContext<ListCustomConstraintsRequest, ListCustomConstraintsResponse, CustomConstraint> context, ApiFuture<ListCustomConstraintsResponse> futureResponse) {
            ApiFuture<ListCustomConstraintsPage> futurePage = ListCustomConstraintsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCustomConstraintsPagedResponse((ListCustomConstraintsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCustomConstraintsPagedResponse(ListCustomConstraintsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCustomConstraintsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPoliciesRequest, ListPoliciesResponse, Policy, ListPoliciesPage, ListPoliciesFixedSizeCollection> {
        private ListPoliciesFixedSizeCollection(List<ListPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListPoliciesFixedSizeCollection(null, 0);
        }

        protected ListPoliciesFixedSizeCollection createCollection(List<ListPoliciesPage> pages, int collectionSize) {
            return new ListPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPoliciesPage
    extends AbstractPage<ListPoliciesRequest, ListPoliciesResponse, Policy, ListPoliciesPage> {
        private ListPoliciesPage(PageContext<ListPoliciesRequest, ListPoliciesResponse, Policy> context, ListPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListPoliciesPage createEmptyPage() {
            return new ListPoliciesPage(null, null);
        }

        protected ListPoliciesPage createPage(PageContext<ListPoliciesRequest, ListPoliciesResponse, Policy> context, ListPoliciesResponse response) {
            return new ListPoliciesPage(context, response);
        }

        public ApiFuture<ListPoliciesPage> createPageAsync(PageContext<ListPoliciesRequest, ListPoliciesResponse, Policy> context, ApiFuture<ListPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPoliciesPagedResponse
    extends AbstractPagedListResponse<ListPoliciesRequest, ListPoliciesResponse, Policy, ListPoliciesPage, ListPoliciesFixedSizeCollection> {
        public static ApiFuture<ListPoliciesPagedResponse> createAsync(PageContext<ListPoliciesRequest, ListPoliciesResponse, Policy> context, ApiFuture<ListPoliciesResponse> futureResponse) {
            ApiFuture<ListPoliciesPage> futurePage = ListPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPoliciesPagedResponse((ListPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPoliciesPagedResponse(ListPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConstraintsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConstraintsRequest, ListConstraintsResponse, Constraint, ListConstraintsPage, ListConstraintsFixedSizeCollection> {
        private ListConstraintsFixedSizeCollection(List<ListConstraintsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConstraintsFixedSizeCollection createEmptyCollection() {
            return new ListConstraintsFixedSizeCollection(null, 0);
        }

        protected ListConstraintsFixedSizeCollection createCollection(List<ListConstraintsPage> pages, int collectionSize) {
            return new ListConstraintsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConstraintsPage
    extends AbstractPage<ListConstraintsRequest, ListConstraintsResponse, Constraint, ListConstraintsPage> {
        private ListConstraintsPage(PageContext<ListConstraintsRequest, ListConstraintsResponse, Constraint> context, ListConstraintsResponse response) {
            super(context, (Object)response);
        }

        private static ListConstraintsPage createEmptyPage() {
            return new ListConstraintsPage(null, null);
        }

        protected ListConstraintsPage createPage(PageContext<ListConstraintsRequest, ListConstraintsResponse, Constraint> context, ListConstraintsResponse response) {
            return new ListConstraintsPage(context, response);
        }

        public ApiFuture<ListConstraintsPage> createPageAsync(PageContext<ListConstraintsRequest, ListConstraintsResponse, Constraint> context, ApiFuture<ListConstraintsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConstraintsPagedResponse
    extends AbstractPagedListResponse<ListConstraintsRequest, ListConstraintsResponse, Constraint, ListConstraintsPage, ListConstraintsFixedSizeCollection> {
        public static ApiFuture<ListConstraintsPagedResponse> createAsync(PageContext<ListConstraintsRequest, ListConstraintsResponse, Constraint> context, ApiFuture<ListConstraintsResponse> futureResponse) {
            ApiFuture<ListConstraintsPage> futurePage = ListConstraintsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConstraintsPagedResponse((ListConstraintsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConstraintsPagedResponse(ListConstraintsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConstraintsFixedSizeCollection.createEmptyCollection());
        }
    }
}

