/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orgpolicy.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.orgpolicy.v2.Constraint;
import com.google.cloud.orgpolicy.v2.CreatePolicyRequest;
import com.google.cloud.orgpolicy.v2.DeletePolicyRequest;
import com.google.cloud.orgpolicy.v2.GetEffectivePolicyRequest;
import com.google.cloud.orgpolicy.v2.GetPolicyRequest;
import com.google.cloud.orgpolicy.v2.ListConstraintsRequest;
import com.google.cloud.orgpolicy.v2.ListConstraintsResponse;
import com.google.cloud.orgpolicy.v2.ListPoliciesRequest;
import com.google.cloud.orgpolicy.v2.ListPoliciesResponse;
import com.google.cloud.orgpolicy.v2.OrgPolicyClient;
import com.google.cloud.orgpolicy.v2.Policy;
import com.google.cloud.orgpolicy.v2.UpdatePolicyRequest;
import com.google.cloud.orgpolicy.v2.stub.GrpcOrgPolicyStub;
import com.google.cloud.orgpolicy.v2.stub.OrgPolicyStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class OrgPolicyStubSettings
extends StubSettings<OrgPolicyStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListConstraintsRequest, ListConstraintsResponse, OrgPolicyClient.ListConstraintsPagedResponse> listConstraintsSettings;
    private final PagedCallSettings<ListPoliciesRequest, ListPoliciesResponse, OrgPolicyClient.ListPoliciesPagedResponse> listPoliciesSettings;
    private final UnaryCallSettings<GetPolicyRequest, Policy> getPolicySettings;
    private final UnaryCallSettings<GetEffectivePolicyRequest, Policy> getEffectivePolicySettings;
    private final UnaryCallSettings<CreatePolicyRequest, Policy> createPolicySettings;
    private final UnaryCallSettings<UpdatePolicyRequest, Policy> updatePolicySettings;
    private final UnaryCallSettings<DeletePolicyRequest, Empty> deletePolicySettings;
    private static final PagedListDescriptor<ListConstraintsRequest, ListConstraintsResponse, Constraint> LIST_CONSTRAINTS_PAGE_STR_DESC = new PagedListDescriptor<ListConstraintsRequest, ListConstraintsResponse, Constraint>(){

        public String emptyToken() {
            return "";
        }

        public ListConstraintsRequest injectToken(ListConstraintsRequest payload, String token) {
            return ListConstraintsRequest.newBuilder((ListConstraintsRequest)payload).setPageToken(token).build();
        }

        public ListConstraintsRequest injectPageSize(ListConstraintsRequest payload, int pageSize) {
            return ListConstraintsRequest.newBuilder((ListConstraintsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConstraintsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConstraintsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Constraint> extractResources(ListConstraintsResponse payload) {
            return payload.getConstraintsList() == null ? ImmutableList.of() : payload.getConstraintsList();
        }
    };
    private static final PagedListDescriptor<ListPoliciesRequest, ListPoliciesResponse, Policy> LIST_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListPoliciesRequest, ListPoliciesResponse, Policy>(){

        public String emptyToken() {
            return "";
        }

        public ListPoliciesRequest injectToken(ListPoliciesRequest payload, String token) {
            return ListPoliciesRequest.newBuilder((ListPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListPoliciesRequest injectPageSize(ListPoliciesRequest payload, int pageSize) {
            return ListPoliciesRequest.newBuilder((ListPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Policy> extractResources(ListPoliciesResponse payload) {
            return payload.getPoliciesList() == null ? ImmutableList.of() : payload.getPoliciesList();
        }
    };
    private static final PagedListResponseFactory<ListConstraintsRequest, ListConstraintsResponse, OrgPolicyClient.ListConstraintsPagedResponse> LIST_CONSTRAINTS_PAGE_STR_FACT = new PagedListResponseFactory<ListConstraintsRequest, ListConstraintsResponse, OrgPolicyClient.ListConstraintsPagedResponse>(){

        public ApiFuture<OrgPolicyClient.ListConstraintsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConstraintsRequest, ListConstraintsResponse> callable, ListConstraintsRequest request, ApiCallContext context, ApiFuture<ListConstraintsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONSTRAINTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OrgPolicyClient.ListConstraintsPagedResponse.createAsync((PageContext<ListConstraintsRequest, ListConstraintsResponse, Constraint>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPoliciesRequest, ListPoliciesResponse, OrgPolicyClient.ListPoliciesPagedResponse> LIST_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListPoliciesRequest, ListPoliciesResponse, OrgPolicyClient.ListPoliciesPagedResponse>(){

        public ApiFuture<OrgPolicyClient.ListPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> callable, ListPoliciesRequest request, ApiCallContext context, ApiFuture<ListPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OrgPolicyClient.ListPoliciesPagedResponse.createAsync((PageContext<ListPoliciesRequest, ListPoliciesResponse, Policy>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListConstraintsRequest, ListConstraintsResponse, OrgPolicyClient.ListConstraintsPagedResponse> listConstraintsSettings() {
        return this.listConstraintsSettings;
    }

    public PagedCallSettings<ListPoliciesRequest, ListPoliciesResponse, OrgPolicyClient.ListPoliciesPagedResponse> listPoliciesSettings() {
        return this.listPoliciesSettings;
    }

    public UnaryCallSettings<GetPolicyRequest, Policy> getPolicySettings() {
        return this.getPolicySettings;
    }

    public UnaryCallSettings<GetEffectivePolicyRequest, Policy> getEffectivePolicySettings() {
        return this.getEffectivePolicySettings;
    }

    public UnaryCallSettings<CreatePolicyRequest, Policy> createPolicySettings() {
        return this.createPolicySettings;
    }

    public UnaryCallSettings<UpdatePolicyRequest, Policy> updatePolicySettings() {
        return this.updatePolicySettings;
    }

    public UnaryCallSettings<DeletePolicyRequest, Empty> deletePolicySettings() {
        return this.deletePolicySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public OrgPolicyStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcOrgPolicyStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "orgpolicy.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "orgpolicy.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OrgPolicyStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OrgPolicyStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OrgPolicyStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listConstraintsSettings = settingsBuilder.listConstraintsSettings().build();
        this.listPoliciesSettings = settingsBuilder.listPoliciesSettings().build();
        this.getPolicySettings = settingsBuilder.getPolicySettings().build();
        this.getEffectivePolicySettings = settingsBuilder.getEffectivePolicySettings().build();
        this.createPolicySettings = settingsBuilder.createPolicySettings().build();
        this.updatePolicySettings = settingsBuilder.updatePolicySettings().build();
        this.deletePolicySettings = settingsBuilder.deletePolicySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OrgPolicyStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListConstraintsRequest, ListConstraintsResponse, OrgPolicyClient.ListConstraintsPagedResponse> listConstraintsSettings;
        private final PagedCallSettings.Builder<ListPoliciesRequest, ListPoliciesResponse, OrgPolicyClient.ListPoliciesPagedResponse> listPoliciesSettings;
        private final UnaryCallSettings.Builder<GetPolicyRequest, Policy> getPolicySettings;
        private final UnaryCallSettings.Builder<GetEffectivePolicyRequest, Policy> getEffectivePolicySettings;
        private final UnaryCallSettings.Builder<CreatePolicyRequest, Policy> createPolicySettings;
        private final UnaryCallSettings.Builder<UpdatePolicyRequest, Policy> updatePolicySettings;
        private final UnaryCallSettings.Builder<DeletePolicyRequest, Empty> deletePolicySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listConstraintsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONSTRAINTS_PAGE_STR_FACT);
            this.listPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_POLICIES_PAGE_STR_FACT);
            this.getPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEffectivePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConstraintsSettings, this.listPoliciesSettings, this.getPolicySettings, this.getEffectivePolicySettings, this.createPolicySettings, this.updatePolicySettings, this.deletePolicySettings);
            Builder.initDefaults(this);
        }

        protected Builder(OrgPolicyStubSettings settings) {
            super((StubSettings)settings);
            this.listConstraintsSettings = settings.listConstraintsSettings.toBuilder();
            this.listPoliciesSettings = settings.listPoliciesSettings.toBuilder();
            this.getPolicySettings = settings.getPolicySettings.toBuilder();
            this.getEffectivePolicySettings = settings.getEffectivePolicySettings.toBuilder();
            this.createPolicySettings = settings.createPolicySettings.toBuilder();
            this.updatePolicySettings = settings.updatePolicySettings.toBuilder();
            this.deletePolicySettings = settings.deletePolicySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConstraintsSettings, this.listPoliciesSettings, this.getPolicySettings, this.getEffectivePolicySettings, this.createPolicySettings, this.updatePolicySettings, this.deletePolicySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OrgPolicyStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)OrgPolicyStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OrgPolicyStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(OrgPolicyStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(OrgPolicyStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listConstraintsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEffectivePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updatePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListConstraintsRequest, ListConstraintsResponse, OrgPolicyClient.ListConstraintsPagedResponse> listConstraintsSettings() {
            return this.listConstraintsSettings;
        }

        public PagedCallSettings.Builder<ListPoliciesRequest, ListPoliciesResponse, OrgPolicyClient.ListPoliciesPagedResponse> listPoliciesSettings() {
            return this.listPoliciesSettings;
        }

        public UnaryCallSettings.Builder<GetPolicyRequest, Policy> getPolicySettings() {
            return this.getPolicySettings;
        }

        public UnaryCallSettings.Builder<GetEffectivePolicyRequest, Policy> getEffectivePolicySettings() {
            return this.getEffectivePolicySettings;
        }

        public UnaryCallSettings.Builder<CreatePolicyRequest, Policy> createPolicySettings() {
            return this.createPolicySettings;
        }

        public UnaryCallSettings.Builder<UpdatePolicyRequest, Policy> updatePolicySettings() {
            return this.updatePolicySettings;
        }

        public UnaryCallSettings.Builder<DeletePolicyRequest, Empty> deletePolicySettings() {
            return this.deletePolicySettings;
        }

        public OrgPolicyStubSettings build() throws IOException {
            return new OrgPolicyStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

