/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orchestration.airflow.service.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.orchestration.airflow.service.v1.ImageVersion;
import com.google.cloud.orchestration.airflow.service.v1.ImageVersionsClient;
import com.google.cloud.orchestration.airflow.service.v1.ListImageVersionsRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListImageVersionsResponse;
import com.google.cloud.orchestration.airflow.service.v1.stub.GrpcImageVersionsStub;
import com.google.cloud.orchestration.airflow.service.v1.stub.HttpJsonImageVersionsStub;
import com.google.cloud.orchestration.airflow.service.v1.stub.ImageVersionsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ImageVersionsStubSettings
extends StubSettings<ImageVersionsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersionsClient.ListImageVersionsPagedResponse> listImageVersionsSettings;
    private static final PagedListDescriptor<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersion> LIST_IMAGE_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListImageVersionsRequest injectToken(ListImageVersionsRequest payload, String token) {
            return ListImageVersionsRequest.newBuilder((ListImageVersionsRequest)payload).setPageToken(token).build();
        }

        public ListImageVersionsRequest injectPageSize(ListImageVersionsRequest payload, int pageSize) {
            return ListImageVersionsRequest.newBuilder((ListImageVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListImageVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListImageVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ImageVersion> extractResources(ListImageVersionsResponse payload) {
            return payload.getImageVersionsList() == null ? ImmutableList.of() : payload.getImageVersionsList();
        }
    };
    private static final PagedListResponseFactory<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersionsClient.ListImageVersionsPagedResponse> LIST_IMAGE_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersionsClient.ListImageVersionsPagedResponse>(){

        public ApiFuture<ImageVersionsClient.ListImageVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListImageVersionsRequest, ListImageVersionsResponse> callable, ListImageVersionsRequest request, ApiCallContext context, ApiFuture<ListImageVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_IMAGE_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ImageVersionsClient.ListImageVersionsPagedResponse.createAsync((PageContext<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersion>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersionsClient.ListImageVersionsPagedResponse> listImageVersionsSettings() {
        return this.listImageVersionsSettings;
    }

    public ImageVersionsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcImageVersionsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonImageVersionsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "composer";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "composer.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "composer.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ImageVersionsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ImageVersionsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ImageVersionsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ImageVersionsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ImageVersionsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listImageVersionsSettings = settingsBuilder.listImageVersionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ImageVersionsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersionsClient.ListImageVersionsPagedResponse> listImageVersionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listImageVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_IMAGE_VERSIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listImageVersionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ImageVersionsStubSettings settings) {
            super((StubSettings)settings);
            this.listImageVersionsSettings = settings.listImageVersionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listImageVersionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ImageVersionsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ImageVersionsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ImageVersionsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ImageVersionsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ImageVersionsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ImageVersionsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ImageVersionsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ImageVersionsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listImageVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersionsClient.ListImageVersionsPagedResponse> listImageVersionsSettings() {
            return this.listImageVersionsSettings;
        }

        public ImageVersionsStubSettings build() throws IOException {
            return new ImageVersionsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

