/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orchestration.airflow.service.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.orchestration.airflow.service.v1beta1.ImageVersion;
import com.google.cloud.orchestration.airflow.service.v1beta1.ImageVersionsSettings;
import com.google.cloud.orchestration.airflow.service.v1beta1.ListImageVersionsRequest;
import com.google.cloud.orchestration.airflow.service.v1beta1.ListImageVersionsResponse;
import com.google.cloud.orchestration.airflow.service.v1beta1.stub.ImageVersionsStub;
import com.google.cloud.orchestration.airflow.service.v1beta1.stub.ImageVersionsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ImageVersionsClient
implements BackgroundResource {
    private final ImageVersionsSettings settings;
    private final ImageVersionsStub stub;

    public static final ImageVersionsClient create() throws IOException {
        return ImageVersionsClient.create(ImageVersionsSettings.newBuilder().build());
    }

    public static final ImageVersionsClient create(ImageVersionsSettings settings) throws IOException {
        return new ImageVersionsClient(settings);
    }

    public static final ImageVersionsClient create(ImageVersionsStub stub) {
        return new ImageVersionsClient(stub);
    }

    protected ImageVersionsClient(ImageVersionsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ImageVersionsStubSettings)settings.getStubSettings()).createStub();
    }

    protected ImageVersionsClient(ImageVersionsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ImageVersionsSettings getSettings() {
        return this.settings;
    }

    public ImageVersionsStub getStub() {
        return this.stub;
    }

    public final ListImageVersionsPagedResponse listImageVersions(String parent) {
        ListImageVersionsRequest request = ListImageVersionsRequest.newBuilder().setParent(parent).build();
        return this.listImageVersions(request);
    }

    public final ListImageVersionsPagedResponse listImageVersions(ListImageVersionsRequest request) {
        return (ListImageVersionsPagedResponse)((Object)this.listImageVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListImageVersionsRequest, ListImageVersionsPagedResponse> listImageVersionsPagedCallable() {
        return this.stub.listImageVersionsPagedCallable();
    }

    public final UnaryCallable<ListImageVersionsRequest, ListImageVersionsResponse> listImageVersionsCallable() {
        return this.stub.listImageVersionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListImageVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersion, ListImageVersionsPage, ListImageVersionsFixedSizeCollection> {
        private ListImageVersionsFixedSizeCollection(List<ListImageVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListImageVersionsFixedSizeCollection createEmptyCollection() {
            return new ListImageVersionsFixedSizeCollection(null, 0);
        }

        protected ListImageVersionsFixedSizeCollection createCollection(List<ListImageVersionsPage> pages, int collectionSize) {
            return new ListImageVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListImageVersionsPage
    extends AbstractPage<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersion, ListImageVersionsPage> {
        private ListImageVersionsPage(PageContext<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersion> context, ListImageVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListImageVersionsPage createEmptyPage() {
            return new ListImageVersionsPage(null, null);
        }

        protected ListImageVersionsPage createPage(PageContext<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersion> context, ListImageVersionsResponse response) {
            return new ListImageVersionsPage(context, response);
        }

        public ApiFuture<ListImageVersionsPage> createPageAsync(PageContext<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersion> context, ApiFuture<ListImageVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListImageVersionsPagedResponse
    extends AbstractPagedListResponse<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersion, ListImageVersionsPage, ListImageVersionsFixedSizeCollection> {
        public static ApiFuture<ListImageVersionsPagedResponse> createAsync(PageContext<ListImageVersionsRequest, ListImageVersionsResponse, ImageVersion> context, ApiFuture<ListImageVersionsResponse> futureResponse) {
            ApiFuture<ListImageVersionsPage> futurePage = ListImageVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListImageVersionsPagedResponse((ListImageVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListImageVersionsPagedResponse(ListImageVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListImageVersionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

