/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orchestration.airflow.service.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeRequest;
import com.google.cloud.orchestration.airflow.service.v1beta1.CheckUpgradeResponse;
import com.google.cloud.orchestration.airflow.service.v1beta1.CreateEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1beta1.DeleteEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1beta1.Environment;
import com.google.cloud.orchestration.airflow.service.v1beta1.EnvironmentsClient;
import com.google.cloud.orchestration.airflow.service.v1beta1.GetEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1beta1.ListEnvironmentsRequest;
import com.google.cloud.orchestration.airflow.service.v1beta1.ListEnvironmentsResponse;
import com.google.cloud.orchestration.airflow.service.v1beta1.OperationMetadata;
import com.google.cloud.orchestration.airflow.service.v1beta1.RestartWebServerRequest;
import com.google.cloud.orchestration.airflow.service.v1beta1.UpdateEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1beta1.stub.EnvironmentsStub;
import com.google.cloud.orchestration.airflow.service.v1beta1.stub.GrpcEnvironmentsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class EnvironmentsStubSettings
extends StubSettings<EnvironmentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateEnvironmentRequest, Operation> createEnvironmentSettings;
    private final OperationCallSettings<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings;
    private final UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings;
    private final PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
    private final UnaryCallSettings<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings;
    private final OperationCallSettings<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings;
    private final UnaryCallSettings<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings;
    private final OperationCallSettings<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings;
    private final UnaryCallSettings<RestartWebServerRequest, Operation> restartWebServerSettings;
    private final OperationCallSettings<RestartWebServerRequest, Environment, OperationMetadata> restartWebServerOperationSettings;
    private final UnaryCallSettings<CheckUpgradeRequest, Operation> checkUpgradeSettings;
    private final OperationCallSettings<CheckUpgradeRequest, CheckUpgradeResponse, OperationMetadata> checkUpgradeOperationSettings;
    private static final PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> LIST_ENVIRONMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>(){

        public String emptyToken() {
            return "";
        }

        public ListEnvironmentsRequest injectToken(ListEnvironmentsRequest payload, String token) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageToken(token).build();
        }

        public ListEnvironmentsRequest injectPageSize(ListEnvironmentsRequest payload, int pageSize) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEnvironmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEnvironmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Environment> extractResources(ListEnvironmentsResponse payload) {
            return payload.getEnvironmentsList() == null ? ImmutableList.of() : payload.getEnvironmentsList();
        }
    };
    private static final PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> LIST_ENVIRONMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse>(){

        public ApiFuture<EnvironmentsClient.ListEnvironmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> callable, ListEnvironmentsRequest request, ApiCallContext context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENVIRONMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EnvironmentsClient.ListEnvironmentsPagedResponse.createAsync((PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateEnvironmentRequest, Operation> createEnvironmentSettings() {
        return this.createEnvironmentSettings;
    }

    public OperationCallSettings<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings() {
        return this.createEnvironmentOperationSettings;
    }

    public UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
        return this.getEnvironmentSettings;
    }

    public PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
        return this.listEnvironmentsSettings;
    }

    public UnaryCallSettings<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings() {
        return this.updateEnvironmentSettings;
    }

    public OperationCallSettings<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings() {
        return this.updateEnvironmentOperationSettings;
    }

    public UnaryCallSettings<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings() {
        return this.deleteEnvironmentSettings;
    }

    public OperationCallSettings<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings() {
        return this.deleteEnvironmentOperationSettings;
    }

    public UnaryCallSettings<RestartWebServerRequest, Operation> restartWebServerSettings() {
        return this.restartWebServerSettings;
    }

    public OperationCallSettings<RestartWebServerRequest, Environment, OperationMetadata> restartWebServerOperationSettings() {
        return this.restartWebServerOperationSettings;
    }

    public UnaryCallSettings<CheckUpgradeRequest, Operation> checkUpgradeSettings() {
        return this.checkUpgradeSettings;
    }

    public OperationCallSettings<CheckUpgradeRequest, CheckUpgradeResponse, OperationMetadata> checkUpgradeOperationSettings() {
        return this.checkUpgradeOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EnvironmentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEnvironmentsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "composer.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "composer.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EnvironmentsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EnvironmentsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EnvironmentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createEnvironmentSettings = settingsBuilder.createEnvironmentSettings().build();
        this.createEnvironmentOperationSettings = settingsBuilder.createEnvironmentOperationSettings().build();
        this.getEnvironmentSettings = settingsBuilder.getEnvironmentSettings().build();
        this.listEnvironmentsSettings = settingsBuilder.listEnvironmentsSettings().build();
        this.updateEnvironmentSettings = settingsBuilder.updateEnvironmentSettings().build();
        this.updateEnvironmentOperationSettings = settingsBuilder.updateEnvironmentOperationSettings().build();
        this.deleteEnvironmentSettings = settingsBuilder.deleteEnvironmentSettings().build();
        this.deleteEnvironmentOperationSettings = settingsBuilder.deleteEnvironmentOperationSettings().build();
        this.restartWebServerSettings = settingsBuilder.restartWebServerSettings().build();
        this.restartWebServerOperationSettings = settingsBuilder.restartWebServerOperationSettings().build();
        this.checkUpgradeSettings = settingsBuilder.checkUpgradeSettings().build();
        this.checkUpgradeOperationSettings = settingsBuilder.checkUpgradeOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EnvironmentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateEnvironmentRequest, Operation> createEnvironmentSettings;
        private final OperationCallSettings.Builder<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings;
        private final PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
        private final UnaryCallSettings.Builder<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings;
        private final OperationCallSettings.Builder<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings;
        private final OperationCallSettings.Builder<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<RestartWebServerRequest, Operation> restartWebServerSettings;
        private final OperationCallSettings.Builder<RestartWebServerRequest, Environment, OperationMetadata> restartWebServerOperationSettings;
        private final UnaryCallSettings.Builder<CheckUpgradeRequest, Operation> checkUpgradeSettings;
        private final OperationCallSettings.Builder<CheckUpgradeRequest, CheckUpgradeResponse, OperationMetadata> checkUpgradeOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.getEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEnvironmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENVIRONMENTS_PAGE_STR_FACT);
            this.updateEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.restartWebServerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restartWebServerOperationSettings = OperationCallSettings.newBuilder();
            this.checkUpgradeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.checkUpgradeOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEnvironmentSettings, this.getEnvironmentSettings, this.listEnvironmentsSettings, this.updateEnvironmentSettings, this.deleteEnvironmentSettings, this.restartWebServerSettings, this.checkUpgradeSettings);
            Builder.initDefaults(this);
        }

        protected Builder(EnvironmentsStubSettings settings) {
            super((StubSettings)settings);
            this.createEnvironmentSettings = settings.createEnvironmentSettings.toBuilder();
            this.createEnvironmentOperationSettings = settings.createEnvironmentOperationSettings.toBuilder();
            this.getEnvironmentSettings = settings.getEnvironmentSettings.toBuilder();
            this.listEnvironmentsSettings = settings.listEnvironmentsSettings.toBuilder();
            this.updateEnvironmentSettings = settings.updateEnvironmentSettings.toBuilder();
            this.updateEnvironmentOperationSettings = settings.updateEnvironmentOperationSettings.toBuilder();
            this.deleteEnvironmentSettings = settings.deleteEnvironmentSettings.toBuilder();
            this.deleteEnvironmentOperationSettings = settings.deleteEnvironmentOperationSettings.toBuilder();
            this.restartWebServerSettings = settings.restartWebServerSettings.toBuilder();
            this.restartWebServerOperationSettings = settings.restartWebServerOperationSettings.toBuilder();
            this.checkUpgradeSettings = settings.checkUpgradeSettings.toBuilder();
            this.checkUpgradeOperationSettings = settings.checkUpgradeOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEnvironmentSettings, this.getEnvironmentSettings, this.listEnvironmentsSettings, this.updateEnvironmentSettings, this.deleteEnvironmentSettings, this.restartWebServerSettings, this.checkUpgradeSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EnvironmentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EnvironmentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EnvironmentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(EnvironmentsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(EnvironmentsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listEnvironmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.restartWebServerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.checkUpgradeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Environment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Environment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.restartWebServerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Environment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.checkUpgradeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CheckUpgradeResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateEnvironmentRequest, Operation> createEnvironmentSettings() {
            return this.createEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings() {
            return this.createEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
            return this.getEnvironmentSettings;
        }

        public PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
            return this.listEnvironmentsSettings;
        }

        public UnaryCallSettings.Builder<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings() {
            return this.updateEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationSettings() {
            return this.updateEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings() {
            return this.deleteEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings() {
            return this.deleteEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<RestartWebServerRequest, Operation> restartWebServerSettings() {
            return this.restartWebServerSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestartWebServerRequest, Environment, OperationMetadata> restartWebServerOperationSettings() {
            return this.restartWebServerOperationSettings;
        }

        public UnaryCallSettings.Builder<CheckUpgradeRequest, Operation> checkUpgradeSettings() {
            return this.checkUpgradeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CheckUpgradeRequest, CheckUpgradeResponse, OperationMetadata> checkUpgradeOperationSettings() {
            return this.checkUpgradeOperationSettings;
        }

        public EnvironmentsStubSettings build() throws IOException {
            return new EnvironmentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

