/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.notification;

import com.google.api.services.storage.model.Notification;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.pubsub.v1.TopicName;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NotificationInfo
implements Serializable {
    private static final long serialVersionUID = 5725883368559753810L;
    static final Function<Notification, NotificationInfo> FROM_PB_FUNCTION = new Function<Notification, NotificationInfo>(){

        public NotificationInfo apply(Notification pb) {
            return NotificationInfo.fromPb(pb);
        }
    };
    static final Function<NotificationInfo, Notification> TO_PB_FUNCTION = new Function<NotificationInfo, Notification>(){

        public Notification apply(NotificationInfo NotificationInfo2) {
            return NotificationInfo2.toPb();
        }
    };
    private final String generatedId;
    private final TopicName topic;
    private final List<String> eventTypes;
    private final Map<String, String> customAttributes;
    private final PayloadFormat payloadFormat;
    private final String objectNamePrefix;
    private final String etag;
    private final String selfLink;

    NotificationInfo(Builder builder) {
        this.generatedId = builder.generatedId;
        this.etag = builder.etag;
        this.selfLink = builder.selfLink;
        this.topic = builder.topic;
        this.eventTypes = builder.eventTypes;
        this.customAttributes = builder.customAttributes;
        this.payloadFormat = builder.payloadFormat;
        this.objectNamePrefix = builder.objectNamePrefix;
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public TopicName getTopic() {
        return this.topic;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public PayloadFormat getPayloadFormat() {
        return this.payloadFormat;
    }

    public String getObjectNamePrefix() {
        return this.objectNamePrefix;
    }

    public String getEtag() {
        return this.etag;
    }

    public List<String> getEventTypes() {
        return this.eventTypes;
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return Objects.hash(this.getTopic());
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(NotificationInfo.class) && Objects.equals(this.toPb(), ((NotificationInfo)obj).toPb());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.getTopic()).toString();
    }

    Notification toPb() {
        Notification notificationPb = new Notification();
        notificationPb.setId(this.generatedId);
        notificationPb.setEtag(this.etag);
        if (this.customAttributes != null) {
            notificationPb.setCustomAttributes(this.customAttributes);
        }
        if (this.eventTypes != null) {
            notificationPb.setEventTypes(this.eventTypes);
        }
        if (this.objectNamePrefix != null) {
            notificationPb.setObjectNamePrefix(this.objectNamePrefix);
        }
        if (this.payloadFormat != null) {
            notificationPb.setPayloadFormat(this.payloadFormat.toString());
        } else {
            notificationPb.setPayloadFormat(PayloadFormat.NONE.toString());
        }
        notificationPb.setSelfLink(this.selfLink);
        notificationPb.setTopic(this.topic.toString());
        return notificationPb;
    }

    public static NotificationInfo of(TopicName topic) {
        return NotificationInfo.newBuilder(topic).build();
    }

    public static Builder newBuilder(TopicName topic) {
        return new Builder(topic);
    }

    static NotificationInfo fromPb(Notification notificationPb) {
        Builder builder = NotificationInfo.newBuilder(TopicName.parse((String)notificationPb.getTopic()));
        if (notificationPb.getId() != null) {
            builder.setGeneratedId(notificationPb.getId());
        }
        if (notificationPb.getEtag() != null) {
            builder.setEtag(notificationPb.getEtag());
        }
        if (notificationPb.getCustomAttributes() != null) {
            builder.setCustomAttributes(notificationPb.getCustomAttributes());
        }
        if (notificationPb.getSelfLink() != null) {
            builder.setSelfLink(notificationPb.getSelfLink());
        }
        if (notificationPb.getObjectNamePrefix() != null) {
            builder.setObjectNamePrefix(notificationPb.getObjectNamePrefix());
        }
        if (notificationPb.getTopic() != null) {
            builder.setTopic(TopicName.parse((String)notificationPb.getTopic()));
        }
        if (notificationPb.getEventTypes() != null) {
            builder.setEventTypes(notificationPb.getEventTypes());
        }
        if (notificationPb.getPayloadFormat() != null) {
            builder.setPayloadFormat(PayloadFormat.valueOf(notificationPb.getPayloadFormat()));
        }
        return builder.build();
    }

    public static final class Builder {
        private String generatedId;
        private TopicName topic;
        private List<String> eventTypes;
        private Map<String, String> customAttributes;
        private PayloadFormat payloadFormat;
        private String objectNamePrefix;
        private String etag;
        private String selfLink;

        Builder(TopicName topic) {
            this.topic = topic;
        }

        Builder(NotificationInfo NotificationInfo2) {
            this.generatedId = NotificationInfo2.generatedId;
            this.etag = NotificationInfo2.etag;
            this.selfLink = NotificationInfo2.selfLink;
            this.topic = NotificationInfo2.topic;
            this.eventTypes = NotificationInfo2.eventTypes;
            this.customAttributes = NotificationInfo2.customAttributes;
            this.payloadFormat = NotificationInfo2.payloadFormat;
            this.objectNamePrefix = NotificationInfo2.objectNamePrefix;
        }

        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Builder setTopic(TopicName topic) {
            this.topic = topic;
            return this;
        }

        public Builder setPayloadFormat(PayloadFormat payloadFormat) {
            this.payloadFormat = payloadFormat;
            return this;
        }

        public Builder setObjectNamePrefix(String objectNamePrefix) {
            this.objectNamePrefix = objectNamePrefix;
            return this;
        }

        public Builder setEventTypes(Iterable<String> eventTypes) {
            this.eventTypes = eventTypes != null ? ImmutableList.copyOf(eventTypes) : null;
            return this;
        }

        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder setCustomAttributes(Map<String, String> customAttributes) {
            this.customAttributes = customAttributes != null ? ImmutableMap.copyOf(customAttributes) : null;
            return this;
        }

        public NotificationInfo build() {
            Preconditions.checkNotNull((Object)this.topic);
            return new NotificationInfo(this);
        }
    }

    public static enum PayloadFormat {
        JSON_API_V1,
        NONE;

    }
}

