/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.notification;

import com.google.api.core.ApiClock;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.BaseService;
import com.google.cloud.RetryHelper;
import com.google.cloud.notification.Notification;
import com.google.cloud.notification.NotificationInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.Callable;

public class NotificationImpl
implements Notification {
    private final Storage storage;

    private NotificationImpl(Storage storage) {
        this.storage = storage;
    }

    @Override
    public Notification create(Storage storage) {
        return new NotificationImpl(storage);
    }

    @Override
    public boolean deleteNotification(final String bucket, final String notification) {
        try {
            return (Boolean)RetryHelper.runWithRetries((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return ((StorageRpc)((StorageOptions)NotificationImpl.this.storage.getOptions()).getRpc()).deleteNotification(bucket, notification);
                }
            }, (RetrySettings)((StorageOptions)this.storage.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BaseService.EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.storage.getOptions()).getClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow((RetryHelper.RetryHelperException)e);
        }
    }

    @Override
    public List<NotificationInfo> listNotifications(final String bucket) {
        try {
            List answer = (List)RetryHelper.runWithRetries((Callable)new Callable<List<com.google.api.services.storage.model.Notification>>(){

                @Override
                public List<com.google.api.services.storage.model.Notification> call() {
                    return ((StorageRpc)((StorageOptions)NotificationImpl.this.storage.getOptions()).getRpc()).listNotifications(bucket);
                }
            }, (RetrySettings)((StorageOptions)this.storage.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BaseService.EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.storage.getOptions()).getClock());
            if (answer == null) {
                return null;
            }
            return Lists.transform((List)answer, NotificationInfo.FROM_PB_FUNCTION);
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow((RetryHelper.RetryHelperException)e);
        }
    }

    @Override
    public NotificationInfo createNotification(final String bucket, NotificationInfo notification) {
        final com.google.api.services.storage.model.Notification notificationPb = notification.toPb();
        try {
            return NotificationInfo.fromPb((com.google.api.services.storage.model.Notification)RetryHelper.runWithRetries((Callable)new Callable<com.google.api.services.storage.model.Notification>(){

                @Override
                public com.google.api.services.storage.model.Notification call() {
                    return ((StorageRpc)((StorageOptions)NotificationImpl.this.storage.getOptions()).getRpc()).createNotification(bucket, notificationPb);
                }
            }, (RetrySettings)((StorageOptions)this.storage.getOptions()).getRetrySettings(), (ResultRetryAlgorithm)BaseService.EXCEPTION_HANDLER, (ApiClock)((StorageOptions)this.storage.getOptions()).getClock()));
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow((RetryHelper.RetryHelperException)e);
        }
    }

    public static class DefaultNotificationFactory {
        public Notification create(Storage storage) {
            return new NotificationImpl(storage);
        }
    }
}

