/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.notebooks.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.notebooks.v1.CreateRuntimeRequest;
import com.google.cloud.notebooks.v1.DeleteRuntimeRequest;
import com.google.cloud.notebooks.v1.DiagnoseRuntimeRequest;
import com.google.cloud.notebooks.v1.GetRuntimeRequest;
import com.google.cloud.notebooks.v1.ListRuntimesRequest;
import com.google.cloud.notebooks.v1.ListRuntimesResponse;
import com.google.cloud.notebooks.v1.ManagedNotebookServiceClient;
import com.google.cloud.notebooks.v1.OperationMetadata;
import com.google.cloud.notebooks.v1.RefreshRuntimeTokenInternalRequest;
import com.google.cloud.notebooks.v1.RefreshRuntimeTokenInternalResponse;
import com.google.cloud.notebooks.v1.ReportRuntimeEventRequest;
import com.google.cloud.notebooks.v1.ResetRuntimeRequest;
import com.google.cloud.notebooks.v1.Runtime;
import com.google.cloud.notebooks.v1.StartRuntimeRequest;
import com.google.cloud.notebooks.v1.StopRuntimeRequest;
import com.google.cloud.notebooks.v1.SwitchRuntimeRequest;
import com.google.cloud.notebooks.v1.UpdateRuntimeRequest;
import com.google.cloud.notebooks.v1.UpgradeRuntimeRequest;
import com.google.cloud.notebooks.v1.stub.GrpcManagedNotebookServiceCallableFactory;
import com.google.cloud.notebooks.v1.stub.ManagedNotebookServiceStub;
import com.google.cloud.notebooks.v1.stub.ManagedNotebookServiceStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcManagedNotebookServiceStub
extends ManagedNotebookServiceStub {
    private static final MethodDescriptor<ListRuntimesRequest, ListRuntimesResponse> listRuntimesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/ListRuntimes").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRuntimesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRuntimesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRuntimeRequest, Runtime> getRuntimeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/GetRuntime").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRuntimeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Runtime.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateRuntimeRequest, Operation> createRuntimeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/CreateRuntime").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateRuntimeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateRuntimeRequest, Operation> updateRuntimeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/UpdateRuntime").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateRuntimeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteRuntimeRequest, Operation> deleteRuntimeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/DeleteRuntime").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteRuntimeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StartRuntimeRequest, Operation> startRuntimeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/StartRuntime").setRequestMarshaller(ProtoUtils.marshaller((Message)StartRuntimeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StopRuntimeRequest, Operation> stopRuntimeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/StopRuntime").setRequestMarshaller(ProtoUtils.marshaller((Message)StopRuntimeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<SwitchRuntimeRequest, Operation> switchRuntimeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/SwitchRuntime").setRequestMarshaller(ProtoUtils.marshaller((Message)SwitchRuntimeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ResetRuntimeRequest, Operation> resetRuntimeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/ResetRuntime").setRequestMarshaller(ProtoUtils.marshaller((Message)ResetRuntimeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpgradeRuntimeRequest, Operation> upgradeRuntimeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/UpgradeRuntime").setRequestMarshaller(ProtoUtils.marshaller((Message)UpgradeRuntimeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ReportRuntimeEventRequest, Operation> reportRuntimeEventMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/ReportRuntimeEvent").setRequestMarshaller(ProtoUtils.marshaller((Message)ReportRuntimeEventRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RefreshRuntimeTokenInternalRequest, RefreshRuntimeTokenInternalResponse> refreshRuntimeTokenInternalMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/RefreshRuntimeTokenInternal").setRequestMarshaller(ProtoUtils.marshaller((Message)RefreshRuntimeTokenInternalRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RefreshRuntimeTokenInternalResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DiagnoseRuntimeRequest, Operation> diagnoseRuntimeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.notebooks.v1.ManagedNotebookService/DiagnoseRuntime").setRequestMarshaller(ProtoUtils.marshaller((Message)DiagnoseRuntimeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListRuntimesRequest, ListRuntimesResponse> listRuntimesCallable;
    private final UnaryCallable<ListRuntimesRequest, ManagedNotebookServiceClient.ListRuntimesPagedResponse> listRuntimesPagedCallable;
    private final UnaryCallable<GetRuntimeRequest, Runtime> getRuntimeCallable;
    private final UnaryCallable<CreateRuntimeRequest, Operation> createRuntimeCallable;
    private final OperationCallable<CreateRuntimeRequest, Runtime, OperationMetadata> createRuntimeOperationCallable;
    private final UnaryCallable<UpdateRuntimeRequest, Operation> updateRuntimeCallable;
    private final OperationCallable<UpdateRuntimeRequest, Runtime, OperationMetadata> updateRuntimeOperationCallable;
    private final UnaryCallable<DeleteRuntimeRequest, Operation> deleteRuntimeCallable;
    private final OperationCallable<DeleteRuntimeRequest, Empty, OperationMetadata> deleteRuntimeOperationCallable;
    private final UnaryCallable<StartRuntimeRequest, Operation> startRuntimeCallable;
    private final OperationCallable<StartRuntimeRequest, Runtime, OperationMetadata> startRuntimeOperationCallable;
    private final UnaryCallable<StopRuntimeRequest, Operation> stopRuntimeCallable;
    private final OperationCallable<StopRuntimeRequest, Runtime, OperationMetadata> stopRuntimeOperationCallable;
    private final UnaryCallable<SwitchRuntimeRequest, Operation> switchRuntimeCallable;
    private final OperationCallable<SwitchRuntimeRequest, Runtime, OperationMetadata> switchRuntimeOperationCallable;
    private final UnaryCallable<ResetRuntimeRequest, Operation> resetRuntimeCallable;
    private final OperationCallable<ResetRuntimeRequest, Runtime, OperationMetadata> resetRuntimeOperationCallable;
    private final UnaryCallable<UpgradeRuntimeRequest, Operation> upgradeRuntimeCallable;
    private final OperationCallable<UpgradeRuntimeRequest, Runtime, OperationMetadata> upgradeRuntimeOperationCallable;
    private final UnaryCallable<ReportRuntimeEventRequest, Operation> reportRuntimeEventCallable;
    private final OperationCallable<ReportRuntimeEventRequest, Runtime, OperationMetadata> reportRuntimeEventOperationCallable;
    private final UnaryCallable<RefreshRuntimeTokenInternalRequest, RefreshRuntimeTokenInternalResponse> refreshRuntimeTokenInternalCallable;
    private final UnaryCallable<DiagnoseRuntimeRequest, Operation> diagnoseRuntimeCallable;
    private final OperationCallable<DiagnoseRuntimeRequest, Runtime, OperationMetadata> diagnoseRuntimeOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ManagedNotebookServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcManagedNotebookServiceStub create(ManagedNotebookServiceStubSettings settings) throws IOException {
        return new GrpcManagedNotebookServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcManagedNotebookServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcManagedNotebookServiceStub(ManagedNotebookServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcManagedNotebookServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcManagedNotebookServiceStub(ManagedNotebookServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcManagedNotebookServiceStub(ManagedNotebookServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcManagedNotebookServiceCallableFactory());
    }

    protected GrpcManagedNotebookServiceStub(ManagedNotebookServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listRuntimesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRuntimesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getRuntimeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRuntimeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createRuntimeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createRuntimeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateRuntimeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateRuntimeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("runtime.name", String.valueOf(request.getRuntime().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteRuntimeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteRuntimeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings startRuntimeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startRuntimeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings stopRuntimeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(stopRuntimeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings switchRuntimeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(switchRuntimeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings resetRuntimeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resetRuntimeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings upgradeRuntimeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(upgradeRuntimeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings reportRuntimeEventTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(reportRuntimeEventMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings refreshRuntimeTokenInternalTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(refreshRuntimeTokenInternalMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings diagnoseRuntimeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(diagnoseRuntimeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.listRuntimesCallable = callableFactory.createUnaryCallable(listRuntimesTransportSettings, settings.listRuntimesSettings(), clientContext);
        this.listRuntimesPagedCallable = callableFactory.createPagedCallable(listRuntimesTransportSettings, settings.listRuntimesSettings(), clientContext);
        this.getRuntimeCallable = callableFactory.createUnaryCallable(getRuntimeTransportSettings, settings.getRuntimeSettings(), clientContext);
        this.createRuntimeCallable = callableFactory.createUnaryCallable(createRuntimeTransportSettings, settings.createRuntimeSettings(), clientContext);
        this.createRuntimeOperationCallable = callableFactory.createOperationCallable(createRuntimeTransportSettings, settings.createRuntimeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateRuntimeCallable = callableFactory.createUnaryCallable(updateRuntimeTransportSettings, settings.updateRuntimeSettings(), clientContext);
        this.updateRuntimeOperationCallable = callableFactory.createOperationCallable(updateRuntimeTransportSettings, settings.updateRuntimeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteRuntimeCallable = callableFactory.createUnaryCallable(deleteRuntimeTransportSettings, settings.deleteRuntimeSettings(), clientContext);
        this.deleteRuntimeOperationCallable = callableFactory.createOperationCallable(deleteRuntimeTransportSettings, settings.deleteRuntimeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.startRuntimeCallable = callableFactory.createUnaryCallable(startRuntimeTransportSettings, settings.startRuntimeSettings(), clientContext);
        this.startRuntimeOperationCallable = callableFactory.createOperationCallable(startRuntimeTransportSettings, settings.startRuntimeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.stopRuntimeCallable = callableFactory.createUnaryCallable(stopRuntimeTransportSettings, settings.stopRuntimeSettings(), clientContext);
        this.stopRuntimeOperationCallable = callableFactory.createOperationCallable(stopRuntimeTransportSettings, settings.stopRuntimeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.switchRuntimeCallable = callableFactory.createUnaryCallable(switchRuntimeTransportSettings, settings.switchRuntimeSettings(), clientContext);
        this.switchRuntimeOperationCallable = callableFactory.createOperationCallable(switchRuntimeTransportSettings, settings.switchRuntimeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.resetRuntimeCallable = callableFactory.createUnaryCallable(resetRuntimeTransportSettings, settings.resetRuntimeSettings(), clientContext);
        this.resetRuntimeOperationCallable = callableFactory.createOperationCallable(resetRuntimeTransportSettings, settings.resetRuntimeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.upgradeRuntimeCallable = callableFactory.createUnaryCallable(upgradeRuntimeTransportSettings, settings.upgradeRuntimeSettings(), clientContext);
        this.upgradeRuntimeOperationCallable = callableFactory.createOperationCallable(upgradeRuntimeTransportSettings, settings.upgradeRuntimeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.reportRuntimeEventCallable = callableFactory.createUnaryCallable(reportRuntimeEventTransportSettings, settings.reportRuntimeEventSettings(), clientContext);
        this.reportRuntimeEventOperationCallable = callableFactory.createOperationCallable(reportRuntimeEventTransportSettings, settings.reportRuntimeEventOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.refreshRuntimeTokenInternalCallable = callableFactory.createUnaryCallable(refreshRuntimeTokenInternalTransportSettings, settings.refreshRuntimeTokenInternalSettings(), clientContext);
        this.diagnoseRuntimeCallable = callableFactory.createUnaryCallable(diagnoseRuntimeTransportSettings, settings.diagnoseRuntimeSettings(), clientContext);
        this.diagnoseRuntimeOperationCallable = callableFactory.createOperationCallable(diagnoseRuntimeTransportSettings, settings.diagnoseRuntimeOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListRuntimesRequest, ListRuntimesResponse> listRuntimesCallable() {
        return this.listRuntimesCallable;
    }

    @Override
    public UnaryCallable<ListRuntimesRequest, ManagedNotebookServiceClient.ListRuntimesPagedResponse> listRuntimesPagedCallable() {
        return this.listRuntimesPagedCallable;
    }

    @Override
    public UnaryCallable<GetRuntimeRequest, Runtime> getRuntimeCallable() {
        return this.getRuntimeCallable;
    }

    @Override
    public UnaryCallable<CreateRuntimeRequest, Operation> createRuntimeCallable() {
        return this.createRuntimeCallable;
    }

    @Override
    public OperationCallable<CreateRuntimeRequest, Runtime, OperationMetadata> createRuntimeOperationCallable() {
        return this.createRuntimeOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateRuntimeRequest, Operation> updateRuntimeCallable() {
        return this.updateRuntimeCallable;
    }

    @Override
    public OperationCallable<UpdateRuntimeRequest, Runtime, OperationMetadata> updateRuntimeOperationCallable() {
        return this.updateRuntimeOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteRuntimeRequest, Operation> deleteRuntimeCallable() {
        return this.deleteRuntimeCallable;
    }

    @Override
    public OperationCallable<DeleteRuntimeRequest, Empty, OperationMetadata> deleteRuntimeOperationCallable() {
        return this.deleteRuntimeOperationCallable;
    }

    @Override
    public UnaryCallable<StartRuntimeRequest, Operation> startRuntimeCallable() {
        return this.startRuntimeCallable;
    }

    @Override
    public OperationCallable<StartRuntimeRequest, Runtime, OperationMetadata> startRuntimeOperationCallable() {
        return this.startRuntimeOperationCallable;
    }

    @Override
    public UnaryCallable<StopRuntimeRequest, Operation> stopRuntimeCallable() {
        return this.stopRuntimeCallable;
    }

    @Override
    public OperationCallable<StopRuntimeRequest, Runtime, OperationMetadata> stopRuntimeOperationCallable() {
        return this.stopRuntimeOperationCallable;
    }

    @Override
    public UnaryCallable<SwitchRuntimeRequest, Operation> switchRuntimeCallable() {
        return this.switchRuntimeCallable;
    }

    @Override
    public OperationCallable<SwitchRuntimeRequest, Runtime, OperationMetadata> switchRuntimeOperationCallable() {
        return this.switchRuntimeOperationCallable;
    }

    @Override
    public UnaryCallable<ResetRuntimeRequest, Operation> resetRuntimeCallable() {
        return this.resetRuntimeCallable;
    }

    @Override
    public OperationCallable<ResetRuntimeRequest, Runtime, OperationMetadata> resetRuntimeOperationCallable() {
        return this.resetRuntimeOperationCallable;
    }

    @Override
    public UnaryCallable<UpgradeRuntimeRequest, Operation> upgradeRuntimeCallable() {
        return this.upgradeRuntimeCallable;
    }

    @Override
    public OperationCallable<UpgradeRuntimeRequest, Runtime, OperationMetadata> upgradeRuntimeOperationCallable() {
        return this.upgradeRuntimeOperationCallable;
    }

    @Override
    public UnaryCallable<ReportRuntimeEventRequest, Operation> reportRuntimeEventCallable() {
        return this.reportRuntimeEventCallable;
    }

    @Override
    public OperationCallable<ReportRuntimeEventRequest, Runtime, OperationMetadata> reportRuntimeEventOperationCallable() {
        return this.reportRuntimeEventOperationCallable;
    }

    @Override
    public UnaryCallable<RefreshRuntimeTokenInternalRequest, RefreshRuntimeTokenInternalResponse> refreshRuntimeTokenInternalCallable() {
        return this.refreshRuntimeTokenInternalCallable;
    }

    @Override
    public UnaryCallable<DiagnoseRuntimeRequest, Operation> diagnoseRuntimeCallable() {
        return this.diagnoseRuntimeCallable;
    }

    @Override
    public OperationCallable<DiagnoseRuntimeRequest, Runtime, OperationMetadata> diagnoseRuntimeOperationCallable() {
        return this.diagnoseRuntimeOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ManagedNotebookServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

