/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkservices.v1.CreateLbRouteExtensionRequest;
import com.google.cloud.networkservices.v1.CreateLbTrafficExtensionRequest;
import com.google.cloud.networkservices.v1.DeleteLbRouteExtensionRequest;
import com.google.cloud.networkservices.v1.DeleteLbTrafficExtensionRequest;
import com.google.cloud.networkservices.v1.DepServiceClient;
import com.google.cloud.networkservices.v1.GetLbRouteExtensionRequest;
import com.google.cloud.networkservices.v1.GetLbTrafficExtensionRequest;
import com.google.cloud.networkservices.v1.LbRouteExtension;
import com.google.cloud.networkservices.v1.LbTrafficExtension;
import com.google.cloud.networkservices.v1.ListLbRouteExtensionsRequest;
import com.google.cloud.networkservices.v1.ListLbRouteExtensionsResponse;
import com.google.cloud.networkservices.v1.ListLbTrafficExtensionsRequest;
import com.google.cloud.networkservices.v1.ListLbTrafficExtensionsResponse;
import com.google.cloud.networkservices.v1.OperationMetadata;
import com.google.cloud.networkservices.v1.UpdateLbRouteExtensionRequest;
import com.google.cloud.networkservices.v1.UpdateLbTrafficExtensionRequest;
import com.google.cloud.networkservices.v1.stub.DepServiceStub;
import com.google.cloud.networkservices.v1.stub.GrpcDepServiceStub;
import com.google.cloud.networkservices.v1.stub.HttpJsonDepServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DepServiceStubSettings
extends StubSettings<DepServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, DepServiceClient.ListLbTrafficExtensionsPagedResponse> listLbTrafficExtensionsSettings;
    private final UnaryCallSettings<GetLbTrafficExtensionRequest, LbTrafficExtension> getLbTrafficExtensionSettings;
    private final UnaryCallSettings<CreateLbTrafficExtensionRequest, Operation> createLbTrafficExtensionSettings;
    private final OperationCallSettings<CreateLbTrafficExtensionRequest, LbTrafficExtension, OperationMetadata> createLbTrafficExtensionOperationSettings;
    private final UnaryCallSettings<UpdateLbTrafficExtensionRequest, Operation> updateLbTrafficExtensionSettings;
    private final OperationCallSettings<UpdateLbTrafficExtensionRequest, LbTrafficExtension, OperationMetadata> updateLbTrafficExtensionOperationSettings;
    private final UnaryCallSettings<DeleteLbTrafficExtensionRequest, Operation> deleteLbTrafficExtensionSettings;
    private final OperationCallSettings<DeleteLbTrafficExtensionRequest, Empty, OperationMetadata> deleteLbTrafficExtensionOperationSettings;
    private final PagedCallSettings<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, DepServiceClient.ListLbRouteExtensionsPagedResponse> listLbRouteExtensionsSettings;
    private final UnaryCallSettings<GetLbRouteExtensionRequest, LbRouteExtension> getLbRouteExtensionSettings;
    private final UnaryCallSettings<CreateLbRouteExtensionRequest, Operation> createLbRouteExtensionSettings;
    private final OperationCallSettings<CreateLbRouteExtensionRequest, LbRouteExtension, OperationMetadata> createLbRouteExtensionOperationSettings;
    private final UnaryCallSettings<UpdateLbRouteExtensionRequest, Operation> updateLbRouteExtensionSettings;
    private final OperationCallSettings<UpdateLbRouteExtensionRequest, LbRouteExtension, OperationMetadata> updateLbRouteExtensionOperationSettings;
    private final UnaryCallSettings<DeleteLbRouteExtensionRequest, Operation> deleteLbRouteExtensionSettings;
    private final OperationCallSettings<DeleteLbRouteExtensionRequest, Empty, OperationMetadata> deleteLbRouteExtensionOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DepServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, LbTrafficExtension> LIST_LB_TRAFFIC_EXTENSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, LbTrafficExtension>(){

        public String emptyToken() {
            return "";
        }

        public ListLbTrafficExtensionsRequest injectToken(ListLbTrafficExtensionsRequest payload, String token) {
            return ListLbTrafficExtensionsRequest.newBuilder((ListLbTrafficExtensionsRequest)payload).setPageToken(token).build();
        }

        public ListLbTrafficExtensionsRequest injectPageSize(ListLbTrafficExtensionsRequest payload, int pageSize) {
            return ListLbTrafficExtensionsRequest.newBuilder((ListLbTrafficExtensionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLbTrafficExtensionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLbTrafficExtensionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LbTrafficExtension> extractResources(ListLbTrafficExtensionsResponse payload) {
            return payload.getLbTrafficExtensionsList();
        }
    };
    private static final PagedListDescriptor<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, LbRouteExtension> LIST_LB_ROUTE_EXTENSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, LbRouteExtension>(){

        public String emptyToken() {
            return "";
        }

        public ListLbRouteExtensionsRequest injectToken(ListLbRouteExtensionsRequest payload, String token) {
            return ListLbRouteExtensionsRequest.newBuilder((ListLbRouteExtensionsRequest)payload).setPageToken(token).build();
        }

        public ListLbRouteExtensionsRequest injectPageSize(ListLbRouteExtensionsRequest payload, int pageSize) {
            return ListLbRouteExtensionsRequest.newBuilder((ListLbRouteExtensionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLbRouteExtensionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLbRouteExtensionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LbRouteExtension> extractResources(ListLbRouteExtensionsResponse payload) {
            return payload.getLbRouteExtensionsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, DepServiceClient.ListLbTrafficExtensionsPagedResponse> LIST_LB_TRAFFIC_EXTENSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, DepServiceClient.ListLbTrafficExtensionsPagedResponse>(){

        public ApiFuture<DepServiceClient.ListLbTrafficExtensionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse> callable, ListLbTrafficExtensionsRequest request, ApiCallContext context, ApiFuture<ListLbTrafficExtensionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LB_TRAFFIC_EXTENSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DepServiceClient.ListLbTrafficExtensionsPagedResponse.createAsync((PageContext<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, LbTrafficExtension>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, DepServiceClient.ListLbRouteExtensionsPagedResponse> LIST_LB_ROUTE_EXTENSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, DepServiceClient.ListLbRouteExtensionsPagedResponse>(){

        public ApiFuture<DepServiceClient.ListLbRouteExtensionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse> callable, ListLbRouteExtensionsRequest request, ApiCallContext context, ApiFuture<ListLbRouteExtensionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LB_ROUTE_EXTENSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DepServiceClient.ListLbRouteExtensionsPagedResponse.createAsync((PageContext<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, LbRouteExtension>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DepServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DepServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DepServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DepServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, DepServiceClient.ListLbTrafficExtensionsPagedResponse> listLbTrafficExtensionsSettings() {
        return this.listLbTrafficExtensionsSettings;
    }

    public UnaryCallSettings<GetLbTrafficExtensionRequest, LbTrafficExtension> getLbTrafficExtensionSettings() {
        return this.getLbTrafficExtensionSettings;
    }

    public UnaryCallSettings<CreateLbTrafficExtensionRequest, Operation> createLbTrafficExtensionSettings() {
        return this.createLbTrafficExtensionSettings;
    }

    public OperationCallSettings<CreateLbTrafficExtensionRequest, LbTrafficExtension, OperationMetadata> createLbTrafficExtensionOperationSettings() {
        return this.createLbTrafficExtensionOperationSettings;
    }

    public UnaryCallSettings<UpdateLbTrafficExtensionRequest, Operation> updateLbTrafficExtensionSettings() {
        return this.updateLbTrafficExtensionSettings;
    }

    public OperationCallSettings<UpdateLbTrafficExtensionRequest, LbTrafficExtension, OperationMetadata> updateLbTrafficExtensionOperationSettings() {
        return this.updateLbTrafficExtensionOperationSettings;
    }

    public UnaryCallSettings<DeleteLbTrafficExtensionRequest, Operation> deleteLbTrafficExtensionSettings() {
        return this.deleteLbTrafficExtensionSettings;
    }

    public OperationCallSettings<DeleteLbTrafficExtensionRequest, Empty, OperationMetadata> deleteLbTrafficExtensionOperationSettings() {
        return this.deleteLbTrafficExtensionOperationSettings;
    }

    public PagedCallSettings<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, DepServiceClient.ListLbRouteExtensionsPagedResponse> listLbRouteExtensionsSettings() {
        return this.listLbRouteExtensionsSettings;
    }

    public UnaryCallSettings<GetLbRouteExtensionRequest, LbRouteExtension> getLbRouteExtensionSettings() {
        return this.getLbRouteExtensionSettings;
    }

    public UnaryCallSettings<CreateLbRouteExtensionRequest, Operation> createLbRouteExtensionSettings() {
        return this.createLbRouteExtensionSettings;
    }

    public OperationCallSettings<CreateLbRouteExtensionRequest, LbRouteExtension, OperationMetadata> createLbRouteExtensionOperationSettings() {
        return this.createLbRouteExtensionOperationSettings;
    }

    public UnaryCallSettings<UpdateLbRouteExtensionRequest, Operation> updateLbRouteExtensionSettings() {
        return this.updateLbRouteExtensionSettings;
    }

    public OperationCallSettings<UpdateLbRouteExtensionRequest, LbRouteExtension, OperationMetadata> updateLbRouteExtensionOperationSettings() {
        return this.updateLbRouteExtensionOperationSettings;
    }

    public UnaryCallSettings<DeleteLbRouteExtensionRequest, Operation> deleteLbRouteExtensionSettings() {
        return this.deleteLbRouteExtensionSettings;
    }

    public OperationCallSettings<DeleteLbRouteExtensionRequest, Empty, OperationMetadata> deleteLbRouteExtensionOperationSettings() {
        return this.deleteLbRouteExtensionOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DepServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public DepServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDepServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDepServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "networkservices";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "networkservices.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "networkservices.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DepServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DepServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DepServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DepServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DepServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listLbTrafficExtensionsSettings = settingsBuilder.listLbTrafficExtensionsSettings().build();
        this.getLbTrafficExtensionSettings = settingsBuilder.getLbTrafficExtensionSettings().build();
        this.createLbTrafficExtensionSettings = settingsBuilder.createLbTrafficExtensionSettings().build();
        this.createLbTrafficExtensionOperationSettings = settingsBuilder.createLbTrafficExtensionOperationSettings().build();
        this.updateLbTrafficExtensionSettings = settingsBuilder.updateLbTrafficExtensionSettings().build();
        this.updateLbTrafficExtensionOperationSettings = settingsBuilder.updateLbTrafficExtensionOperationSettings().build();
        this.deleteLbTrafficExtensionSettings = settingsBuilder.deleteLbTrafficExtensionSettings().build();
        this.deleteLbTrafficExtensionOperationSettings = settingsBuilder.deleteLbTrafficExtensionOperationSettings().build();
        this.listLbRouteExtensionsSettings = settingsBuilder.listLbRouteExtensionsSettings().build();
        this.getLbRouteExtensionSettings = settingsBuilder.getLbRouteExtensionSettings().build();
        this.createLbRouteExtensionSettings = settingsBuilder.createLbRouteExtensionSettings().build();
        this.createLbRouteExtensionOperationSettings = settingsBuilder.createLbRouteExtensionOperationSettings().build();
        this.updateLbRouteExtensionSettings = settingsBuilder.updateLbRouteExtensionSettings().build();
        this.updateLbRouteExtensionOperationSettings = settingsBuilder.updateLbRouteExtensionOperationSettings().build();
        this.deleteLbRouteExtensionSettings = settingsBuilder.deleteLbRouteExtensionSettings().build();
        this.deleteLbRouteExtensionOperationSettings = settingsBuilder.deleteLbRouteExtensionOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DepServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, DepServiceClient.ListLbTrafficExtensionsPagedResponse> listLbTrafficExtensionsSettings;
        private final UnaryCallSettings.Builder<GetLbTrafficExtensionRequest, LbTrafficExtension> getLbTrafficExtensionSettings;
        private final UnaryCallSettings.Builder<CreateLbTrafficExtensionRequest, Operation> createLbTrafficExtensionSettings;
        private final OperationCallSettings.Builder<CreateLbTrafficExtensionRequest, LbTrafficExtension, OperationMetadata> createLbTrafficExtensionOperationSettings;
        private final UnaryCallSettings.Builder<UpdateLbTrafficExtensionRequest, Operation> updateLbTrafficExtensionSettings;
        private final OperationCallSettings.Builder<UpdateLbTrafficExtensionRequest, LbTrafficExtension, OperationMetadata> updateLbTrafficExtensionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteLbTrafficExtensionRequest, Operation> deleteLbTrafficExtensionSettings;
        private final OperationCallSettings.Builder<DeleteLbTrafficExtensionRequest, Empty, OperationMetadata> deleteLbTrafficExtensionOperationSettings;
        private final PagedCallSettings.Builder<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, DepServiceClient.ListLbRouteExtensionsPagedResponse> listLbRouteExtensionsSettings;
        private final UnaryCallSettings.Builder<GetLbRouteExtensionRequest, LbRouteExtension> getLbRouteExtensionSettings;
        private final UnaryCallSettings.Builder<CreateLbRouteExtensionRequest, Operation> createLbRouteExtensionSettings;
        private final OperationCallSettings.Builder<CreateLbRouteExtensionRequest, LbRouteExtension, OperationMetadata> createLbRouteExtensionOperationSettings;
        private final UnaryCallSettings.Builder<UpdateLbRouteExtensionRequest, Operation> updateLbRouteExtensionSettings;
        private final OperationCallSettings.Builder<UpdateLbRouteExtensionRequest, LbRouteExtension, OperationMetadata> updateLbRouteExtensionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteLbRouteExtensionRequest, Operation> deleteLbRouteExtensionSettings;
        private final OperationCallSettings.Builder<DeleteLbRouteExtensionRequest, Empty, OperationMetadata> deleteLbRouteExtensionOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DepServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listLbTrafficExtensionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LB_TRAFFIC_EXTENSIONS_PAGE_STR_FACT);
            this.getLbTrafficExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createLbTrafficExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createLbTrafficExtensionOperationSettings = OperationCallSettings.newBuilder();
            this.updateLbTrafficExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateLbTrafficExtensionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteLbTrafficExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteLbTrafficExtensionOperationSettings = OperationCallSettings.newBuilder();
            this.listLbRouteExtensionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LB_ROUTE_EXTENSIONS_PAGE_STR_FACT);
            this.getLbRouteExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createLbRouteExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createLbRouteExtensionOperationSettings = OperationCallSettings.newBuilder();
            this.updateLbRouteExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateLbRouteExtensionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteLbRouteExtensionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteLbRouteExtensionOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listLbTrafficExtensionsSettings, this.getLbTrafficExtensionSettings, this.createLbTrafficExtensionSettings, this.updateLbTrafficExtensionSettings, this.deleteLbTrafficExtensionSettings, this.listLbRouteExtensionsSettings, this.getLbRouteExtensionSettings, this.createLbRouteExtensionSettings, this.updateLbRouteExtensionSettings, this.deleteLbRouteExtensionSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DepServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listLbTrafficExtensionsSettings = settings.listLbTrafficExtensionsSettings.toBuilder();
            this.getLbTrafficExtensionSettings = settings.getLbTrafficExtensionSettings.toBuilder();
            this.createLbTrafficExtensionSettings = settings.createLbTrafficExtensionSettings.toBuilder();
            this.createLbTrafficExtensionOperationSettings = settings.createLbTrafficExtensionOperationSettings.toBuilder();
            this.updateLbTrafficExtensionSettings = settings.updateLbTrafficExtensionSettings.toBuilder();
            this.updateLbTrafficExtensionOperationSettings = settings.updateLbTrafficExtensionOperationSettings.toBuilder();
            this.deleteLbTrafficExtensionSettings = settings.deleteLbTrafficExtensionSettings.toBuilder();
            this.deleteLbTrafficExtensionOperationSettings = settings.deleteLbTrafficExtensionOperationSettings.toBuilder();
            this.listLbRouteExtensionsSettings = settings.listLbRouteExtensionsSettings.toBuilder();
            this.getLbRouteExtensionSettings = settings.getLbRouteExtensionSettings.toBuilder();
            this.createLbRouteExtensionSettings = settings.createLbRouteExtensionSettings.toBuilder();
            this.createLbRouteExtensionOperationSettings = settings.createLbRouteExtensionOperationSettings.toBuilder();
            this.updateLbRouteExtensionSettings = settings.updateLbRouteExtensionSettings.toBuilder();
            this.updateLbRouteExtensionOperationSettings = settings.updateLbRouteExtensionOperationSettings.toBuilder();
            this.deleteLbRouteExtensionSettings = settings.deleteLbRouteExtensionSettings.toBuilder();
            this.deleteLbRouteExtensionOperationSettings = settings.deleteLbRouteExtensionOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listLbTrafficExtensionsSettings, this.getLbTrafficExtensionSettings, this.createLbTrafficExtensionSettings, this.updateLbTrafficExtensionSettings, this.deleteLbTrafficExtensionSettings, this.listLbRouteExtensionsSettings, this.getLbRouteExtensionSettings, this.createLbRouteExtensionSettings, this.updateLbRouteExtensionSettings, this.deleteLbRouteExtensionSettings, this.listLocationsSettings, this.getLocationSettings, (Object[])new UnaryCallSettings.Builder[]{this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DepServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DepServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DepServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DepServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DepServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DepServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DepServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DepServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listLbTrafficExtensionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getLbTrafficExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createLbTrafficExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateLbTrafficExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteLbTrafficExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listLbRouteExtensionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getLbRouteExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createLbRouteExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateLbRouteExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteLbRouteExtensionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createLbTrafficExtensionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(LbTrafficExtension.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateLbTrafficExtensionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(LbTrafficExtension.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteLbTrafficExtensionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createLbRouteExtensionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(LbRouteExtension.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateLbRouteExtensionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(LbRouteExtension.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteLbRouteExtensionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListLbTrafficExtensionsRequest, ListLbTrafficExtensionsResponse, DepServiceClient.ListLbTrafficExtensionsPagedResponse> listLbTrafficExtensionsSettings() {
            return this.listLbTrafficExtensionsSettings;
        }

        public UnaryCallSettings.Builder<GetLbTrafficExtensionRequest, LbTrafficExtension> getLbTrafficExtensionSettings() {
            return this.getLbTrafficExtensionSettings;
        }

        public UnaryCallSettings.Builder<CreateLbTrafficExtensionRequest, Operation> createLbTrafficExtensionSettings() {
            return this.createLbTrafficExtensionSettings;
        }

        public OperationCallSettings.Builder<CreateLbTrafficExtensionRequest, LbTrafficExtension, OperationMetadata> createLbTrafficExtensionOperationSettings() {
            return this.createLbTrafficExtensionOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateLbTrafficExtensionRequest, Operation> updateLbTrafficExtensionSettings() {
            return this.updateLbTrafficExtensionSettings;
        }

        public OperationCallSettings.Builder<UpdateLbTrafficExtensionRequest, LbTrafficExtension, OperationMetadata> updateLbTrafficExtensionOperationSettings() {
            return this.updateLbTrafficExtensionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteLbTrafficExtensionRequest, Operation> deleteLbTrafficExtensionSettings() {
            return this.deleteLbTrafficExtensionSettings;
        }

        public OperationCallSettings.Builder<DeleteLbTrafficExtensionRequest, Empty, OperationMetadata> deleteLbTrafficExtensionOperationSettings() {
            return this.deleteLbTrafficExtensionOperationSettings;
        }

        public PagedCallSettings.Builder<ListLbRouteExtensionsRequest, ListLbRouteExtensionsResponse, DepServiceClient.ListLbRouteExtensionsPagedResponse> listLbRouteExtensionsSettings() {
            return this.listLbRouteExtensionsSettings;
        }

        public UnaryCallSettings.Builder<GetLbRouteExtensionRequest, LbRouteExtension> getLbRouteExtensionSettings() {
            return this.getLbRouteExtensionSettings;
        }

        public UnaryCallSettings.Builder<CreateLbRouteExtensionRequest, Operation> createLbRouteExtensionSettings() {
            return this.createLbRouteExtensionSettings;
        }

        public OperationCallSettings.Builder<CreateLbRouteExtensionRequest, LbRouteExtension, OperationMetadata> createLbRouteExtensionOperationSettings() {
            return this.createLbRouteExtensionOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateLbRouteExtensionRequest, Operation> updateLbRouteExtensionSettings() {
            return this.updateLbRouteExtensionSettings;
        }

        public OperationCallSettings.Builder<UpdateLbRouteExtensionRequest, LbRouteExtension, OperationMetadata> updateLbRouteExtensionOperationSettings() {
            return this.updateLbRouteExtensionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteLbRouteExtensionRequest, Operation> deleteLbRouteExtensionSettings() {
            return this.deleteLbRouteExtensionSettings;
        }

        public OperationCallSettings.Builder<DeleteLbRouteExtensionRequest, Empty, OperationMetadata> deleteLbRouteExtensionOperationSettings() {
            return this.deleteLbRouteExtensionOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DepServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public DepServiceStubSettings build() throws IOException {
            return new DepServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

