/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkconnectivity.v1.CreateDestinationRequest;
import com.google.cloud.networkconnectivity.v1.CreateMulticloudDataTransferConfigRequest;
import com.google.cloud.networkconnectivity.v1.DataTransferServiceClient;
import com.google.cloud.networkconnectivity.v1.DeleteDestinationRequest;
import com.google.cloud.networkconnectivity.v1.DeleteMulticloudDataTransferConfigRequest;
import com.google.cloud.networkconnectivity.v1.Destination;
import com.google.cloud.networkconnectivity.v1.GetDestinationRequest;
import com.google.cloud.networkconnectivity.v1.GetMulticloudDataTransferConfigRequest;
import com.google.cloud.networkconnectivity.v1.GetMulticloudDataTransferSupportedServiceRequest;
import com.google.cloud.networkconnectivity.v1.ListDestinationsRequest;
import com.google.cloud.networkconnectivity.v1.ListDestinationsResponse;
import com.google.cloud.networkconnectivity.v1.ListMulticloudDataTransferConfigsRequest;
import com.google.cloud.networkconnectivity.v1.ListMulticloudDataTransferConfigsResponse;
import com.google.cloud.networkconnectivity.v1.ListMulticloudDataTransferSupportedServicesRequest;
import com.google.cloud.networkconnectivity.v1.ListMulticloudDataTransferSupportedServicesResponse;
import com.google.cloud.networkconnectivity.v1.MulticloudDataTransferConfig;
import com.google.cloud.networkconnectivity.v1.MulticloudDataTransferSupportedService;
import com.google.cloud.networkconnectivity.v1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1.UpdateDestinationRequest;
import com.google.cloud.networkconnectivity.v1.UpdateMulticloudDataTransferConfigRequest;
import com.google.cloud.networkconnectivity.v1.stub.DataTransferServiceStub;
import com.google.cloud.networkconnectivity.v1.stub.GrpcDataTransferServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DataTransferServiceStubSettings
extends StubSettings<DataTransferServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, DataTransferServiceClient.ListMulticloudDataTransferConfigsPagedResponse> listMulticloudDataTransferConfigsSettings;
    private final UnaryCallSettings<GetMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig> getMulticloudDataTransferConfigSettings;
    private final UnaryCallSettings<CreateMulticloudDataTransferConfigRequest, Operation> createMulticloudDataTransferConfigSettings;
    private final OperationCallSettings<CreateMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig, OperationMetadata> createMulticloudDataTransferConfigOperationSettings;
    private final UnaryCallSettings<UpdateMulticloudDataTransferConfigRequest, Operation> updateMulticloudDataTransferConfigSettings;
    private final OperationCallSettings<UpdateMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig, OperationMetadata> updateMulticloudDataTransferConfigOperationSettings;
    private final UnaryCallSettings<DeleteMulticloudDataTransferConfigRequest, Operation> deleteMulticloudDataTransferConfigSettings;
    private final OperationCallSettings<DeleteMulticloudDataTransferConfigRequest, Empty, OperationMetadata> deleteMulticloudDataTransferConfigOperationSettings;
    private final PagedCallSettings<ListDestinationsRequest, ListDestinationsResponse, DataTransferServiceClient.ListDestinationsPagedResponse> listDestinationsSettings;
    private final UnaryCallSettings<GetDestinationRequest, Destination> getDestinationSettings;
    private final UnaryCallSettings<CreateDestinationRequest, Operation> createDestinationSettings;
    private final OperationCallSettings<CreateDestinationRequest, Destination, OperationMetadata> createDestinationOperationSettings;
    private final UnaryCallSettings<UpdateDestinationRequest, Operation> updateDestinationSettings;
    private final OperationCallSettings<UpdateDestinationRequest, Destination, OperationMetadata> updateDestinationOperationSettings;
    private final UnaryCallSettings<DeleteDestinationRequest, Operation> deleteDestinationSettings;
    private final OperationCallSettings<DeleteDestinationRequest, Empty, OperationMetadata> deleteDestinationOperationSettings;
    private final UnaryCallSettings<GetMulticloudDataTransferSupportedServiceRequest, MulticloudDataTransferSupportedService> getMulticloudDataTransferSupportedServiceSettings;
    private final PagedCallSettings<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, DataTransferServiceClient.ListMulticloudDataTransferSupportedServicesPagedResponse> listMulticloudDataTransferSupportedServicesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, MulticloudDataTransferConfig> LIST_MULTICLOUD_DATA_TRANSFER_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, MulticloudDataTransferConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListMulticloudDataTransferConfigsRequest injectToken(ListMulticloudDataTransferConfigsRequest payload, String token) {
            return ListMulticloudDataTransferConfigsRequest.newBuilder((ListMulticloudDataTransferConfigsRequest)payload).setPageToken(token).build();
        }

        public ListMulticloudDataTransferConfigsRequest injectPageSize(ListMulticloudDataTransferConfigsRequest payload, int pageSize) {
            return ListMulticloudDataTransferConfigsRequest.newBuilder((ListMulticloudDataTransferConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMulticloudDataTransferConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMulticloudDataTransferConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MulticloudDataTransferConfig> extractResources(ListMulticloudDataTransferConfigsResponse payload) {
            return payload.getMulticloudDataTransferConfigsList();
        }
    };
    private static final PagedListDescriptor<ListDestinationsRequest, ListDestinationsResponse, Destination> LIST_DESTINATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListDestinationsRequest, ListDestinationsResponse, Destination>(){

        public String emptyToken() {
            return "";
        }

        public ListDestinationsRequest injectToken(ListDestinationsRequest payload, String token) {
            return ListDestinationsRequest.newBuilder((ListDestinationsRequest)payload).setPageToken(token).build();
        }

        public ListDestinationsRequest injectPageSize(ListDestinationsRequest payload, int pageSize) {
            return ListDestinationsRequest.newBuilder((ListDestinationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDestinationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDestinationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Destination> extractResources(ListDestinationsResponse payload) {
            return payload.getDestinationsList();
        }
    };
    private static final PagedListDescriptor<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, MulticloudDataTransferSupportedService> LIST_MULTICLOUD_DATA_TRANSFER_SUPPORTED_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, MulticloudDataTransferSupportedService>(){

        public String emptyToken() {
            return "";
        }

        public ListMulticloudDataTransferSupportedServicesRequest injectToken(ListMulticloudDataTransferSupportedServicesRequest payload, String token) {
            return ListMulticloudDataTransferSupportedServicesRequest.newBuilder((ListMulticloudDataTransferSupportedServicesRequest)payload).setPageToken(token).build();
        }

        public ListMulticloudDataTransferSupportedServicesRequest injectPageSize(ListMulticloudDataTransferSupportedServicesRequest payload, int pageSize) {
            return ListMulticloudDataTransferSupportedServicesRequest.newBuilder((ListMulticloudDataTransferSupportedServicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMulticloudDataTransferSupportedServicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMulticloudDataTransferSupportedServicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MulticloudDataTransferSupportedService> extractResources(ListMulticloudDataTransferSupportedServicesResponse payload) {
            return payload.getMulticloudDataTransferSupportedServicesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, DataTransferServiceClient.ListMulticloudDataTransferConfigsPagedResponse> LIST_MULTICLOUD_DATA_TRANSFER_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, DataTransferServiceClient.ListMulticloudDataTransferConfigsPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListMulticloudDataTransferConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse> callable, ListMulticloudDataTransferConfigsRequest request, ApiCallContext context, ApiFuture<ListMulticloudDataTransferConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MULTICLOUD_DATA_TRANSFER_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListMulticloudDataTransferConfigsPagedResponse.createAsync((PageContext<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, MulticloudDataTransferConfig>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDestinationsRequest, ListDestinationsResponse, DataTransferServiceClient.ListDestinationsPagedResponse> LIST_DESTINATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListDestinationsRequest, ListDestinationsResponse, DataTransferServiceClient.ListDestinationsPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListDestinationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDestinationsRequest, ListDestinationsResponse> callable, ListDestinationsRequest request, ApiCallContext context, ApiFuture<ListDestinationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DESTINATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListDestinationsPagedResponse.createAsync((PageContext<ListDestinationsRequest, ListDestinationsResponse, Destination>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, DataTransferServiceClient.ListMulticloudDataTransferSupportedServicesPagedResponse> LIST_MULTICLOUD_DATA_TRANSFER_SUPPORTED_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, DataTransferServiceClient.ListMulticloudDataTransferSupportedServicesPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListMulticloudDataTransferSupportedServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse> callable, ListMulticloudDataTransferSupportedServicesRequest request, ApiCallContext context, ApiFuture<ListMulticloudDataTransferSupportedServicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MULTICLOUD_DATA_TRANSFER_SUPPORTED_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListMulticloudDataTransferSupportedServicesPagedResponse.createAsync((PageContext<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, MulticloudDataTransferSupportedService>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, DataTransferServiceClient.ListMulticloudDataTransferConfigsPagedResponse> listMulticloudDataTransferConfigsSettings() {
        return this.listMulticloudDataTransferConfigsSettings;
    }

    public UnaryCallSettings<GetMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig> getMulticloudDataTransferConfigSettings() {
        return this.getMulticloudDataTransferConfigSettings;
    }

    public UnaryCallSettings<CreateMulticloudDataTransferConfigRequest, Operation> createMulticloudDataTransferConfigSettings() {
        return this.createMulticloudDataTransferConfigSettings;
    }

    public OperationCallSettings<CreateMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig, OperationMetadata> createMulticloudDataTransferConfigOperationSettings() {
        return this.createMulticloudDataTransferConfigOperationSettings;
    }

    public UnaryCallSettings<UpdateMulticloudDataTransferConfigRequest, Operation> updateMulticloudDataTransferConfigSettings() {
        return this.updateMulticloudDataTransferConfigSettings;
    }

    public OperationCallSettings<UpdateMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig, OperationMetadata> updateMulticloudDataTransferConfigOperationSettings() {
        return this.updateMulticloudDataTransferConfigOperationSettings;
    }

    public UnaryCallSettings<DeleteMulticloudDataTransferConfigRequest, Operation> deleteMulticloudDataTransferConfigSettings() {
        return this.deleteMulticloudDataTransferConfigSettings;
    }

    public OperationCallSettings<DeleteMulticloudDataTransferConfigRequest, Empty, OperationMetadata> deleteMulticloudDataTransferConfigOperationSettings() {
        return this.deleteMulticloudDataTransferConfigOperationSettings;
    }

    public PagedCallSettings<ListDestinationsRequest, ListDestinationsResponse, DataTransferServiceClient.ListDestinationsPagedResponse> listDestinationsSettings() {
        return this.listDestinationsSettings;
    }

    public UnaryCallSettings<GetDestinationRequest, Destination> getDestinationSettings() {
        return this.getDestinationSettings;
    }

    public UnaryCallSettings<CreateDestinationRequest, Operation> createDestinationSettings() {
        return this.createDestinationSettings;
    }

    public OperationCallSettings<CreateDestinationRequest, Destination, OperationMetadata> createDestinationOperationSettings() {
        return this.createDestinationOperationSettings;
    }

    public UnaryCallSettings<UpdateDestinationRequest, Operation> updateDestinationSettings() {
        return this.updateDestinationSettings;
    }

    public OperationCallSettings<UpdateDestinationRequest, Destination, OperationMetadata> updateDestinationOperationSettings() {
        return this.updateDestinationOperationSettings;
    }

    public UnaryCallSettings<DeleteDestinationRequest, Operation> deleteDestinationSettings() {
        return this.deleteDestinationSettings;
    }

    public OperationCallSettings<DeleteDestinationRequest, Empty, OperationMetadata> deleteDestinationOperationSettings() {
        return this.deleteDestinationOperationSettings;
    }

    public UnaryCallSettings<GetMulticloudDataTransferSupportedServiceRequest, MulticloudDataTransferSupportedService> getMulticloudDataTransferSupportedServiceSettings() {
        return this.getMulticloudDataTransferSupportedServiceSettings;
    }

    public PagedCallSettings<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, DataTransferServiceClient.ListMulticloudDataTransferSupportedServicesPagedResponse> listMulticloudDataTransferSupportedServicesSettings() {
        return this.listMulticloudDataTransferSupportedServicesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public DataTransferServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataTransferServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "networkconnectivity";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "networkconnectivity.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "networkconnectivity.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataTransferServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataTransferServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataTransferServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listMulticloudDataTransferConfigsSettings = settingsBuilder.listMulticloudDataTransferConfigsSettings().build();
        this.getMulticloudDataTransferConfigSettings = settingsBuilder.getMulticloudDataTransferConfigSettings().build();
        this.createMulticloudDataTransferConfigSettings = settingsBuilder.createMulticloudDataTransferConfigSettings().build();
        this.createMulticloudDataTransferConfigOperationSettings = settingsBuilder.createMulticloudDataTransferConfigOperationSettings().build();
        this.updateMulticloudDataTransferConfigSettings = settingsBuilder.updateMulticloudDataTransferConfigSettings().build();
        this.updateMulticloudDataTransferConfigOperationSettings = settingsBuilder.updateMulticloudDataTransferConfigOperationSettings().build();
        this.deleteMulticloudDataTransferConfigSettings = settingsBuilder.deleteMulticloudDataTransferConfigSettings().build();
        this.deleteMulticloudDataTransferConfigOperationSettings = settingsBuilder.deleteMulticloudDataTransferConfigOperationSettings().build();
        this.listDestinationsSettings = settingsBuilder.listDestinationsSettings().build();
        this.getDestinationSettings = settingsBuilder.getDestinationSettings().build();
        this.createDestinationSettings = settingsBuilder.createDestinationSettings().build();
        this.createDestinationOperationSettings = settingsBuilder.createDestinationOperationSettings().build();
        this.updateDestinationSettings = settingsBuilder.updateDestinationSettings().build();
        this.updateDestinationOperationSettings = settingsBuilder.updateDestinationOperationSettings().build();
        this.deleteDestinationSettings = settingsBuilder.deleteDestinationSettings().build();
        this.deleteDestinationOperationSettings = settingsBuilder.deleteDestinationOperationSettings().build();
        this.getMulticloudDataTransferSupportedServiceSettings = settingsBuilder.getMulticloudDataTransferSupportedServiceSettings().build();
        this.listMulticloudDataTransferSupportedServicesSettings = settingsBuilder.listMulticloudDataTransferSupportedServicesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataTransferServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, DataTransferServiceClient.ListMulticloudDataTransferConfigsPagedResponse> listMulticloudDataTransferConfigsSettings;
        private final UnaryCallSettings.Builder<GetMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig> getMulticloudDataTransferConfigSettings;
        private final UnaryCallSettings.Builder<CreateMulticloudDataTransferConfigRequest, Operation> createMulticloudDataTransferConfigSettings;
        private final OperationCallSettings.Builder<CreateMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig, OperationMetadata> createMulticloudDataTransferConfigOperationSettings;
        private final UnaryCallSettings.Builder<UpdateMulticloudDataTransferConfigRequest, Operation> updateMulticloudDataTransferConfigSettings;
        private final OperationCallSettings.Builder<UpdateMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig, OperationMetadata> updateMulticloudDataTransferConfigOperationSettings;
        private final UnaryCallSettings.Builder<DeleteMulticloudDataTransferConfigRequest, Operation> deleteMulticloudDataTransferConfigSettings;
        private final OperationCallSettings.Builder<DeleteMulticloudDataTransferConfigRequest, Empty, OperationMetadata> deleteMulticloudDataTransferConfigOperationSettings;
        private final PagedCallSettings.Builder<ListDestinationsRequest, ListDestinationsResponse, DataTransferServiceClient.ListDestinationsPagedResponse> listDestinationsSettings;
        private final UnaryCallSettings.Builder<GetDestinationRequest, Destination> getDestinationSettings;
        private final UnaryCallSettings.Builder<CreateDestinationRequest, Operation> createDestinationSettings;
        private final OperationCallSettings.Builder<CreateDestinationRequest, Destination, OperationMetadata> createDestinationOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDestinationRequest, Operation> updateDestinationSettings;
        private final OperationCallSettings.Builder<UpdateDestinationRequest, Destination, OperationMetadata> updateDestinationOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDestinationRequest, Operation> deleteDestinationSettings;
        private final OperationCallSettings.Builder<DeleteDestinationRequest, Empty, OperationMetadata> deleteDestinationOperationSettings;
        private final UnaryCallSettings.Builder<GetMulticloudDataTransferSupportedServiceRequest, MulticloudDataTransferSupportedService> getMulticloudDataTransferSupportedServiceSettings;
        private final PagedCallSettings.Builder<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, DataTransferServiceClient.ListMulticloudDataTransferSupportedServicesPagedResponse> listMulticloudDataTransferSupportedServicesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listMulticloudDataTransferConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MULTICLOUD_DATA_TRANSFER_CONFIGS_PAGE_STR_FACT);
            this.getMulticloudDataTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMulticloudDataTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMulticloudDataTransferConfigOperationSettings = OperationCallSettings.newBuilder();
            this.updateMulticloudDataTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateMulticloudDataTransferConfigOperationSettings = OperationCallSettings.newBuilder();
            this.deleteMulticloudDataTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteMulticloudDataTransferConfigOperationSettings = OperationCallSettings.newBuilder();
            this.listDestinationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DESTINATIONS_PAGE_STR_FACT);
            this.getDestinationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDestinationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDestinationOperationSettings = OperationCallSettings.newBuilder();
            this.updateDestinationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDestinationOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDestinationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDestinationOperationSettings = OperationCallSettings.newBuilder();
            this.getMulticloudDataTransferSupportedServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMulticloudDataTransferSupportedServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MULTICLOUD_DATA_TRANSFER_SUPPORTED_SERVICES_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMulticloudDataTransferConfigsSettings, this.getMulticloudDataTransferConfigSettings, this.createMulticloudDataTransferConfigSettings, this.updateMulticloudDataTransferConfigSettings, this.deleteMulticloudDataTransferConfigSettings, this.listDestinationsSettings, this.getDestinationSettings, this.createDestinationSettings, this.updateDestinationSettings, this.deleteDestinationSettings, this.getMulticloudDataTransferSupportedServiceSettings, this.listMulticloudDataTransferSupportedServicesSettings, (Object[])new UnaryCallSettings.Builder[]{this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DataTransferServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listMulticloudDataTransferConfigsSettings = settings.listMulticloudDataTransferConfigsSettings.toBuilder();
            this.getMulticloudDataTransferConfigSettings = settings.getMulticloudDataTransferConfigSettings.toBuilder();
            this.createMulticloudDataTransferConfigSettings = settings.createMulticloudDataTransferConfigSettings.toBuilder();
            this.createMulticloudDataTransferConfigOperationSettings = settings.createMulticloudDataTransferConfigOperationSettings.toBuilder();
            this.updateMulticloudDataTransferConfigSettings = settings.updateMulticloudDataTransferConfigSettings.toBuilder();
            this.updateMulticloudDataTransferConfigOperationSettings = settings.updateMulticloudDataTransferConfigOperationSettings.toBuilder();
            this.deleteMulticloudDataTransferConfigSettings = settings.deleteMulticloudDataTransferConfigSettings.toBuilder();
            this.deleteMulticloudDataTransferConfigOperationSettings = settings.deleteMulticloudDataTransferConfigOperationSettings.toBuilder();
            this.listDestinationsSettings = settings.listDestinationsSettings.toBuilder();
            this.getDestinationSettings = settings.getDestinationSettings.toBuilder();
            this.createDestinationSettings = settings.createDestinationSettings.toBuilder();
            this.createDestinationOperationSettings = settings.createDestinationOperationSettings.toBuilder();
            this.updateDestinationSettings = settings.updateDestinationSettings.toBuilder();
            this.updateDestinationOperationSettings = settings.updateDestinationOperationSettings.toBuilder();
            this.deleteDestinationSettings = settings.deleteDestinationSettings.toBuilder();
            this.deleteDestinationOperationSettings = settings.deleteDestinationOperationSettings.toBuilder();
            this.getMulticloudDataTransferSupportedServiceSettings = settings.getMulticloudDataTransferSupportedServiceSettings.toBuilder();
            this.listMulticloudDataTransferSupportedServicesSettings = settings.listMulticloudDataTransferSupportedServicesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMulticloudDataTransferConfigsSettings, this.getMulticloudDataTransferConfigSettings, this.createMulticloudDataTransferConfigSettings, this.updateMulticloudDataTransferConfigSettings, this.deleteMulticloudDataTransferConfigSettings, this.listDestinationsSettings, this.getDestinationSettings, this.createDestinationSettings, this.updateDestinationSettings, this.deleteDestinationSettings, this.getMulticloudDataTransferSupportedServiceSettings, this.listMulticloudDataTransferSupportedServicesSettings, (Object[])new UnaryCallSettings.Builder[]{this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataTransferServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataTransferServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataTransferServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataTransferServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listMulticloudDataTransferConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getMulticloudDataTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createMulticloudDataTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateMulticloudDataTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteMulticloudDataTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listDestinationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getDestinationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createDestinationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateDestinationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteDestinationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getMulticloudDataTransferSupportedServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listMulticloudDataTransferSupportedServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createMulticloudDataTransferConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MulticloudDataTransferConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateMulticloudDataTransferConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MulticloudDataTransferConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteMulticloudDataTransferConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createDestinationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Destination.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateDestinationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Destination.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteDestinationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, DataTransferServiceClient.ListMulticloudDataTransferConfigsPagedResponse> listMulticloudDataTransferConfigsSettings() {
            return this.listMulticloudDataTransferConfigsSettings;
        }

        public UnaryCallSettings.Builder<GetMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig> getMulticloudDataTransferConfigSettings() {
            return this.getMulticloudDataTransferConfigSettings;
        }

        public UnaryCallSettings.Builder<CreateMulticloudDataTransferConfigRequest, Operation> createMulticloudDataTransferConfigSettings() {
            return this.createMulticloudDataTransferConfigSettings;
        }

        public OperationCallSettings.Builder<CreateMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig, OperationMetadata> createMulticloudDataTransferConfigOperationSettings() {
            return this.createMulticloudDataTransferConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateMulticloudDataTransferConfigRequest, Operation> updateMulticloudDataTransferConfigSettings() {
            return this.updateMulticloudDataTransferConfigSettings;
        }

        public OperationCallSettings.Builder<UpdateMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig, OperationMetadata> updateMulticloudDataTransferConfigOperationSettings() {
            return this.updateMulticloudDataTransferConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteMulticloudDataTransferConfigRequest, Operation> deleteMulticloudDataTransferConfigSettings() {
            return this.deleteMulticloudDataTransferConfigSettings;
        }

        public OperationCallSettings.Builder<DeleteMulticloudDataTransferConfigRequest, Empty, OperationMetadata> deleteMulticloudDataTransferConfigOperationSettings() {
            return this.deleteMulticloudDataTransferConfigOperationSettings;
        }

        public PagedCallSettings.Builder<ListDestinationsRequest, ListDestinationsResponse, DataTransferServiceClient.ListDestinationsPagedResponse> listDestinationsSettings() {
            return this.listDestinationsSettings;
        }

        public UnaryCallSettings.Builder<GetDestinationRequest, Destination> getDestinationSettings() {
            return this.getDestinationSettings;
        }

        public UnaryCallSettings.Builder<CreateDestinationRequest, Operation> createDestinationSettings() {
            return this.createDestinationSettings;
        }

        public OperationCallSettings.Builder<CreateDestinationRequest, Destination, OperationMetadata> createDestinationOperationSettings() {
            return this.createDestinationOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDestinationRequest, Operation> updateDestinationSettings() {
            return this.updateDestinationSettings;
        }

        public OperationCallSettings.Builder<UpdateDestinationRequest, Destination, OperationMetadata> updateDestinationOperationSettings() {
            return this.updateDestinationOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDestinationRequest, Operation> deleteDestinationSettings() {
            return this.deleteDestinationSettings;
        }

        public OperationCallSettings.Builder<DeleteDestinationRequest, Empty, OperationMetadata> deleteDestinationOperationSettings() {
            return this.deleteDestinationOperationSettings;
        }

        public UnaryCallSettings.Builder<GetMulticloudDataTransferSupportedServiceRequest, MulticloudDataTransferSupportedService> getMulticloudDataTransferSupportedServiceSettings() {
            return this.getMulticloudDataTransferSupportedServiceSettings;
        }

        public PagedCallSettings.Builder<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, DataTransferServiceClient.ListMulticloudDataTransferSupportedServicesPagedResponse> listMulticloudDataTransferSupportedServicesSettings() {
            return this.listMulticloudDataTransferSupportedServicesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public DataTransferServiceStubSettings build() throws IOException {
            return new DataTransferServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

