/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkconnectivity.v1.CreateDestinationRequest;
import com.google.cloud.networkconnectivity.v1.CreateMulticloudDataTransferConfigRequest;
import com.google.cloud.networkconnectivity.v1.DataTransferServiceSettings;
import com.google.cloud.networkconnectivity.v1.DeleteDestinationRequest;
import com.google.cloud.networkconnectivity.v1.DeleteMulticloudDataTransferConfigRequest;
import com.google.cloud.networkconnectivity.v1.Destination;
import com.google.cloud.networkconnectivity.v1.DestinationName;
import com.google.cloud.networkconnectivity.v1.GetDestinationRequest;
import com.google.cloud.networkconnectivity.v1.GetMulticloudDataTransferConfigRequest;
import com.google.cloud.networkconnectivity.v1.GetMulticloudDataTransferSupportedServiceRequest;
import com.google.cloud.networkconnectivity.v1.ListDestinationsRequest;
import com.google.cloud.networkconnectivity.v1.ListDestinationsResponse;
import com.google.cloud.networkconnectivity.v1.ListMulticloudDataTransferConfigsRequest;
import com.google.cloud.networkconnectivity.v1.ListMulticloudDataTransferConfigsResponse;
import com.google.cloud.networkconnectivity.v1.ListMulticloudDataTransferSupportedServicesRequest;
import com.google.cloud.networkconnectivity.v1.ListMulticloudDataTransferSupportedServicesResponse;
import com.google.cloud.networkconnectivity.v1.LocationName;
import com.google.cloud.networkconnectivity.v1.MulticloudDataTransferConfig;
import com.google.cloud.networkconnectivity.v1.MulticloudDataTransferConfigName;
import com.google.cloud.networkconnectivity.v1.MulticloudDataTransferSupportedService;
import com.google.cloud.networkconnectivity.v1.MulticloudDataTransferSupportedServiceName;
import com.google.cloud.networkconnectivity.v1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1.UpdateDestinationRequest;
import com.google.cloud.networkconnectivity.v1.UpdateMulticloudDataTransferConfigRequest;
import com.google.cloud.networkconnectivity.v1.stub.DataTransferServiceStub;
import com.google.cloud.networkconnectivity.v1.stub.DataTransferServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DataTransferServiceClient
implements BackgroundResource {
    private final DataTransferServiceSettings settings;
    private final DataTransferServiceStub stub;
    private final OperationsClient operationsClient;

    public static final DataTransferServiceClient create() throws IOException {
        return DataTransferServiceClient.create(DataTransferServiceSettings.newBuilder().build());
    }

    public static final DataTransferServiceClient create(DataTransferServiceSettings settings) throws IOException {
        return new DataTransferServiceClient(settings);
    }

    public static final DataTransferServiceClient create(DataTransferServiceStub stub) {
        return new DataTransferServiceClient(stub);
    }

    protected DataTransferServiceClient(DataTransferServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataTransferServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected DataTransferServiceClient(DataTransferServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DataTransferServiceSettings getSettings() {
        return this.settings;
    }

    public DataTransferServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListMulticloudDataTransferConfigsPagedResponse listMulticloudDataTransferConfigs(LocationName parent) {
        ListMulticloudDataTransferConfigsRequest request = ListMulticloudDataTransferConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMulticloudDataTransferConfigs(request);
    }

    public final ListMulticloudDataTransferConfigsPagedResponse listMulticloudDataTransferConfigs(String parent) {
        ListMulticloudDataTransferConfigsRequest request = ListMulticloudDataTransferConfigsRequest.newBuilder().setParent(parent).build();
        return this.listMulticloudDataTransferConfigs(request);
    }

    public final ListMulticloudDataTransferConfigsPagedResponse listMulticloudDataTransferConfigs(ListMulticloudDataTransferConfigsRequest request) {
        return (ListMulticloudDataTransferConfigsPagedResponse)((Object)this.listMulticloudDataTransferConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsPagedResponse> listMulticloudDataTransferConfigsPagedCallable() {
        return this.stub.listMulticloudDataTransferConfigsPagedCallable();
    }

    public final UnaryCallable<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse> listMulticloudDataTransferConfigsCallable() {
        return this.stub.listMulticloudDataTransferConfigsCallable();
    }

    public final MulticloudDataTransferConfig getMulticloudDataTransferConfig(MulticloudDataTransferConfigName name) {
        GetMulticloudDataTransferConfigRequest request = GetMulticloudDataTransferConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMulticloudDataTransferConfig(request);
    }

    public final MulticloudDataTransferConfig getMulticloudDataTransferConfig(String name) {
        GetMulticloudDataTransferConfigRequest request = GetMulticloudDataTransferConfigRequest.newBuilder().setName(name).build();
        return this.getMulticloudDataTransferConfig(request);
    }

    public final MulticloudDataTransferConfig getMulticloudDataTransferConfig(GetMulticloudDataTransferConfigRequest request) {
        return (MulticloudDataTransferConfig)this.getMulticloudDataTransferConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig> getMulticloudDataTransferConfigCallable() {
        return this.stub.getMulticloudDataTransferConfigCallable();
    }

    public final OperationFuture<MulticloudDataTransferConfig, OperationMetadata> createMulticloudDataTransferConfigAsync(LocationName parent, MulticloudDataTransferConfig multicloudDataTransferConfig, String multicloudDataTransferConfigId) {
        CreateMulticloudDataTransferConfigRequest request = CreateMulticloudDataTransferConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMulticloudDataTransferConfig(multicloudDataTransferConfig).setMulticloudDataTransferConfigId(multicloudDataTransferConfigId).build();
        return this.createMulticloudDataTransferConfigAsync(request);
    }

    public final OperationFuture<MulticloudDataTransferConfig, OperationMetadata> createMulticloudDataTransferConfigAsync(String parent, MulticloudDataTransferConfig multicloudDataTransferConfig, String multicloudDataTransferConfigId) {
        CreateMulticloudDataTransferConfigRequest request = CreateMulticloudDataTransferConfigRequest.newBuilder().setParent(parent).setMulticloudDataTransferConfig(multicloudDataTransferConfig).setMulticloudDataTransferConfigId(multicloudDataTransferConfigId).build();
        return this.createMulticloudDataTransferConfigAsync(request);
    }

    public final OperationFuture<MulticloudDataTransferConfig, OperationMetadata> createMulticloudDataTransferConfigAsync(CreateMulticloudDataTransferConfigRequest request) {
        return this.createMulticloudDataTransferConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig, OperationMetadata> createMulticloudDataTransferConfigOperationCallable() {
        return this.stub.createMulticloudDataTransferConfigOperationCallable();
    }

    public final UnaryCallable<CreateMulticloudDataTransferConfigRequest, Operation> createMulticloudDataTransferConfigCallable() {
        return this.stub.createMulticloudDataTransferConfigCallable();
    }

    public final OperationFuture<MulticloudDataTransferConfig, OperationMetadata> updateMulticloudDataTransferConfigAsync(MulticloudDataTransferConfig multicloudDataTransferConfig, FieldMask updateMask) {
        UpdateMulticloudDataTransferConfigRequest request = UpdateMulticloudDataTransferConfigRequest.newBuilder().setMulticloudDataTransferConfig(multicloudDataTransferConfig).setUpdateMask(updateMask).build();
        return this.updateMulticloudDataTransferConfigAsync(request);
    }

    public final OperationFuture<MulticloudDataTransferConfig, OperationMetadata> updateMulticloudDataTransferConfigAsync(UpdateMulticloudDataTransferConfigRequest request) {
        return this.updateMulticloudDataTransferConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMulticloudDataTransferConfigRequest, MulticloudDataTransferConfig, OperationMetadata> updateMulticloudDataTransferConfigOperationCallable() {
        return this.stub.updateMulticloudDataTransferConfigOperationCallable();
    }

    public final UnaryCallable<UpdateMulticloudDataTransferConfigRequest, Operation> updateMulticloudDataTransferConfigCallable() {
        return this.stub.updateMulticloudDataTransferConfigCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMulticloudDataTransferConfigAsync(MulticloudDataTransferConfigName name) {
        DeleteMulticloudDataTransferConfigRequest request = DeleteMulticloudDataTransferConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMulticloudDataTransferConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMulticloudDataTransferConfigAsync(String name) {
        DeleteMulticloudDataTransferConfigRequest request = DeleteMulticloudDataTransferConfigRequest.newBuilder().setName(name).build();
        return this.deleteMulticloudDataTransferConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMulticloudDataTransferConfigAsync(DeleteMulticloudDataTransferConfigRequest request) {
        return this.deleteMulticloudDataTransferConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMulticloudDataTransferConfigRequest, Empty, OperationMetadata> deleteMulticloudDataTransferConfigOperationCallable() {
        return this.stub.deleteMulticloudDataTransferConfigOperationCallable();
    }

    public final UnaryCallable<DeleteMulticloudDataTransferConfigRequest, Operation> deleteMulticloudDataTransferConfigCallable() {
        return this.stub.deleteMulticloudDataTransferConfigCallable();
    }

    public final ListDestinationsPagedResponse listDestinations(MulticloudDataTransferConfigName parent) {
        ListDestinationsRequest request = ListDestinationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDestinations(request);
    }

    public final ListDestinationsPagedResponse listDestinations(String parent) {
        ListDestinationsRequest request = ListDestinationsRequest.newBuilder().setParent(parent).build();
        return this.listDestinations(request);
    }

    public final ListDestinationsPagedResponse listDestinations(ListDestinationsRequest request) {
        return (ListDestinationsPagedResponse)((Object)this.listDestinationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDestinationsRequest, ListDestinationsPagedResponse> listDestinationsPagedCallable() {
        return this.stub.listDestinationsPagedCallable();
    }

    public final UnaryCallable<ListDestinationsRequest, ListDestinationsResponse> listDestinationsCallable() {
        return this.stub.listDestinationsCallable();
    }

    public final Destination getDestination(DestinationName name) {
        GetDestinationRequest request = GetDestinationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDestination(request);
    }

    public final Destination getDestination(String name) {
        GetDestinationRequest request = GetDestinationRequest.newBuilder().setName(name).build();
        return this.getDestination(request);
    }

    public final Destination getDestination(GetDestinationRequest request) {
        return (Destination)this.getDestinationCallable().call((Object)request);
    }

    public final UnaryCallable<GetDestinationRequest, Destination> getDestinationCallable() {
        return this.stub.getDestinationCallable();
    }

    public final OperationFuture<Destination, OperationMetadata> createDestinationAsync(MulticloudDataTransferConfigName parent, Destination destination, String destinationId) {
        CreateDestinationRequest request = CreateDestinationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDestination(destination).setDestinationId(destinationId).build();
        return this.createDestinationAsync(request);
    }

    public final OperationFuture<Destination, OperationMetadata> createDestinationAsync(String parent, Destination destination, String destinationId) {
        CreateDestinationRequest request = CreateDestinationRequest.newBuilder().setParent(parent).setDestination(destination).setDestinationId(destinationId).build();
        return this.createDestinationAsync(request);
    }

    public final OperationFuture<Destination, OperationMetadata> createDestinationAsync(CreateDestinationRequest request) {
        return this.createDestinationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDestinationRequest, Destination, OperationMetadata> createDestinationOperationCallable() {
        return this.stub.createDestinationOperationCallable();
    }

    public final UnaryCallable<CreateDestinationRequest, Operation> createDestinationCallable() {
        return this.stub.createDestinationCallable();
    }

    public final OperationFuture<Destination, OperationMetadata> updateDestinationAsync(Destination destination, FieldMask updateMask) {
        UpdateDestinationRequest request = UpdateDestinationRequest.newBuilder().setDestination(destination).setUpdateMask(updateMask).build();
        return this.updateDestinationAsync(request);
    }

    public final OperationFuture<Destination, OperationMetadata> updateDestinationAsync(UpdateDestinationRequest request) {
        return this.updateDestinationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDestinationRequest, Destination, OperationMetadata> updateDestinationOperationCallable() {
        return this.stub.updateDestinationOperationCallable();
    }

    public final UnaryCallable<UpdateDestinationRequest, Operation> updateDestinationCallable() {
        return this.stub.updateDestinationCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDestinationAsync(DestinationName name) {
        DeleteDestinationRequest request = DeleteDestinationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDestinationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDestinationAsync(String name) {
        DeleteDestinationRequest request = DeleteDestinationRequest.newBuilder().setName(name).build();
        return this.deleteDestinationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDestinationAsync(DeleteDestinationRequest request) {
        return this.deleteDestinationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDestinationRequest, Empty, OperationMetadata> deleteDestinationOperationCallable() {
        return this.stub.deleteDestinationOperationCallable();
    }

    public final UnaryCallable<DeleteDestinationRequest, Operation> deleteDestinationCallable() {
        return this.stub.deleteDestinationCallable();
    }

    public final MulticloudDataTransferSupportedService getMulticloudDataTransferSupportedService(MulticloudDataTransferSupportedServiceName name) {
        GetMulticloudDataTransferSupportedServiceRequest request = GetMulticloudDataTransferSupportedServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMulticloudDataTransferSupportedService(request);
    }

    public final MulticloudDataTransferSupportedService getMulticloudDataTransferSupportedService(String name) {
        GetMulticloudDataTransferSupportedServiceRequest request = GetMulticloudDataTransferSupportedServiceRequest.newBuilder().setName(name).build();
        return this.getMulticloudDataTransferSupportedService(request);
    }

    public final MulticloudDataTransferSupportedService getMulticloudDataTransferSupportedService(GetMulticloudDataTransferSupportedServiceRequest request) {
        return (MulticloudDataTransferSupportedService)this.getMulticloudDataTransferSupportedServiceCallable().call((Object)request);
    }

    public final UnaryCallable<GetMulticloudDataTransferSupportedServiceRequest, MulticloudDataTransferSupportedService> getMulticloudDataTransferSupportedServiceCallable() {
        return this.stub.getMulticloudDataTransferSupportedServiceCallable();
    }

    public final ListMulticloudDataTransferSupportedServicesPagedResponse listMulticloudDataTransferSupportedServices(LocationName parent) {
        ListMulticloudDataTransferSupportedServicesRequest request = ListMulticloudDataTransferSupportedServicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMulticloudDataTransferSupportedServices(request);
    }

    public final ListMulticloudDataTransferSupportedServicesPagedResponse listMulticloudDataTransferSupportedServices(String parent) {
        ListMulticloudDataTransferSupportedServicesRequest request = ListMulticloudDataTransferSupportedServicesRequest.newBuilder().setParent(parent).build();
        return this.listMulticloudDataTransferSupportedServices(request);
    }

    public final ListMulticloudDataTransferSupportedServicesPagedResponse listMulticloudDataTransferSupportedServices(ListMulticloudDataTransferSupportedServicesRequest request) {
        return (ListMulticloudDataTransferSupportedServicesPagedResponse)((Object)this.listMulticloudDataTransferSupportedServicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesPagedResponse> listMulticloudDataTransferSupportedServicesPagedCallable() {
        return this.stub.listMulticloudDataTransferSupportedServicesPagedCallable();
    }

    public final UnaryCallable<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse> listMulticloudDataTransferSupportedServicesCallable() {
        return this.stub.listMulticloudDataTransferSupportedServicesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMulticloudDataTransferSupportedServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, MulticloudDataTransferSupportedService, ListMulticloudDataTransferSupportedServicesPage, ListMulticloudDataTransferSupportedServicesFixedSizeCollection> {
        private ListMulticloudDataTransferSupportedServicesFixedSizeCollection(List<ListMulticloudDataTransferSupportedServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMulticloudDataTransferSupportedServicesFixedSizeCollection createEmptyCollection() {
            return new ListMulticloudDataTransferSupportedServicesFixedSizeCollection(null, 0);
        }

        protected ListMulticloudDataTransferSupportedServicesFixedSizeCollection createCollection(List<ListMulticloudDataTransferSupportedServicesPage> pages, int collectionSize) {
            return new ListMulticloudDataTransferSupportedServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMulticloudDataTransferSupportedServicesPage
    extends AbstractPage<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, MulticloudDataTransferSupportedService, ListMulticloudDataTransferSupportedServicesPage> {
        private ListMulticloudDataTransferSupportedServicesPage(PageContext<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, MulticloudDataTransferSupportedService> context, ListMulticloudDataTransferSupportedServicesResponse response) {
            super(context, (Object)response);
        }

        private static ListMulticloudDataTransferSupportedServicesPage createEmptyPage() {
            return new ListMulticloudDataTransferSupportedServicesPage(null, null);
        }

        protected ListMulticloudDataTransferSupportedServicesPage createPage(PageContext<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, MulticloudDataTransferSupportedService> context, ListMulticloudDataTransferSupportedServicesResponse response) {
            return new ListMulticloudDataTransferSupportedServicesPage(context, response);
        }

        public ApiFuture<ListMulticloudDataTransferSupportedServicesPage> createPageAsync(PageContext<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, MulticloudDataTransferSupportedService> context, ApiFuture<ListMulticloudDataTransferSupportedServicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMulticloudDataTransferSupportedServicesPagedResponse
    extends AbstractPagedListResponse<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, MulticloudDataTransferSupportedService, ListMulticloudDataTransferSupportedServicesPage, ListMulticloudDataTransferSupportedServicesFixedSizeCollection> {
        public static ApiFuture<ListMulticloudDataTransferSupportedServicesPagedResponse> createAsync(PageContext<ListMulticloudDataTransferSupportedServicesRequest, ListMulticloudDataTransferSupportedServicesResponse, MulticloudDataTransferSupportedService> context, ApiFuture<ListMulticloudDataTransferSupportedServicesResponse> futureResponse) {
            ApiFuture<ListMulticloudDataTransferSupportedServicesPage> futurePage = ListMulticloudDataTransferSupportedServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMulticloudDataTransferSupportedServicesPagedResponse((ListMulticloudDataTransferSupportedServicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMulticloudDataTransferSupportedServicesPagedResponse(ListMulticloudDataTransferSupportedServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMulticloudDataTransferSupportedServicesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDestinationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDestinationsRequest, ListDestinationsResponse, Destination, ListDestinationsPage, ListDestinationsFixedSizeCollection> {
        private ListDestinationsFixedSizeCollection(List<ListDestinationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDestinationsFixedSizeCollection createEmptyCollection() {
            return new ListDestinationsFixedSizeCollection(null, 0);
        }

        protected ListDestinationsFixedSizeCollection createCollection(List<ListDestinationsPage> pages, int collectionSize) {
            return new ListDestinationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDestinationsPage
    extends AbstractPage<ListDestinationsRequest, ListDestinationsResponse, Destination, ListDestinationsPage> {
        private ListDestinationsPage(PageContext<ListDestinationsRequest, ListDestinationsResponse, Destination> context, ListDestinationsResponse response) {
            super(context, (Object)response);
        }

        private static ListDestinationsPage createEmptyPage() {
            return new ListDestinationsPage(null, null);
        }

        protected ListDestinationsPage createPage(PageContext<ListDestinationsRequest, ListDestinationsResponse, Destination> context, ListDestinationsResponse response) {
            return new ListDestinationsPage(context, response);
        }

        public ApiFuture<ListDestinationsPage> createPageAsync(PageContext<ListDestinationsRequest, ListDestinationsResponse, Destination> context, ApiFuture<ListDestinationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDestinationsPagedResponse
    extends AbstractPagedListResponse<ListDestinationsRequest, ListDestinationsResponse, Destination, ListDestinationsPage, ListDestinationsFixedSizeCollection> {
        public static ApiFuture<ListDestinationsPagedResponse> createAsync(PageContext<ListDestinationsRequest, ListDestinationsResponse, Destination> context, ApiFuture<ListDestinationsResponse> futureResponse) {
            ApiFuture<ListDestinationsPage> futurePage = ListDestinationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDestinationsPagedResponse((ListDestinationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDestinationsPagedResponse(ListDestinationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDestinationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMulticloudDataTransferConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, MulticloudDataTransferConfig, ListMulticloudDataTransferConfigsPage, ListMulticloudDataTransferConfigsFixedSizeCollection> {
        private ListMulticloudDataTransferConfigsFixedSizeCollection(List<ListMulticloudDataTransferConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMulticloudDataTransferConfigsFixedSizeCollection createEmptyCollection() {
            return new ListMulticloudDataTransferConfigsFixedSizeCollection(null, 0);
        }

        protected ListMulticloudDataTransferConfigsFixedSizeCollection createCollection(List<ListMulticloudDataTransferConfigsPage> pages, int collectionSize) {
            return new ListMulticloudDataTransferConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMulticloudDataTransferConfigsPage
    extends AbstractPage<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, MulticloudDataTransferConfig, ListMulticloudDataTransferConfigsPage> {
        private ListMulticloudDataTransferConfigsPage(PageContext<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, MulticloudDataTransferConfig> context, ListMulticloudDataTransferConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListMulticloudDataTransferConfigsPage createEmptyPage() {
            return new ListMulticloudDataTransferConfigsPage(null, null);
        }

        protected ListMulticloudDataTransferConfigsPage createPage(PageContext<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, MulticloudDataTransferConfig> context, ListMulticloudDataTransferConfigsResponse response) {
            return new ListMulticloudDataTransferConfigsPage(context, response);
        }

        public ApiFuture<ListMulticloudDataTransferConfigsPage> createPageAsync(PageContext<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, MulticloudDataTransferConfig> context, ApiFuture<ListMulticloudDataTransferConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMulticloudDataTransferConfigsPagedResponse
    extends AbstractPagedListResponse<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, MulticloudDataTransferConfig, ListMulticloudDataTransferConfigsPage, ListMulticloudDataTransferConfigsFixedSizeCollection> {
        public static ApiFuture<ListMulticloudDataTransferConfigsPagedResponse> createAsync(PageContext<ListMulticloudDataTransferConfigsRequest, ListMulticloudDataTransferConfigsResponse, MulticloudDataTransferConfig> context, ApiFuture<ListMulticloudDataTransferConfigsResponse> futureResponse) {
            ApiFuture<ListMulticloudDataTransferConfigsPage> futurePage = ListMulticloudDataTransferConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMulticloudDataTransferConfigsPagedResponse((ListMulticloudDataTransferConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMulticloudDataTransferConfigsPagedResponse(ListMulticloudDataTransferConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMulticloudDataTransferConfigsFixedSizeCollection.createEmptyCollection());
        }
    }
}

